# House Maintenance

## Annual Schedule

### Monthly
- [ ] Test smoke/CO detectors
- [ ] Check HVAC filter (replace every 1-3 months)
- [ ] Run water in unused fixtures (prevents drain traps drying)
- [ ] Check under sinks for leaks

### Quarterly
- [ ] Test garage door auto-reverse
- [ ] Clean range hood filter
- [ ] Check water heater for leaks/rust
- [ ] Test GFCI outlets (press test/reset)

### Spring (March-May)
- [ ] HVAC tune-up (AC prep)
- [ ] Clean gutters
- [ ] Inspect roof for winter damage
- [ ] Check exterior paint/siding
- [ ] Service irrigation system
- [ ] Power wash deck/patio
- [ ] Check window/door screens

### Summer (June-August)
- [ ] Touch up exterior paint
- [ ] Seal driveway cracks
- [ ] Check attic ventilation
- [ ] Deep clean garbage disposal
- [ ] Inspect deck for rot/damage

### Fall (September-November)
- [ ] HVAC tune-up (heating prep)
- [ ] Clean gutters again (leaves)
- [ ] Winterize irrigation
- [ ] Check weatherstripping
- [ ] Reverse ceiling fans (clockwise)
- [ ] Service fireplace/chimney
- [ ] Check insulation in attic

### Winter (December-February)
- [ ] Monitor for ice dams
- [ ] Keep gutters clear
- [ ] Check for drafts
- [ ] Test sump pump
- [ ] Check pipe insulation

---

## DIY Repairs

### Running toilet
1. Remove tank lid
2. Check flapper — replace if warped/worn ($5 part)
3. Check fill valve — adjust or replace if running constantly
4. Check float — adjust height if water too high

### Slow drain
1. Remove stopper, clear hair/debris
2. Plunger (cover overflow first)
3. Baking soda + vinegar (15 min, then hot water)
4. Drain snake for deeper clogs
5. Don't use chemical drain cleaners (damages pipes)

### Squeaky door
1. Remove hinge pin
2. Apply WD-40 or petroleum jelly
3. Replace pin, work door back and forth

### Caulk replacement
1. Remove old caulk with razor/tool
2. Clean with rubbing alcohol
3. Apply painter's tape for clean lines
4. Apply caulk in one smooth motion
5. Smooth with wet finger
6. Remove tape immediately

---

## When to Call a Pro

**Immediately (emergency):**
- Gas smell → Evacuate, call gas company
- Flooding → Shut off water main, call plumber
- Electrical burning smell → Kill breaker, call electrician
- No heat in winter → HVAC emergency service

**Soon (within days):**
- Water heater leaking
- AC not cooling (summer)
- Roof leak
- Electrical issues (flickering, sparking)

**Scheduled (within weeks):**
- Minor plumbing leaks
- HVAC not efficient
- Appliance repairs
- Cosmetic damage

---

## Cost Estimates (USD)

| Service | Typical Range |
|---------|---------------|
| HVAC tune-up | $75-200 |
| Furnace replacement | $3,000-7,000 |
| AC replacement | $3,500-7,500 |
| Water heater replacement | $800-1,500 |
| Roof repair | $300-1,000 |
| Roof replacement | $5,000-15,000 |
| Gutter cleaning | $100-250 |
| Plumber (per hour) | $75-150 |
| Electrician (per hour) | $80-150 |

---

## Record Keeping

Track all maintenance and repairs:
- Date and description
- Cost (parts + labor)
- Contractor name and contact
- Warranty information
- Before/after photos

Why: Proves maintenance history for resale, warranty claims, insurance claims.
