---
name: House
description: Buy, maintain, improve, and sell homes with inspection checklists, maintenance schedules, renovation planning, and transaction guidance.
---

## Decision Tree

| Situation | Action |
|-----------|--------|
| Buying a house | Check `buying.md` for search, offers, inspection, closing |
| Ongoing maintenance | Check `maintenance.md` for schedules, DIY vs pro, seasonal tasks |
| Renovation or improvement | Check `improvements.md` for permits, contractors, budgets, ROI |
| Selling your house | Check `selling.md` for pricing, staging, offers, closing |
| Renting out property | Check `renting.md` for tenants, leases, management, legal |

---

## Universal Rules

**The biggest mistakes are emotional:** Overpaying because you "fell in love," skipping inspection to beat competition, renovating based on personal taste vs resale value, pricing based on what you need vs market reality.

**Everything is negotiable:** Purchase price, closing costs, repair credits, appliances, closing date, contingencies. The only non-negotiable is leverage — who wants the deal more.

**Maintenance prevents catastrophe:** A $200 annual HVAC service prevents a $8,000 replacement. A $50 gutter clean prevents $15,000 foundation damage. Deferred maintenance compounds.

**Permits exist for safety and resale:** Unpermitted work = liability. Buyers discover it, insurance denies claims, you can't sell. When in doubt, pull the permit.

---

## Quick Reference

**Seasonal maintenance cycle:**

| Season | Critical Tasks |
|--------|----------------|
| Spring | HVAC service, gutter clean, check roof for winter damage, test irrigation |
| Summer | Exterior painting window, seal driveway, check AC performance |
| Fall | Furnace service, clean gutters again, winterize irrigation, check weatherstripping |
| Winter | Check insulation, monitor for ice dams, test smoke/CO detectors |

**When to DIY vs call a pro:**

| DIY | Always hire |
|-----|-------------|
| Paint, caulk, weatherstripping | Electrical panel work |
| Basic plumbing (faucets, toilets) | Structural changes |
| Landscaping, mulch | Gas lines, water heater |
| Changing filters, basic cleaning | Roof repair, foundation |

---

## Cost Sanity Check

Before approving any major expense:
1. Get 3 quotes minimum (wide variance is normal)
2. Search "[project] + [your city] + cost 2024" for local rates
3. Materials are 40-50% of total; rest is labor
4. "While we're at it" add-ons double budgets — decide scope upfront

---

## When to Load More

| Situation | Reference |
|-----------|-----------|
| Searching, making offers, closing | `buying.md` |
| Repairs, preventive maintenance, emergencies | `maintenance.md` |
| Projects, permits, contractors | `improvements.md` |
| Pricing, staging, negotiations, closing | `selling.md` |
| Tenants, leases, rent collection, evictions | `renting.md` |
