---
summary: "Hostinger VPS Optimizer: Performance tweaks & cost-saving configs for Hostinger VPS plans."
description: "Apply battle-tested optimizations for KVM/Cloud VPS: kernel tuning, caching, security hardening, auto-scaling."
triggers:
  - "optimize hostinger VPS"
  - "hostinger tweaks"
  - "VPS cost save"
  - "hostinger performance"
read_when:
  - "hostinger VPS" in message
---

# Hostinger VPS Optimizer v1.0.0

## 🎯 Purpose
Boost speed 2-5x, cut costs 20-50% on Hostinger VPS:
- Sysctl tuning (TCP, VM)
- Nginx/Apache optimization
- Fail2ban + UFW
- Resource limits
- Cost analysis vs plans

## 🚀 Quick Start
```
!hostinger-vps-optimizer --plan kvm2 --focus speed
```

## Files
- `scripts/optimize.sh`: One-click optimizer
- `configs/hostinger.sysctl`: Pre-tuned configs

## Plans Supported
KVM 1-8, Cloud Startup/Pro.
