# Hong Kong Practical Tips

> Last updated: February 2025

## The Octopus Card - Your Best Friend

### What It Is
A rechargeable contactless payment card used for almost EVERYTHING in Hong Kong:
- MTR (subway)
- Buses
- Trams
- Ferries (including Star Ferry)
- 7-Eleven, Circle K
- Supermarkets
- Many restaurants and shops
- Vending machines

### Where to Get It

**At the Airport:**
- MTR Customer Service Centre (Arrivals Hall)
- HK$150 (includes HK$50 deposit + HK$100 stored value)

**In the City:**
- Any MTR station
- 7-Eleven, Circle K

### Types of Octopus

| Type | Deposit | Best For |
|------|---------|----------|
| **Standard (On-Loan)** | HK$50 | Regular visitors, refundable |
| **Tourist Octopus (Sold)** | HK$39 | Souvenirs, non-refundable |

### Top-Up Options
- MTR stations (add value machines)
- 7-Eleven / Circle K (ask cashier)
- Minimum top-up: HK$50

### Getting Your Deposit Back
- Return at MTR Customer Service Centre
- Refundable within 90 days of issue (otherwise HK$11 fee)
- Get remaining balance + HK$50 deposit

### Pro Tips
- **Apple Wallet / Google Pay:** You can add a virtual Octopus (HK$50 setup fee, no physical card)
- **Check balance:** Tap at any reader or use Octopus App
- **Negative balance allowed:** Up to -HK$35 (one trip grace), then must top up

---

## Tipping Culture - KEEP YOUR MONEY

### The Short Version
**Hong Kong does NOT have a tipping culture.** Don't feel obligated to tip.

### The Details

| Situation | Expectation |
|-----------|-------------|
| Restaurants | 10% service charge usually INCLUDED in bill |
| Cafes / Fast Food | No tip expected |
| Taxis | Round up to nearest dollar (optional) |
| Hotel bellhop | HK$10-20 per bag (optional) |
| Hotel housekeeping | Not expected |
| Bars | Not expected |
| Haircuts | Not expected |

### Important Notes
- Check your bill - "Service Charge: 10%" means tip is included
- Leaving extra on top of service charge is NOT expected
- High-end Western restaurants may expect tips (follow Western norms)
- If there's NO service charge, small tip (5-10%) is appreciated but not required

---

## Day Trips From Hong Kong

### Macau 
**The Vegas of Asia** - casinos, Portuguese colonial heritage, egg tarts.

**Getting There:**
| Method | Cost | Time | Notes |
|--------|------|------|-------|
| TurboJET Ferry | HK$170-200 | 60 min | From Sheung Wan or TST |
| Cotai Water Jet | HK$170-200 | 60 min | Goes to Taipa (Cotai strip) |
| HZMB Bus | HK$65 | 45 min | Cheapest, uses new bridge |

**Must-Do in Macau:**
- Ruins of St. Paul's
- Senado Square
- A-Ma Temple
- Lord Stow's egg tarts
- Walk through Venetian (free, just for gawking)

**Tips:**
- Bring passport (immigration required)
- HKD accepted everywhere (1:1 with MOP)
- Most attractions are free
- Casinos: 21+ only, dress code varies

---

### Shenzhen 
**Mainland China's tech hub** - shopping, electronics, massages.

**Getting There:**
- MTR East Rail Line to **Lo Wu** or **Lok Ma Chau** border
- HK$50, 45-60 min from TST

**What to Know:**
- **Visa required** for most nationalities
- China Transit Visa (144-hour) may work if transiting
- Different currency: Chinese Yuan (CNY/RMB)
- WeChat Pay / Alipay dominant (cash accepted but less convenient)
- Great Wall of knockoffs and electronics

**Honest take:** Unless you have specific business or visa-free transit, skip it. Macau is easier and more interesting for tourists.

---

### Outlying Islands

#### Lamma Island 
**Best for:** Seafood, hiking, escaping the city
**Ferry:** Central Pier 4, HK$20-35, 30 min
**Highlights:** Car-free, rainbow restaurants, beaches

#### Cheung Chau Island 
**Best for:** Day trip, local vibe, fish balls
**Ferry:** Central Pier 5, HK$15-30, 35-55 min
**Highlights:** Mini beaches, temples, bicycle rental

#### Peng Chau Island 
**Best for:** Quiet afternoon, art spaces
**Ferry:** Central Pier 6, HK$15-25, 25 min
**Highlights:** Old leather factory gallery, tiny streets

---

## Seasonal Considerations

### Weather by Month

| Season | Months | Temp | What to Expect |
|--------|--------|------|----------------|
| **Winter** | Dec-Feb | 14-20C | Mild, occasional cold fronts, dry |
| **Spring** | Mar-May | 18-27C | Humid, foggy, can be rainy |
| **Summer** | Jun-Sep | 27-32C | Hot, humid, typhoons, rain |
| **Autumn** | Oct-Nov | 20-28C | Best weather! Clear, comfortable |

### Best Time to Visit
**October - December:** Clear skies, comfortable temperatures, perfect for outdoor activities. Peak season, book ahead.

### Typhoon Season (June-September)
- Typhoons are common but rarely dangerous for tourists
- **Signal 8+:** Public transport stops, shops close, stay indoors
- **Signal 3:** Business as usual but watch the news
- Check Hong Kong Observatory: `hko.gov.hk`

### What to Pack by Season

**Summer (Jun-Sep):**
- Light, breathable clothes
- Umbrella (essential!)
- Sunscreen
- Light jacket (AC is FREEZING indoors)

**Winter (Dec-Feb):**
- Layers (buildings often not heated)
- Light jacket/sweater
- Umbrella (occasional rain)

**Year-round:**
- Comfortable walking shoes
- Universal power adapter (UK-style 3-pin plugs)

---

## What NOT To Do

###  Don't Block Escalators
Stand on the RIGHT, walk on the LEFT. This is SERIOUS BUSINESS.

###  Don't Eat on MTR
No food or drinks on trains. HK$2,000 fine.

###  Don't Jaywalk
Fines up to HK$2,000. Use pedestrian crossings.

###  Don't Expect Personal Space
Hong Kong is CROWDED. People will push, jostle, and squeeze. It's not rude, it's survival.

###  Don't Use Taxis for Short Distances
MTR is faster. Taxis get stuck in traffic and are expensive compared to public transport.

###  Don't Carry Large Bills Only
Many small shops, taxis, and vendors can't break HK$500 or HK$1000. Carry smaller denominations.

###  Don't Expect English Everywhere
Central, TST, and tourist areas = English OK. 
Mong Kok, local neighborhoods = Less English. Google Translate helps.

###  Don't Skip the Octopus Card
Cash is accepted but MUCH less convenient. Get the card first thing.

###  Don't Schedule Tight Connections
Traffic jams happen. MTR delays happen. Leave buffer time.

###  Don't Forget to Look Up
Hong Kong's best views are UP - rooftops, skyscrapers, the Peak. And DOWN - underground malls, MTR connections stretch forever.

---

## Useful Information

### Emergency Numbers
- **Police / Fire / Ambulance:** 999
- **Police (non-emergency):** 2527 7177

### Currency
- **Hong Kong Dollar (HKD / HK$)**
- Exchange rate: ~HK$7.8 = $1 USD
- Credit cards widely accepted in malls/hotels
- Cash needed for street food, small shops, taxis

### Language
- **Official:** Chinese (Cantonese) and English
- **Reality:** Cantonese dominant, English in tourist/business areas
- Signage usually bilingual
- Google Translate works well

### Electricity
- **220V, 50Hz**
- **UK-style 3-pin plugs (Type G)**
- Bring a universal adapter

### WiFi
- Free WiFi at MTR stations, malls, many cafes
- Consider pocket WiFi or local SIM for convenience
- **SIM cards:** Available at airport, HK$50-100 for tourist data plans

### Working Hours
- **Shops:** 10AM-10PM (malls often until 10-11PM)
- **Restaurants:** 11AM-11PM (varies)
- **Banks:** 9AM-5PM weekdays
- **MTR:** 6AM-1AM

### Public Holidays 2025
- Chinese New Year (late Jan/early Feb) - EVERYTHING closes
- Easter (Apr) - Some closures
- Buddha's Birthday (May) - Limited impact
- Dragon Boat Festival (Jun) - Limited impact
- Mid-Autumn Festival (Sep) - Some closures
- National Day (Oct 1) - Limited impact
- Christmas (Dec 25-26) - Some closures

---

## Quick Survival Phrases (Cantonese)

| English | Cantonese | Pronunciation |
|---------|-----------|---------------|
| Hello |  | Nei5 hou2 |
| Thank you |  | M4 goi1 |
| How much? | ? | Gei2 cin2? |
| Too expensive |  | Taai3 gwai3 |
| Delicious |  | Hou2 sik6 |
| Check please |  | Maai4 daan1 |
| Where is...? | ...? | ...hai2 bin1 dou6? |
| MTR station |  | Dei6 tit3 zaam6 |

**Pro tip:** Most Hong Kongers appreciate ANY attempt at Cantonese, even if it's terrible.

---

## Money-Saving Hacks

1. **Octopus Card**: 5% cheaper than single tickets on MTR
2. **Ding Ding Tram**: HK$3.20 for unlimited distance
3. **Dim Sum Lunch**: 30-50% cheaper than dinner
4. **Museum Free Days**: Many museums free on Wednesdays
5. **Water**: Bring reusable bottle, tap water is safe
6. **7-Eleven Meals**: Sandwiches HK$15-25, decent quality
7. **Bus to Peak**: HK$12 vs HK$62 tram
8. **Dai Pai Dong**: Local food stalls, HK$40-60 for full meal
9. **Star Ferry**: HK$5 for best harbour views (vs HK$200+ tours)
10. **HZMB Bus to Macau**: HK$65 vs HK$170+ ferry

---

*All information current as of 2024-2025. Prices and policies may change.*
