# Hong Kong Visa & Immigration Guide 2025

## Overview: Immigration Pathways

Hong Kong offers several visa pathways for skilled professionals, entrepreneurs, and investors. The government has been actively attracting talent through enhanced schemes since 2022.

### Main Visa Categories

| Visa Type | Best For | Duration | Job Offer Required? |
|-----------|----------|----------|---------------------|
| **Employment Visa** | Professionals with job offer | 1-2 years | Yes |
| **Top Talent Pass (TTPS)** | High earners / Top uni grads | 2-3 years | No |
| **QMAS** | Skilled migrants (points-based) | 1 year initial | No |
| **Investment Visa (GEP)** | Entrepreneurs/Investors | 2 years | No (but business plan) |
| **Dependent Visa** | Spouse/children | Tied to sponsor | N/A |
| **Working Holiday** | Young adults (specific countries) | 1 year | No |

---

## Top Talent Pass Scheme (TTPS) - NEW & Popular

Launched December 2022, this is now the **fastest route** for qualified professionals.

### Categories

#### Category A: High Income
| Requirement | Details |
|-------------|---------|
| Income | HK$2.5 million+ annual (~US$320,000) in year before application |
| Proof | Tax returns, salary slips, company profits |
| Initial visa | **3 years** (extended from 2 years in 2024) |
| Job needed? | No |

#### Category B: Top University + Experience
| Requirement | Details |
|-------------|---------|
| Education | Bachelor's degree from top 100 university (QS, Times, USNWR, ARWU) |
| Experience | **3+ years** work experience in past 5 years |
| Initial visa | 2 years |
| Job needed? | No |

#### Category C: Recent Graduate
| Requirement | Details |
|-------------|---------|
| Education | Bachelor's degree from top 100 university |
| Graduation | Within **5 years** of application |
| Experience | None required |
| Initial visa | 2 years |
| Job needed? | No |
| Annual quota | 10,000 per year (Category C only) |

### Top 100 Universities (Examples)

The aggregate list includes ~185 institutions from combined rankings:
- MIT, Stanford, Harvard, Caltech
- Oxford, Cambridge, Imperial, UCL
- ETH Zurich, EPFL
- NUS, NTU (Singapore)
- University of Hong Kong, HKUST, CUHK
- Tsinghua, Peking, Fudan
- University of Tokyo, Kyoto University
- University of Melbourne, Sydney, ANU

*Full list: immd.gov.hk/pdf/aggregate_list.pdf*

### TTPS Application Process

1. **Prepare documents**
   - Valid passport
   - Graduation certificate + transcript
   - Proof of work experience (Category B)
   - Proof of income (Category A)
   - ID photo

2. **Submit online or by mail**
   - Online: e-visa application
   - Processing: ~4 weeks (often faster)

3. **Receive approval-in-principle**
   - Valid 6 months to enter HK

4. **Enter Hong Kong**
   - Visa label/sticker issued

5. **Activate stay**
   - Start 2-3 year permission

### TTPS Renewal (Important 2025 Updates)

**Key requirement**: Must demonstrate **employment or business** in Hong Kong for renewal

| Requirement | Details |
|-------------|---------|
| Employment | Full-time job in Hong Kong, OR |
| Business | Operating a business contributing to HK economy |
| Minimum stay | 2 years on TTPS before renewal |
| Income for A | Must maintain high income level |

**Renewal extension pattern**: 2+3+3 or 3+3+3 years

---

## Employment Visa (Sponsored)

### Requirements

| Requirement | Details |
|-------------|---------|
| Job offer | From Hong Kong employer |
| Qualifications | Degree or proven expertise |
| Skills | Not readily available locally |
| Salary | Market-appropriate |
| Company | Genuine business with track record |

### Process

1. Employer applies on your behalf
2. Submit ID990A (employer) + ID990B (applicant)
3. Processing: 4-6 weeks
4. Approval  Travel to HK  Visa issued

### Visa Duration

- Initial: Usually 2 years
- Extension: 3 years, then 3 years
- After 7 years: Eligible for Permanent Residence

### Job Change

- Must notify Immigration Department
- Apply for visa transfer to new employer
- Cannot work for new employer until approved

---

## Quality Migrant Admission Scheme (QMAS)

Points-based scheme for skilled migrants **without a job offer**.

### Two Assessment Systems

#### General Points Test
| Factor | Max Points |
|--------|------------|
| Age | 30 (18-39 optimal) |
| Academic qualifications | 70 |
| Work experience | 75 |
| Language proficiency | 20 |
| Family background | 20 |
| **Passing score** | **80 points** minimum |

#### Achievement-Based Points Test
- For exceptional talent
- Nobel Prize, Olympic medal, or equivalent
- 195 points awarded automatically

### QMAS Process

1. Submit application with documents
2. Initial screening
3. Quarterly selection exercises
4. Approval-in-principle (valid 6 months)
5. Enter Hong Kong
6. Apply for extension after 1 year

### QMAS vs TTPS

| Factor | QMAS | TTPS |
|--------|------|------|
| Points test | Yes | No |
| Job required | No | No |
| Processing | Longer (quota-based) | Faster |
| Initial visa | 1 year | 2-3 years |
| Flexibility | More subjective | Clear criteria |
| Quota | Limited | Higher (Category C only) |

**Recommendation**: If eligible for TTPS, use TTPS (faster, longer visa)

---

## Investment/Entrepreneur Visa (GEP)

For those starting or joining a business in Hong Kong.

### Requirements

| Requirement | Details |
|-------------|---------|
| Business plan | Viable business contributing to HK economy |
| Investment | Substantial (no fixed minimum) |
| Background | Relevant experience/qualifications |
| Job creation | Preferably creating local jobs |
| Premises | Business address in Hong Kong |

### Typical Evidence Needed

- 2-year business plan
- Financial projections
- Proof of investment funds
- Company registration (if formed)
- Contracts, LOIs, clients
- Personal CV and qualifications

### Capital Investment Entrant Scheme (CIES)

Relaunched in 2024 for high-net-worth individuals:

| Requirement | Details |
|-------------|---------|
| Net assets | HK$30 million minimum |
| Investment | HK$30 million in permitted assets |
| Permitted assets | HK equities, bonds, funds, deposits |
| Residential property | **Not** eligible |
| Duration | 2 years initial, renewable |

---

## Dependent Visa

### Who Qualifies

- **Spouse** (legally married)
- **Unmarried children** under 18
- **Parents** aged 60+ (of permanent resident only)

### Sponsor Requirements

The principal visa holder must:
- Hold valid employment/TTPS/QMAS/Investment visa
- Demonstrate ability to support dependents
- Provide accommodation

### Dependent Rights

| Right | Details |
|-------|---------|
| Work | **Yes** - no separate work visa needed |
| Study | Yes |
| Stay | Tied to sponsor's visa |
| Independent visa | After 7 years (own PR application) |

### Application

- Apply at same time as principal, OR
- Apply separately after principal is approved
- Processing: 4-6 weeks

---

## Path to Permanent Residence (PR)

### 7-Year Rule

After **7 years of continuous ordinary residence**, you can apply for:
- **Permanent ID Card**
- **Right of Abode**

### Continuous Residence

| Allowed | Not Allowed |
|---------|-------------|
| Short business trips | Extended absence without HK home base |
| Holidays | Living primarily overseas |
| Short-term overseas assignments | Abandoning HK residence |

### PR Application Process

1. Complete Form ROP145
2. Submit supporting documents
3. Attend interview (if required)
4. Processing: 6-12 months
5. Receive permanent ID card

### PR Benefits

- No visa restrictions
- Right to work freely
- Vote (limited elections)
- Social benefits eligibility
- Can sponsor family members
- Re-entry without visa

---

## Working Holiday Visa

### Eligible Countries/Regions

| Country | Annual Quota | Max Age |
|---------|--------------|---------|
| Australia | 5,000 | 30 |
| Canada | 200 | 30 |
| France | 750 | 30 |
| Germany | 300 | 30 |
| Ireland | 200 | 30 |
| Japan | 1,500 | 30 |
| New Zealand | 400 | 30 |
| UK | 1,000 | 30 |
| Austria | 100 | 30 |
| Hungary | 200 | 30 |
| Italy | 1,000 | 30 |
| Netherlands | 100 | 30 |
| Sweden | 500 | 30 |
| South Korea | 500 | 30 |

### Requirements

- Valid passport from eligible country
- Age 18-30 at application
- Primary purpose: holiday
- No dependents accompanying
- Sufficient funds (HK$25,000 minimum)
- Return ticket or funds for one
- Health insurance

### Working Holiday Rules

- Duration: 12 months (non-extendable)
- Work: Allowed, but not with same employer >6 months
- Study: Short courses allowed (max 6 months)
- Multiple entries permitted

---

## Visa Fees (2025)

| Visa Type | Fee (HKD) |
|-----------|-----------|
| Employment visa | $230 |
| TTPS | $230 |
| QMAS | $230 |
| Investment visa | $230 |
| Dependent visa | $230 |
| Extension of stay | $230 |
| Permanent ID | Free |

*Note: As of January 2025, fees for talent schemes may be waived/reduced under government initiatives*

---

## Processing Times

| Visa Type | Typical Duration |
|-----------|------------------|
| TTPS | 2-4 weeks |
| Employment | 4-6 weeks |
| QMAS | 6-12 months (quota) |
| Investment | 4-8 weeks |
| Dependent | 4-6 weeks |
| Extension | 4-6 weeks |

---

## Practical Tips

### Best Practices

1. **Apply early** - Don't wait until visa expiry
2. **Complete documents** - Missing items = delays
3. **Use e-services** - Faster processing
4. **Keep copies** - Of everything
5. **Track application** - Online tracking available

### Common Mistakes

 Incomplete work experience proof
 Non-certified translations
 Incorrect application form
 Missing photos or signatures
 Applying under wrong category

### If Rejected

1. Request reasons in writing
2. Address the issues
3. Reapply (no limit on attempts)
4. Consider alternative visa category
5. Seek professional advice if complex

---

## Useful Links

### Official Resources
- **Immigration Department**: immd.gov.hk
- **TTPS Info**: immd.gov.hk/eng/services/visas/TTPS.html
- **QMAS Info**: immd.gov.hk/eng/services/visas/quality_migrant_admission_scheme.html
- **e-Visa Application**: eservices.immd.gov.hk
- **Top 100 University List**: immd.gov.hk/pdf/aggregate_list.pdf

### Professional Resources
- Hong Kong Bar Association
- Immigration consultants
- Corporate services firms

---

## Summary: Which Visa Is Right for You?

| Your Situation | Recommended Visa |
|----------------|------------------|
| High earner ($320K+ USD/year) | TTPS Category A |
| Top-100 university + 3 yrs experience | TTPS Category B |
| Recent top-100 graduate | TTPS Category C |
| Job offer from HK company | Employment Visa |
| Skilled, no job offer, not TTPS-eligible | QMAS |
| Starting/investing in business | Investment/GEP |
| Young, want to explore HK | Working Holiday |
| Spouse/child of visa holder | Dependent |

---

*Last updated: February 2026*
*Sources: Immigration Department HKSAR, InvestHK, KPMG, Fragomen*
