# Hong Kong Transport Guide

> Last updated: February 2025 | Currency: HKD (1 USD  7.8 HKD)

## Overview

Hong Kong has one of the world's best public transport systems. Over **90% of daily journeys** use public transport-the highest rate globally. The system is clean, safe, efficient, and incredibly affordable.

**Key advantage:** The entire network is integrated with the **Octopus Card**, making transfers seamless.

---

## MTR (Mass Transit Railway)

The MTR is Hong Kong's subway system-the backbone of urban transport.

### Network Facts
- **10 metro lines** + Airport Express + Light Rail
- **99 heavy rail stations** + 68 light rail stops
- **245 km** of railway
- **99.9% punctuality rate**
- **5+ million trips daily**

### MTR Lines

| Line | Color | Route | Key Stops |
|------|-------|-------|-----------|
| Island Line | Blue | Kennedy Town  Chai Wan | Central, Admiralty, Causeway Bay |
| Tsuen Wan Line | Red | Tsuen Wan  Central | Mong Kok, Jordan, TST |
| Kwun Tong Line | Green | Whampoa  Tiu Keng Leng | Diamond Hill, Kowloon Bay |
| Tseung Kwan O Line | Purple | North Point  LOHAS Park | Quarry Bay, TKO |
| East Rail Line | Cyan | Admiralty  Lo Wu/Lok Ma Chau | Hung Hom, Sha Tin, border crossings |
| Tuen Ma Line | Brown | Wu Kai Sha  Tuen Mun | Kowloon Tong, East TST |
| South Island Line | Yellow | Admiralty  South Horizons | Ocean Park |
| Tung Chung Line | Orange | Hong Kong  Tung Chung | Kowloon, Olympic |
| Disneyland Resort Line | Pink | Sunny Bay  Disneyland | - |
| Airport Express | Teal | Hong Kong  AsiaWorld Expo | Kowloon, Tsing Yi |

### MTR Fares (2024-2025)

Fares calculated by distance. Octopus card = cheaper than single tickets.

| Journey Type | Octopus | Single Ticket |
|--------------|---------|---------------|
| Short trip (3-5 stations) | HK$5-8 (~$0.65-1) | HK$6-9 |
| Medium trip (10 stations) | HK$10-15 (~$1.30-2) | HK$12-17 |
| Cross-harbour | HK$12-18 (~$1.50-2.30) | HK$14-20 |
| Long distance (NT) | HK$15-25 (~$2-3.20) | HK$17-28 |

**Children (3-11)**, **Seniors (65+)**, and **Students** get ~50% discounts.

### MTR Tips
- Trains run from **~6:00 AM to ~12:30 AM**
- Peak hours: 7:30-9:30 AM, 5:30-8:00 PM
- All trains and stations are **air-conditioned**
- No eating or drinking on trains (HK$2,000 fine)
- Stand right on escalators, walk left

---

## Octopus Card

The **essential** card for Hong Kong. A contactless stored-value smart card accepted everywhere.

### Getting an Octopus Card
- **Where:** Any MTR station, 7-Eleven, convenience stores
- **Cost:** HK$150 (HK$100 stored value + HK$50 refundable deposit)
- **Types:** Adult, Child, Senior, Tourist
- **Tourist Octopus:** HK$39 (Sold version, no deposit return)

### What Accepts Octopus?
-  All public transport (MTR, buses, trams, ferries, minibuses)
-  Convenience stores (7-Eleven, Circle K)
-  Supermarkets (Wellcome, PARKnSHOP)
-  Fast food (McDonald's, Starbucks)
-  Parking meters
-  Vending machines
-  Some taxis

### Top Up
- MTR stations (machines or customer service)
- Convenience stores
- Automatic Add Value (link to credit card)
- Maximum balance: HK$3,000

### Octopus App
Download for balance checking, QR payments, and topping up.

---

## Buses

Hong Kong has an extensive bus network, carrying ~4 million passengers daily.

### Franchised Bus Companies
| Company | Area | Routes |
|---------|------|--------|
| **KMB** (Kowloon Motor Bus) | Kowloon, NT | 67% market share |
| **Citybus** | HK Island, cross-harbour | 29% market share |
| **Long Win Bus** | Airport routes | - |
| **New Lantao Bus** | Lantau Island | - |

### Bus Fares
- **Short routes:** HK$4-8 (~$0.50-1)
- **Cross-harbour:** HK$10-15 (~$1.30-2)
- **Airport buses:** HK$25-50 (~$3.20-6.40)

### Bus Tips
- Enter at front, exit at back
- Octopus tap on boarding
- Air-conditioned double-deckers
- Apps: **Citymapper**, **KMB app** for real-time arrivals

---

## Trams (Ding Ding)

Hong Kong Island's iconic **double-decker trams** since 1904.

### Details
- **Route:** Kennedy Town  Shau Kei Wan (13 km on HK Island north shore)
- **Fare:** HK$3 flat rate (~$0.40) - cheapest transport in HK!
- **Hours:** 5:30 AM - 12:30 AM
- **Fleet:** 165 double-decker trams

### Tram Tips
- Board at back, exit at front
- Pay when exiting (Octopus or exact change)
- Slow but scenic-great for tourists
- **Happy Valley loop** branch for racecourse

---

## Ferries

Essential for harbor crossings and outlying islands.

### Star Ferry (Victoria Harbour)
- **Routes:** Central  Tsim Sha Tsui, Wan Chai  TST
- **Fare:** HK$4-6 (~$0.50-0.80)
- **Duration:** ~10 minutes
- **Must-do tourist experience!**

### Island Ferries
| Destination | Operator | Fare | Duration |
|-------------|----------|------|----------|
| Cheung Chau | Sun Ferry | HK$15-30 | 35-55 min |
| Lamma Island | HKKF | HK$20-30 | 25-35 min |
| Lantau (Mui Wo) | Sun Ferry | HK$18-35 | 35-55 min |
| Discovery Bay | DB Transit | HK$45 | 25 min |

---

## Minibuses

Small 16-19 seat buses serving routes regular buses don't reach.

### Types
| Type | Features |
|------|----------|
| **Green minibus** | Fixed routes, fixed fares, Octopus accepted |
| **Red minibus** | Flexible routes, cash only, negotiate fare |

### Fares: HK$3-20 depending on distance

### Tips
- Shout "!" (yau lok) to stop
- Green is more reliable for visitors
- Red minibuses known for aggressive driving

---

## Taxis

### Taxi Types by Color
| Color | Area | Flag Fall | Per km |
|-------|------|-----------|--------|
| **Red** | Urban (HK Island, Kowloon) | HK$29 | HK$10.50 |
| **Green** | New Territories only | HK$25 | HK$9 |
| **Blue** | Lantau Island only | HK$25 | HK$9 |

### Tips
- Taxis are **metered** and honest
- Tip by rounding up fare
- Most drivers speak basic English
- Luggage surcharge: HK$6 per piece
- Octopus accepted in some taxis

### Taxi vs Uber/Grab

| Aspect | Taxi | Uber/Grab |
|--------|------|-----------|
| Legality | Legal | Grey area (technically illegal) |
| Availability | Very high | Limited |
| Payment | Cash, Octopus | Card, cash |
| Cost | Metered | Surge pricing possible |
| Recommendation | **Use taxis** | Works but risky |

**Note:** Uber operates in HK but in legal grey area. Taxis are recommended.

---

## Airport Express

Premium rail link between Hong Kong International Airport and city.

### Stations & Fares (to Airport)
| From | Duration | Adult Fare |
|------|----------|------------|
| Hong Kong Station (Central) | 24 min | HK$115 (~$15) |
| Kowloon Station | 21 min | HK$105 (~$13.50) |
| Tsing Yi Station | 12 min | HK$70 (~$9) |

### Features
- Free shuttle buses from stations to hotels
- In-town check-in (check bags at Hong Kong/Kowloon stations)
- Round trip discounts
- Group discounts (2-4 people)

### Alternative: Airport Buses
- **A21** to Nathan Road: HK$33
- **A11** to Central: HK$40
- Slower but much cheaper

---

## Cross-Border Transport

### To Mainland China

**High-Speed Rail (XRL)**
- **West Kowloon Station**  Shenzhen (14 min), Guangzhou (47 min), Beijing (9 hours)
- Immigration at station
- Fares: HK$80-250+ depending on destination

**Border Crossings (by MTR)**
- **Lo Wu** and **Lok Ma Chau** stations (East Rail Line)
- Walk across border to Shenzhen

### To Macau
- **Turbojet/Cotai Water Jet** from HK-Macau Ferry Terminal
- Duration: ~55 minutes
- Fare: HK$175-250+
- Alternative: **Hong Kong-Zhuhai-Macau Bridge** (bus)

---

## Transport Apps

| App | Use |
|-----|-----|
| **MTR Mobile** | Official MTR app, journey planner |
| **Citymapper** | Best all-in-one transport app |
| **KMB/LWB app** | Real-time bus arrivals |
| **HKeMobility** | Government transport info |
| **Octopus app** | Balance check, payments |

---

## Comparison with Other Cities

| City | Annual Ridership | % Public Transport | Punctuality |
|------|------------------|-------------------|-------------|
| **Hong Kong MTR** | 1.9 billion | 90%+ | 99.9% |
| Tokyo Metro | 2.8 billion | 60% | 99%+ |
| London Underground | 1.4 billion | 45% | ~90% |
| NYC Subway | 1.6 billion | 55% | ~65% |
| Singapore MRT | 1.2 billion | 65% | 99%+ |

**Verdict:** Hong Kong's public transport is among the **best in the world**-cheap, efficient, clean, and comprehensive. You genuinely don't need a car.

---

## Quick Reference

| Transport | Best For | Cost Range |
|-----------|----------|------------|
| MTR | Speed, coverage | HK$5-25 |
| Bus | Areas MTR doesn't reach | HK$4-15 |
| Tram | Scenic, cheap, HK Island | HK$3 |
| Ferry | Harbour, islands | HK$4-45 |
| Minibus | Local areas | HK$3-20 |
| Taxi | Convenience, luggage | HK$30+ |
| Airport Express | Airport (premium) | HK$70-115 |
