# Hong Kong Startup Ecosystem Guide 2025

## Overview: Asia's Innovation Gateway

Hong Kong's startup ecosystem reached **record highs in 2025**, cementing its position as a critical hub for innovation in Asia Pacific.

### Key Statistics (2025)

| Metric | Value | YoY Change |
|--------|-------|------------|
| Total startups | 5,221 | +10% |
| Startup employees | ~20,000 | +7% |
| Funded startups | 2,150 | Growing |
| VC funding (2024) | $5.8 billion | Strong |
| Global ranking | 27th | +5 positions |
| Unicorns | 10 | Stable |

### Top Sectors

| Sector | Share | Notes |
|--------|-------|-------|
| **FinTech** | #1 | 600+ companies |
| **Information & Tech** | #2 | AI, software |
| **Biotechnology** | #3 | Growing fast |
| **E-commerce** | #4 | Regional focus |
| **HealthTech** | Growing | +54% (2024-2025) |
| **GreenTech** | Growing | +82% (2024-2025) |
| **AI/Core AI** | New | New category 2025 |

---

## Innovation Hubs: Cyberport vs HKSTP

### Cyberport

**Focus**: Digital tech, FinTech, gaming, e-commerce

| Feature | Details |
|---------|---------|
| Location | Southern District (Pokfulam) |
| Companies | 1,800+ digital startups |
| Key sectors | FinTech, AI, gaming, digital entertainment |
| Programs | Incubation, accelerator, co-working |
| Funding | Up to HK$500K assistance |

#### Cyberport Incubation Programme

| Benefit | Value |
|---------|-------|
| Financial assistance | Up to HK$500,000 |
| On-site rental subsidy | Up to HK$200,000 |
| Technical support | Labs, cloud credits |
| Business support | Mentorship, networking |
| Duration | 24 months |
| Eligibility | Digital tech companies <7 years old |

#### Cyberport Creative Micro Fund (CCMF)

| Feature | Details |
|---------|---------|
| Amount | Up to HK$100,000 |
| Purpose | Proof-of-concept |
| For | Very early stage ideas |
| Duration | 6 months |

### HKSTP (Hong Kong Science & Technology Parks)

**Focus**: Deep tech, biotech, hardware, R&D

| Feature | Details |
|---------|---------|
| Location | Sha Tin (Science Park) + Tai Po, TKO, Yuen Long |
| Companies | 1,800+ innovation companies |
| Key sectors | Biotech, electronics, green tech, AI |
| Programs | Ideation, incubation, accelerator |
| Facilities | Labs, clean rooms, prototyping |

#### HKSTP Incubation Programme

| Tier | Duration | Funding |
|------|----------|---------|
| Ideation | 12 months | Seed support |
| Incubation | 3 years | Up to HK$1.29M |
| Incu-Bio | 4 years | Up to HK$6M (biotech) |

#### HKSTP Benefits

- Subsidized rent (significant)
- Lab facilities access
- Research collaboration with universities
- Investor matching
- Corporate partnership programs

### Which Hub to Choose?

| Criteria | Choose Cyberport | Choose HKSTP |
|----------|------------------|--------------|
| Sector | FinTech, digital, gaming | Biotech, hardware, deep tech |
| Stage | Early to growth | R&D-heavy, technical |
| Location preference | HK Island / urban | Doesn't mind NT |
| Lab needs | Minimal | Essential |
| Prototype manufacturing | No | Yes |

---

## Funding Landscape

### VC & Investment Statistics

| Metric | Value |
|--------|-------|
| Total VC raised 2024 | ~$5.8 billion |
| Early-stage (Seed-A) 2023-2025 | ~$900 million |
| International investor participation | 48% |
| Startups securing VC | 2,150 |

### Hong Kong Unicorns

| Company | Sector | Valuation |
|---------|--------|-----------|
| **WeLab** | Digital banking | $1B+ |
| **Animoca Brands** | Web3/gaming | $5B+ |
| **SenseTime** | AI/Computer vision | Listed |
| **GOGOX** | Logistics tech | $1B+ |
| **Klook** | Travel tech | $1B+ |
| **Lalamove** | On-demand delivery | $1B+ |
| **Airwallex** | Payments | $5B+ |
| **BitMEX** | Crypto | $1B+ |

### Active VCs in Hong Kong

**International:**
- Sequoia China
- Horizons Ventures (Li Ka-Shing)
- Goldman Sachs
- IDG Capital
- GGV Capital

**Local/Regional:**
- Gobi Partners
- Mindworks Capital
- Beyond Ventures
- Vectr Fintech Partners
- Sparklabs HK

### Funding Stages Available

| Stage | Typical Amount (USD) | Sources |
|-------|---------------------|---------|
| Pre-seed | $50K - $200K | Grants, angels, CCMF |
| Seed | $200K - $1M | Angels, early-stage VC |
| Series A | $1M - $10M | VC funds |
| Series B+ | $10M+ | Growth VCs, PE |

---

## Government Grants & Funding

### Innovation and Technology Fund (ITF)

| Programme | Max Funding | Purpose |
|-----------|-------------|---------|
| **ESS** (Enterprise Support Scheme) | HK$10M | R&D projects |
| **PSTS** (Patent Application Grant) | HK$250K | Patent costs |
| **RTH** (R&D Cash Rebate) | 40% of R&D spend | Incentive |
| **TVP** (Technology Voucher Programme) | HK$600K | Tech services |

### Technology Start-up Support Scheme (TSSS)

- For university graduates/researchers
- Up to HK$1.5M per project
- 3-year maximum duration

### Cyberport Funding Programmes

| Programme | Amount | Purpose |
|-----------|--------|---------|
| CCMF | HK$100K | Proof of concept |
| Incubation | HK$500K | Growth support |
| Macro Fund | HK$500K-2M | Scale-up |
| Greater Bay Fund | HK$200K | GBA expansion |

### HKSTP Corporate Venture Fund

- Up to HK$8 million per startup
- For HKSTP incubatees
- Milestone-based funding

---

## Co-Working Spaces

### Major Spaces

| Space | Locations | Monthly Cost (HKD) | Best For |
|-------|-----------|-------------------|----------|
| **WeWork** | Central, Causeway Bay, Kwun Tong | $4,500 - $12,000 | Corporates, scale-ups |
| **The Hive** | Central, Wan Chai, Sai Kung | $3,500 - $8,000 | Creative, community |
| **Garage Society** | Central, Wan Chai, Wong Chuk Hang | $3,000 - $7,000 | Startups, tech |
| **Campfire** | Central, TST, Causeway Bay | $2,800 - $6,500 | Budget-friendly |
| **theDesk** | Central, Admiralty | $3,200 - $7,500 | Professionals |
| **Cyberport** | Cyberport | Subsidized | Tech startups |
| **HKSTP** | Science Park | Subsidized | Deep tech |

### Hot Desk vs Dedicated Desk

| Type | Monthly Cost | Best For |
|------|--------------|----------|
| Hot desk | $2,000 - $4,000 | Flexibility |
| Dedicated desk | $3,500 - $7,000 | Regulars |
| Private office (2-4 pax) | $8,000 - $20,000 | Small teams |
| Private office (5-10 pax) | $20,000 - $50,000 | Growing teams |

---

## Greater Bay Area (GBA) Opportunities

### What is the GBA?

- **11 cities**: Hong Kong, Macau, Shenzhen, Guangzhou, Dongguan, Foshan, Zhongshan, Zhuhai, Huizhou, Jiangmen, Zhaoqing
- **Population**: 86 million
- **GDP**: $1.9 trillion
- **Goal**: Integrated technology and finance hub

### GBA Advantages for HK Startups

| Benefit | Details |
|---------|---------|
| Manufacturing | Access to world's factory (Shenzhen, Dongguan) |
| Talent | Mainland tech talent |
| Market | 86 million consumers |
| R&D | Collaborations with mainland labs |
| Funding | Mainland VCs, government funds |

### Key GBA Initiatives

#### Qianhai - Shenzhen
- Special economic zone
- Preferential tax (15% for certain industries)
- HK company registration recognized
- Target: Modern services, FinTech

#### HKUST Guangzhou
- Joint campus for research
- Collaboration opportunities
- Tech transfer

#### GBA Youth Employment Scheme
- Subsidies for HK youth working in GBA
- Supports cross-border talent flow

### How to Expand into GBA

1. **Keep HK entity** as regional HQ
2. **Set up mainland WFOE** or JV for operations
3. **Use CEPA** for preferential access
4. **Partner** with GBA incubators (Shenzhen Bay)
5. **Apply for GBA grants** (Cyberport, HKSTP programs)

---

## Accelerators & Programmes

### Major Accelerators

| Accelerator | Focus | Investment |
|-------------|-------|------------|
| **Brinc** | IoT, food tech, climate | Up to $200K |
| **Betatron** | Pre-seed ventures | HK$250K |
| **Zeroth.AI** | AI, ML | $120K |
| **Nest** | General tech | Varies |
| **SparkLabs** | Deep tech, AI | $30K-50K |
| **SuperCharger** | FinTech | Partnership-based |
| **HKUST Entrepreneurship Program** | Student startups | Support |

### International Accelerators with HK Presence

- Y Combinator (alumni network)
- 500 Global
- Techstars (alumni)
- Plug and Play

---

## Startup Success Metrics (2025)

### Survival Rates

| Metric | Rate |
|--------|------|
| 5-year survival (general) | 58% |
| Funded startup success rate | 73% |
| Scale beyond HK (5 years) | 12% |

### Common Challenges

| Challenge | % Affected |
|-----------|------------|
| Rising operating costs | 22% |
| Localization barriers | 52% |
| Talent competition | High |
| Market access | Varies |

### Success Factors

| Factor | Impact |
|--------|--------|
| Early funding | +73% survival |
| Local partnerships | 72% scale faster |
| International SEO | 87% better visibility |
| Incubator participation | 85%+ survival |

---

## Founder Demographics

### Who's Building in Hong Kong

| Origin | % of Founders |
|--------|---------------|
| Hong Kong locals | 67% |
| Returnees | 1% |
| Non-local | 33% |

### Top Non-Local Origins

1. Mainland China
2. United Kingdom
3. United States
4. France
5. Australia

---

## Getting Started: Your Checklist

### Phase 1: Preparation
- [ ] Research visa requirements (TTPS, employment visa)
- [ ] Identify target sector and market
- [ ] Connect with ecosystem (StartmeupHK, events)
- [ ] Explore incubator fit (Cyberport vs HKSTP)

### Phase 2: Setup
- [ ] Register company (see business.md)
- [ ] Open bank account
- [ ] Apply to incubator/accelerator
- [ ] Find co-working space

### Phase 3: Growth
- [ ] Apply for government grants
- [ ] Build local partnerships
- [ ] Explore GBA expansion
- [ ] Connect with VCs

---

## Key Events & Resources

### Major Events

| Event | Timing | Focus |
|-------|--------|-------|
| **StartmeupHK Festival** | January | Ecosystem celebration |
| **RISE** | Various | Global tech conference |
| **Hong Kong FinTech Week** | November | FinTech focus |
| **HKSTP InnoFest** | Various | Science Park community |

### Useful Resources

- **StartmeupHK**: startmeup.hk
- **InvestHK**: investhk.gov.hk
- **Cyberport**: cyberport.hk
- **HKSTP**: hkstp.org
- **HKTDC**: hktdc.com

---

## Summary: Why Build in Hong Kong?

### Strengths
 Gateway to China & Asia
 Strong government support & funding
 Deep financial ecosystem (FinTech)
 Low taxes, business-friendly
 International legal system
 Diverse founder community

### Challenges
 High living/operating costs
 Competitive talent market
 Small local market (7.5M)
 Need to expand regionally

### Best Fit For
- FinTech startups targeting Asia
- Companies needing China market access
- Deep tech requiring R&D infrastructure
- Regional HQ for APAC expansion
- Cross-border commerce platforms

---

*Last updated: February 2026*
*Sources: InvestHK, StartmeupHK, Cyberport, HKSTP, aboveA, industry reports*
