# Hong Kong Safety Guide

> Last updated: February 2025

## Overview

Hong Kong is one of the **safest major cities in the world**. Violent crime is rare, streets are safe at night, and the rule of law is strong. Most visitors and residents never experience crime beyond minor incidents.

**Bottom line:** You can walk anywhere at any hour with minimal concern.

---

## Crime Statistics

### Overall Crime (2023)

| Metric | 2023 Data | Context |
|--------|-----------|---------|
| Total crimes | 90,276 | Up due to fraud increase |
| Violent crimes | 10,122 | 135 per 100,000 population |
| Homicide | 28 | 0.4 per 100,000 |
| Robberies | ~150 | Very low |
| Burglaries | ~1,500 | Low |

### Historical Context
- 2018 was a **39-year low** for crime
- Crime increased 2019-2023, mainly due to **fraud/scams** (online)
- Violent crime remains **very low**

### Comparison with Other Cities

| City | Homicide Rate (per 100,000) |
|------|----------------------------|
| Hong Kong | 0.4 |
| Singapore | 0.2 |
| Tokyo | 0.3 |
| London | 1.2 |
| New York | 5.0 |
| US Average | 6.5 |

Hong Kong is safer than most Western cities by far.

---

## Common Crimes

### Most Frequent Offenses
1. **Theft** (pickpocketing, shoplifting) - 27,500 cases/year
2. **Fraud/Scams** (mostly online) - rising significantly
3. **Criminal damage** - ~6,000 cases/year
4. **Assault** - relatively low

### What To Watch For
- **Pickpockets** in crowded areas (MTR, markets)
- **Online scams** (romance scams, investment fraud)
- **Phone scams** pretending to be police/government
- **Taxi overcharging** (rare, but possible)

---

## Areas & Safety

### Generally Very Safe (Day & Night)
-  Central, Admiralty
-  Causeway Bay, Wan Chai
-  Tsim Sha Tsui
-  Mong Kok (busy but safe)
-  Residential areas (Sha Tin, Tai Po, etc.)
-  Outlying islands

### Be More Cautious (Late Night)
| Area | Notes |
|------|-------|
| **Lan Kwai Fong (LKF)** | Drunk people, petty crime, late night scuffles |
| **Wan Chai bars area** | Similar to LKF |
| **Chungking Mansions** | Not dangerous but chaotic; touts can be pushy |
| **Temple Street (late)** | Fine but watch belongings |

### Generally Fine But Chaotic
- **Sham Shui Po** - working class, cheap, safe but gritty
- **Yau Ma Tei** - older area, night market, totally fine

**Note:** Even "less safe" areas in Hong Kong are safer than average areas in most Western cities.

---

## Night Safety

### Walking at Night
-  Generally safe to walk anywhere
-  Women traveling alone: very safe
-  Public transport runs until ~12:30 AM
-  Taxis readily available 24/7
-  Well-lit streets in most areas

### Late Night Tips
- Stick to main streets in unfamiliar areas
- Avoid confrontations with drunk people (LKF, Wan Chai)
- Keep valuables secure in crowded areas
- Trust your instincts (rarely needed)

---

## Emergency Numbers

| Service | Number | Notes |
|---------|--------|-------|
| **Police/Fire/Ambulance** | **999** | Main emergency |
| Police (non-emergency) | 2527 7177 | General inquiries |
| Hospital Authority | 2300 6555 | Hospital info |
| Consumer Council | 2929 2222 | Complaints |
| Immigration | 2824 6111 | Visa issues |

### Useful Contacts
- **Consulates:** Contact your country's consulate for citizen services
- **24-hour pharmacy:** Many Watsons/Mannings open late
- **Credit card loss:** Call your bank's international line

---

## Police

### Hong Kong Police Force
- Generally professional and courteous
- English widely spoken
- Visible presence in busy areas
- **Non-corrupt** by regional standards

### If Stopped by Police
- Carry ID (HKID or passport)
- Be polite and cooperative
- They can check ID but need reason to search
- Request interpreter if needed

### Reporting Crime
- **999** for emergencies
- Visit any police station for non-emergencies
- Online reporting available for some crimes
- Keep receipts for insurance claims

---

## Triads & Organized Crime

### Reality for Visitors/Expats
- **Triads exist** but don't affect normal life
- Main activities: illegal gambling, loan sharking, prostitution rings
- **Not a concern** for tourists or residents
- You won't accidentally encounter triad activity

### Historical Context
- Sun Yee On and 14K are major organizations
- Operate underground, rarely visible
- Police actively combat organized crime

---

## Natural Hazards

### Typhoons (June-October)
| Signal | Meaning | Action |
|--------|---------|--------|
| T1 | Typhoon approaching | Monitor |
| T3 | Strong winds | Schools may close |
| **T8** | Gale force | Everything closes, stay indoors |
| T9-T10 | Severe | Dangerous, stay indoors |

- Check **Hong Kong Observatory** (hko.gov.hk)
- T8+ = work/schools close, transport stops
- Buildings designed for typhoons-stay inside

### Other Hazards
- **Rainstorms:** Red/Black rain warnings = flooding possible
- **Heat:** Summer humidity can be dangerous for elderly
- **Air quality:** Occasional pollution from mainland

---

## Health & Medical Safety

### Hospital System
- **Public hospitals:** Excellent quality, long waits
- **Private hospitals:** Expensive but quick
- Emergency care available 24/7

### Health Tips
- Tap water is **safe to drink** (though many prefer bottled)
- Food hygiene standards are high
- Bring prescription medications with documentation
- Pharmacies widely available (Watsons, Mannings)

### COVID-19 (2025)
- Restrictions largely lifted
- Some mask-wearing continues voluntarily
- Check current requirements before travel

---

## Legal System

### Basics
- **Common law** system (inherited from UK)
- Independent judiciary
- Presumption of innocence
- Right to legal representation

### Things That Are Illegal
- **Drugs:** Zero tolerance, severe penalties
- **Jaywalking:** Fines possible
- **Littering:** HK$1,500 fine
- **Eating on MTR:** HK$2,000 fine
- **Smoking:** Banned in most public places

### Drugs Warning
 **Hong Kong has extremely strict drug laws**
- Trafficking = potential death penalty (mainland) or life imprisonment
- Possession = serious jail time
- **Zero tolerance policy**

---

## Political Situation

### Context (Post-2020)
- 2019: Large protests
- 2020: National Security Law (NSL) implemented
- 2024-2025: Article 23 legislation passed

### What This Means for Visitors
- **Daily life is normal** and safe
- Avoid political protests if they occur
- Don't engage in political activities
- Media/speech laws have tightened

### Practical Impact
- Business as usual for most activities
- Some websites/apps may be restricted
- International media coverage can be alarming vs reality
- Expat community continues normally

### Advice
- Respect local laws and customs
- Avoid political discussions with strangers
- Don't photograph police or sensitive areas
- Keep opinions private on social media while in HK

---

## Scams to Avoid

### Common Scams

| Scam | How It Works | Prevention |
|------|--------------|------------|
| **Phone scams** | Fake police/immigration calls | Hang up, never send money |
| **Romance scams** | Online dating fraud | Be skeptical of requests for money |
| **Investment scams** | Crypto/stock schemes | Research thoroughly |
| **Fake goods** | Counterfeit electronics | Buy from reputable stores |
| **Gem scams** | Overpriced jewelry | Avoid street hawkers |

### Online Safety
- Fraud cases up 45%+ (mostly online)
- Be cautious with dating apps
- Verify investment opportunities
- Don't send money to strangers

---

## Women's Safety

### General Safety
-  Hong Kong is **very safe for women**
-  Solo female travel common and safe
-  Public transport safe at all hours
-  Street harassment rare

### Tips
- Normal urban precautions apply
- Avoid walking alone in isolated areas late at night
- LKF/bar areas can be rowdy (drunk men)
- Trust instincts as anywhere

---

## LGBTQ+ Safety

### Current Status
- No legal recognition of same-sex partnerships
- Discrimination protections limited
- **But:** Generally accepting society
- Active LGBTQ+ scene (especially Central/Sheung Wan)

### Practical Reality
- Public displays of affection: generally fine
- Pride events held annually
- Gay-friendly bars and venues exist
- No violence targeting LGBTQ+ individuals

---

## Summary

### Safety Ratings

| Category | Rating | Notes |
|----------|--------|-------|
| Violent crime |  | Extremely low |
| Theft/pickpocket |  | Low, normal precautions |
| Scams |  | Rising, mostly online |
| Night safety |  | Very safe |
| Women's safety |  | Very safe |
| Natural disasters |  | Typhoons managed well |
| Healthcare |  | Excellent |
| Police reliability |  | Professional |

### Key Takeaways
1. Hong Kong is **extremely safe** for a major city
2. Use normal urban precautions
3. Watch for **online scams** (biggest risk)
4. Be aware of **typhoon season** (June-October)
5. Strict drug laws-**never carry drugs**
6. Political situation stable for daily life
7. Trust the system-it works
