# Moving to Hong Kong Guide

> Last updated: February 2025 | Complete checklist for relocating to Hong Kong

## Overview

Moving to Hong Kong is an exciting but complex process. This guide covers everything from pre-arrival preparation to settling into daily life. Hong Kong is efficient and welcoming to expats-the key is being organized.

---

## Pre-Departure Checklist

### 3+ Months Before

**Visa & Documents**
- [ ] Confirm visa type needed (work, dependent, investment, etc.)
- [ ] Apply for visa through employer or sponsor
- [ ] Gather required documents (passport copies, photos, employment letter)
- [ ] Apostille/notarize documents as needed
- [ ] Check passport validity (6+ months recommended)

**Financial Preparation**
- [ ] Research cost of living (see cost.md)
- [ ] Budget for initial costs (3-4 months rent upfront!)
- [ ] Notify bank of relocation
- [ ] Get international credit/debit cards
- [ ] Consider Wise/Revolut for currency conversion

**Research**
- [ ] Explore neighborhoods (see rent section)
- [ ] Research schools if applicable
- [ ] Look at housing options online
- [ ] Join expat Facebook groups/forums
- [ ] Connect with future colleagues

### 1-2 Months Before

**Practical Prep**
- [ ] Book flights
- [ ] Arrange temporary accommodation (first 2-4 weeks)
- [ ] Start apartment hunting online
- [ ] Research shipping/moving companies
- [ ] Decide what to ship vs buy new

**Admin**
- [ ] Cancel/transfer subscriptions
- [ ] Forward mail
- [ ] Inform tax authorities in home country
- [ ] Get copies of medical records
- [ ] Stock up on medications (with prescriptions)

### 1-2 Weeks Before

**Final Prep**
- [ ] Confirm accommodation
- [ ] Download essential apps (see local.md)
- [ ] Print important documents
- [ ] Arrange airport pickup or transport
- [ ] Exchange some HKD for arrival
- [ ] Get international phone plan/roaming

---

## Visa Types

### Common Visa Categories

| Visa Type | For Whom | Duration |
|-----------|----------|----------|
| **Employment Visa** | Hired by HK company | 1-2 years, renewable |
| **Investment Visa** | Entrepreneurs, investors | Case by case |
| **Dependent Visa** | Spouse/children of visa holder | Tied to sponsor |
| **Student Visa** | Full-time students | Duration of study |
| **Working Holiday** | Young adults (certain countries) | 1 year |
| **Quality Migrant (QMAS)** | Skilled professionals | Points-based |
| **Top Talent Pass** | High earners, university graduates | 2 years |

### Employment Visa Requirements
- Sponsorship from HK employer
- Proof of unique skills/qualifications
- Contract/offer letter
- Academic credentials
- Professional experience proof
- No local candidate available (demonstrated)

### Processing Time
- Standard: 4-6 weeks
- Can be faster with complete documentation
- Apply well in advance

---

## First Week Survival Guide

### Day 1-2: Arrival

**At Airport**
1. Immigration: Have visa approval, passport, accommodation address
2. Collect luggage
3. Get tourist SIM at airport (temporary)
4. Exchange money or use ATM
5. Take Airport Express, bus, or taxi to accommodation

**First Tasks**
- [ ] Rest and recover from flight
- [ ] Get Octopus card (at MTR station)
- [ ] Buy essentials (convenience store)
- [ ] Explore immediate neighborhood
- [ ] Get local SIM if not done at airport

### Day 3-4: Basic Setup

**Essential Admin**
- [ ] Open bank account (if possible without HKID)
- [ ] Start HKID application process
- [ ] Verify work permit/visa status
- [ ] Contact employer/HR
- [ ] Set up WhatsApp with local number

**Exploration**
- [ ] Learn MTR routes to work
- [ ] Find nearby supermarkets
- [ ] Locate essential services (pharmacy, 7-Eleven)
- [ ] Start serious apartment hunting

### Day 5-7: Getting Established

- [ ] View apartments
- [ ] Set up longer-term phone plan
- [ ] Attend HKID appointment (if scheduled)
- [ ] Start work orientation
- [ ] Open additional bank accounts if needed
- [ ] Begin settling into routine

---

## HKID Card (Hong Kong Identity Card)

### Who Needs One
- **Mandatory** if staying 180+ days
- Must apply within **30 days** of becoming resident

### Application Process

1. **Book appointment** at Immigration Department
   - Online booking available
   - Location: Immigration Tower, Wan Chai
   
2. **What to bring:**
   - Passport with valid visa
   - Proof of address
   - Recent photo (can be taken there)
   - Application form

3. **At appointment:**
   - Fingerprints taken
   - Photo taken
   - ~30-60 minutes

4. **Collection:**
   - Collect in person or by mail
   - ~10 working days

### HKID Benefits
-  Required for employment
-  Easier to open bank accounts
-  Some services require it
-  Faster immigration when traveling

---

## Finding an Apartment

### Timeline
- Start looking: 2-4 weeks before needed
- Viewing to signing: 1-3 days (fast market)
- Moving in: Usually within 2 weeks of signing

### Where to Search

| Platform | Type | Notes |
|----------|------|-------|
| **28hse.com** | Local listings | Most comprehensive |
| **spacious.hk** | Expat-friendly | English, curated |
| **squarefoot.com.hk** | Local | Good database |
| **geoexpat.com** | Expat forum | Listings + advice |
| **Facebook groups** | Expat postings | Direct from tenants |

### Using Agents

**Pros:**
- They know the market
- Can schedule multiple viewings
- Negotiate on your behalf
- Handle paperwork

**Cons:**
- Agency fee: 0.5-1 month's rent
- May push certain properties
- Commission-driven

**Recommendation:** Use agents initially, DIY once familiar.

### Viewing Checklist

- [ ] Check water pressure
- [ ] Test AC/heating
- [ ] Look for mold (humidity!)
- [ ] Check windows seal properly
- [ ] Mobile signal in apartment
- [ ] Building management quality
- [ ] Lift waiting time
- [ ] Noise level
- [ ] Natural light
- [ ] Distance to MTR

### Lease Signing

**Standard Terms:**
- Duration: 1-2 years
- Deposit: 2 months
- First month: 1 month advance
- Notice period: Usually 1-2 months
- Break clause: Sometimes after 1 year

**Before Signing:**
- [ ] Verify landlord ownership
- [ ] Inventory list with photos
- [ ] Clarify what's included (furniture, appliances)
- [ ] Understand maintenance responsibilities
- [ ] Check utility situation

### Initial Costs Summary

| Cost | Amount |
|------|--------|
| Security deposit | 2 months rent |
| First month advance | 1 month rent |
| Agency fee | 0.5-1 month rent |
| Stamp duty | ~0.25% of total rent |
| **TOTAL** | 3.5-4.5 months rent |

---

## Setting Up Life

### Week 1-2 Priorities

1. **Bank Account**
   - HSBC for main account
   - Virtual bank for backup/daily use
   - Set up online banking
   - Get PayMe/FPS

2. **Phone Plan**
   - Choose carrier (see local.md)
   - Get contract plan with HKID
   - Port number if keeping overseas number

3. **Utilities**
   - Transfer to your name (or through landlord)
   - Set up auto-pay
   - Electricity, gas, water

4. **Internet**
   - Book installation
   - Check building providers
   - Usually quick setup

### Week 3-4 Priorities

5. **Healthcare**
   - Register with GP
   - Arrange health insurance (if not through employer)
   - Find dentist, specialists as needed
   - Understand public vs private system

6. **Transport**
   - Regular Octopus card
   - Learn your commute routes
   - Explore neighborhood

7. **Daily Life**
   - Find regular supermarket
   - Locate wet market
   - Explore restaurants
   - Find gym/fitness options

### First Month Complete

8. **Admin Wrap-up**
   - Collect HKID
   - Update address with bank
   - Register with consulate
   - Set up mail forwarding if needed

9. **Social**
   - Connect with colleagues
   - Join expat groups
   - Explore hobby groups
   - Build local network

---

## Social Integration

### Meeting People

**Expat Communities**
- **InterNations** - networking events
- **Facebook groups** - area-specific, hobby-specific
- **Meetup.com** - interest-based groups
- **Sports clubs** - rugby, football, running, etc.
- **Professional associations** - industry networking

**Activities**
- **Hiking groups** - very popular in HK
- **Language exchange** - Cantonese/English
- **Sports leagues** - many expat teams
- **Volunteering** - HandsOn Hong Kong, etc.
- **Religious communities** - if applicable

### Making Local Friends
- Colleagues often become friends
- Language exchange (you teach English, learn Cantonese)
- Hobby classes
- Regular spots (gym, caf, restaurant)

### Hong Kong Social Culture
- **Work-focused** - long hours common
- **WhatsApp** - primary communication
- **Dining out** - social activity
- **Hiking** - Hong Kongers love it
- **Shopping/malls** - social activity

---

## Work Culture

### General Characteristics
- **Long hours** - 9 AM - 7 PM+ common
- **Hierarchy** - respect for seniority
- **Efficiency** - fast-paced
- **Email** - formal, frequent
- **WhatsApp** - used for work too

### Tips for Success
- Be punctual
- Learn colleagues' names
- Accept lunch/dinner invitations
- Understand hierarchy
- Be direct but polite

### Business Cards
- Still used heavily
- Receive/give with both hands
- Don't write on cards received
- Keep some with you

---

## Common Challenges & Solutions

### Challenge: Small Living Space

**Solutions:**
- Embrace minimalism
- Multi-functional furniture
- Utilize vertical space
- Regular decluttering
- Storage facilities available

### Challenge: Language Barrier

**Solutions:**
- English widely spoken in business/tourist areas
- Google Translate helps
- Learn basic Cantonese (appreciated)
- Visual menus at restaurants
- Point and gesture works

### Challenge: Humidity

**Solutions:**
- Dehumidifier essential
- Air clothes indoors
- Silica gel packets everywhere
- Store important items sealed
- Accept some dampness

### Challenge: High Rent

**Solutions:**
- Consider Kowloon over HK Island
- New Territories = more space
- Flatshare options
- Negotiate (market favors tenants recently)

### Challenge: Homesickness

**Solutions:**
- Stay connected (video calls)
- Build local routine
- Find home country products (import stores)
- Expat community
- Explore - keep busy

---

## Cost Summary: First 3 Months

| Category | Month 1 | Month 2-3 | Notes |
|----------|---------|-----------|-------|
| Rent deposit | HK$30,000-50,000 | - | 2 months |
| First month rent | HK$15,000-25,000 | HK$15,000-25,000 | Monthly |
| Agency fee | HK$10,000-20,000 | - | One-time |
| Furniture/setup | HK$5,000-20,000 | - | If needed |
| Food | HK$5,000-8,000 | HK$5,000-8,000 | Monthly |
| Transport | HK$1,000-1,500 | HK$800-1,200 | Monthly |
| Utilities | HK$500-1,000 | HK$800-1,500 | Varies |
| Phone/internet | HK$500-1,000 | HK$300-500 | Setup higher |
| Misc | HK$3,000-5,000 | HK$2,000-3,000 | Buffer |
| **TOTAL** | **HK$70,000-130,000** | **HK$25,000-40,000** | |
| **USD** | **$9,000-17,000** | **$3,200-5,100** | |

**Minimum cash on hand for arrival:** HK$100,000+ recommended

---

## 90-Day Checklist

### By Day 30
- [ ] HKID applied for and received
- [ ] Bank account(s) opened
- [ ] Phone plan set up
- [ ] Apartment secured
- [ ] Utilities transferred
- [ ] Internet installed
- [ ] Basic furniture/setup complete
- [ ] Commute routine established

### By Day 60
- [ ] Healthcare sorted (GP, insurance)
- [ ] Auto-pay for all bills
- [ ] Neighborhood explored
- [ ] Social connections started
- [ ] Work routine settled
- [ ] Essential apps all set up

### By Day 90
- [ ] Fully operational daily life
- [ ] Regular social activities
- [ ] Favorite spots identified
- [ ] Comfortable with transport
- [ ] Understanding of local culture
- [ ] Feeling at home

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| Police/Fire/Ambulance | 999 |
| Police (non-emergency) | 2527 7177 |
| Immigration | 2824 6111 |
| Hospital Authority | 2300 6555 |
| Your consulate | [Look up before arrival] |

---

## Final Tips

1. **Be patient** - adjustment takes 3-6 months
2. **Stay organized** - documentation matters in HK
3. **Embrace small** - apartment size is normal here
4. **Use the transport** - it's world-class
5. **Eat out** - often cheaper than cooking
6. **Join groups** - isolation is the enemy
7. **Explore** - Hong Kong has amazing nature
8. **Learn some Cantonese** - locals appreciate effort
9. **Keep perspective** - challenges are temporary
10. **Enjoy it** - HK is an incredible city

Welcome to Hong Kong! 
