# Hong Kong Local Setup Guide

> Last updated: February 2025 | Practical guide for banking, phones, utilities, and essential apps

## Overview

Setting up life in Hong Kong is relatively straightforward. The city is efficient, English is widely used, and digital services are excellent. This guide covers the essentials for getting established.

---

## Banking

### Major Banks

| Bank | Type | Best For |
|------|------|----------|
| **HSBC** | International | Expats, global banking |
| **Hang Seng** | Local (HSBC subsidiary) | Good local option |
| **Standard Chartered** | International | Expats |
| **Bank of China (HK)** | Local/China-linked | China connection |
| **DBS** | Singapore-based | Digital-first |
| **Virtual banks** | Digital only | Quick setup |

### HSBC (Most Popular for Expats)

#### Account Tiers

| Tier | Min Balance | Features |
|------|-------------|----------|
| **HSBC One** | No minimum | Basic, multi-currency |
| **HSBC Premier** | HK$1,000,000 | Priority service, global access |
| **HSBC Premier Elite** | HK$7,800,000 | Dedicated director, premium |

#### Opening an Account

**Requirements:**
-  Valid passport
-  Hong Kong address proof (utility bill, tenancy agreement)
-  Employment proof OR source of funds
-  HKID card (or application receipt)

**Process:**
1. Book appointment online or visit branch
2. Bring all documents
3. ~30-60 minutes process
4. Card arrives by mail (1-2 weeks)
5. Activate online banking

**Tips:**
- **Premier** accounts have faster/easier opening
- Some branches better for non-residents
- Bring extra documentation if possible
- HSBC branches in Central/TST most experienced with expats

### Virtual Banks (Quick Alternative)

| Bank | Opening | Notes |
|------|---------|-------|
| **ZA Bank** | 5 mins online | HK$0 minimum |
| **Mox** | 5 mins online | Standard Chartered backed |
| **WeLab Bank** | Quick | Good rates |
| **Airstar** | Quick | Xiaomi backed |

**Virtual Bank Pros:**
-  Fast opening (minutes)
-  No minimum balance
-  Good exchange rates
-  Modern apps

**Cons:**
-  Limited branches
-  Some services missing
-  Less established

### Banking Tips
- Get multiple accounts (local + international)
- HSBC good for global transfers
- Virtual banks for daily spending
- Keep some cash (small shops cash only)
- FPS (Faster Payment System) widely used

---

## Mobile Phones & SIM Cards

### Major Carriers

| Carrier | Network | Notes |
|---------|---------|-------|
| **csl** | Best coverage | Premium pricing |
| **3 Hong Kong** | Good | Competitive plans |
| **SmarTone** | Good | Business-focused |
| **China Mobile HK** | Good | China roaming |
| **CMHK** | Budget | Value option |

### SIM Card Options

#### Tourist/Temporary

| Option | Price | Data | Duration |
|--------|-------|------|----------|
| 7-Eleven tourist SIM | HK$50-100 | 5-10GB | 5-8 days |
| 3 HK tourist | HK$88 | 8GB | 8 days |
| csl tourist | HK$118 | 10GB | 8 days |

**Where to buy:**
- 7-Eleven, Circle K
- Airport arrivals
- MTR stations

#### Monthly Plans (Resident)

| Type | Price Range | Data |
|------|-------------|------|
| Budget | HK$50-100/mo | 5-15GB |
| Standard | HK$150-200/mo | 20-50GB |
| Unlimited | HK$300-400/mo | Unlimited |

### Getting a Contract Plan

**Requirements:**
-  HKID card
-  Hong Kong address
-  Payment method (auto-pay preferred)

**Process:**
1. Visit carrier store (not reseller)
2. Bring HKID and address proof
3. Choose plan (usually 12-24 month contract)
4. May get phone subsidy with contract

### eSIM Options
- Most carriers offer eSIM
- Good for dual-SIM setup
- Can activate online with HKID

### Phone Tips
- **5G** available and widely deployed
- Coverage excellent everywhere
- Roaming in mainland China varies by carrier
- Keep your overseas number active if needed

---

## Internet & WiFi

### Home Broadband

| Provider | Speed | Monthly |
|----------|-------|---------|
| **HKBN** | Up to 10Gbps | HK$100-400 |
| **PCCW/HKT** | Up to 10Gbps | HK$150-400 |
| **SmarTone** | Up to 2Gbps | HK$150-300 |
| **i-Cable** | Up to 1Gbps | HK$100-250 |

**Typical speeds:**
- Basic: 100-500 Mbps - HK$100-150/mo
- Standard: 1 Gbps - HK$150-250/mo
- Premium: 2-10 Gbps - HK$250-400/mo

### Setup Process
1. Check which providers service your building
2. Call or apply online
3. Installation scheduled (often same week)
4. Technician installs (~1 hour)

### WiFi Availability
- **Free WiFi:** Many cafes, malls, restaurants
- **WiFi.HK:** Free government WiFi in public areas
- **MTR:** Free WiFi in stations
- Mobile data is excellent fallback

---

## Utilities

### Electricity

**Provider:** CLP Power (Kowloon/NT) or HK Electric (HK Island)

| Usage | Monthly Cost |
|-------|--------------|
| Studio/1BR | HK$200-500 |
| 2BR | HK$400-800 |
| 3BR | HK$600-1,200 |

**Note:** Summer AC drives costs up significantly.

**Setup:**
- Usually landlord handles account
- Transfer account to your name
- Pay via auto-pay, PPS, or at convenience stores

### Gas

**Provider:** Towngas (most buildings)

| Usage | Monthly Cost |
|-------|--------------|
| Light cooking | HK$50-100 |
| Regular cooking | HK$100-200 |

**Setup:**
- Towngas account in your name
- Deposit may be required
- Pay via auto-pay or 7-Eleven

### Water

**Provider:** Water Supplies Department (Government)

- **Cost:** Very cheap (HK$50-150/month)
- Often included in management fees
- Metered for some buildings

### Utility Tips
- Set up **auto-pay** for all utilities
- Use **PPS** (Payment by Phone) for manual payments
- Keep deposits in mind when budgeting
- AC = biggest electricity cost

---

## Essential Apps

### Must-Have Apps

| App | Purpose | Notes |
|-----|---------|-------|
| **Octopus** | Transport/payments | Essential |
| **MTR Mobile** | MTR journey planner | Official app |
| **OpenRice** | Restaurant discovery | HK's Yelp |
| **Google Maps** | Navigation | Works well |
| **WhatsApp** | Messaging | Everyone uses it |
| **WeChat** | Mainland contacts | Also for payments |
| **Uber/HKTaxi** | Taxis | HKTaxi is local |

### Transport Apps

| App | Use |
|-----|-----|
| **Citymapper** | Best all-in-one transport |
| **MTR Mobile** | MTR specific |
| **KMB/LWB** | Bus arrivals |
| **HKeMobility** | Government transport info |
| **Uber** | Ride-hailing (grey area) |
| **HKTaxi** | Taxi booking |

### Food & Delivery

| App | Type |
|-----|------|
| **OpenRice** | Restaurant reviews/booking |
| **Foodpanda** | Food delivery |
| **Deliveroo** | Food delivery |
| **KeeTa** | Meituan's HK delivery |
| **Inline** | Restaurant queuing |

### Payment Apps

| App | Use |
|-----|-----|
| **Octopus** | Contactless payments |
| **PayMe** | P2P transfers (HSBC) |
| **AlipayHK** | Widely accepted |
| **WeChat Pay HK** | China/HK payments |
| **FPS** | Bank transfers |

### Lifestyle

| App | Use |
|-----|-----|
| **HKO MyWeather** | Official weather app |
| **GovHK** | Government services |
| **eLearning** | Government notifications |
| **Klook** | Activities/tours booking |
| **Carousell** | Buy/sell secondhand |

### Banking Apps
- Each bank has its own app
- HSBC HK app is excellent
- Virtual bank apps (ZA, Mox) very good

---

## Postal & Delivery

### Hongkong Post
- Reliable for local/international mail
- Post offices everywhere
- Standard letter HK: HK$2
- International varies

### Package Delivery
- **SF Express:** Fast, reliable, China links
- **Kerry Express:** Good local option
- **DHL/FedEx/UPS:** International couriers
- **Alfred/Spaceship:** Locker services

### Address Format
```
[Name]
[Floor], [Unit], [Building Name]
[Number] [Street Name]
[District], [Area]
Hong Kong
```

Example:
```
John Smith
12/F, Flat A, Happy Building
123 Nathan Road
Tsim Sha Tsui, Kowloon
Hong Kong
```

---

## Healthcare Registration

### Public Healthcare
- Register at District Health Centre
- Get a Hospital Authority card
- A&E available without registration

### Private Healthcare
- No registration needed
- Pay per visit or use insurance
- Many clinics take walk-ins

### Finding Doctors
- OpenRice but for doctors: **FindDoc**
- Company referrals
- Hospital websites
- Word of mouth

---

## Government Services

### Immigration Department
- Visa extensions
- HKID card issues
- Location: Immigration Tower, Wan Chai

### Inland Revenue Department
- Tax matters
- Online filing available
- Very efficient

### Transport Department
- Driving licenses
- Vehicle registration

### Useful: GovHK Website
- Most services available online
- English fully supported
- 1823 hotline for inquiries

---

## Domestic Helpers

### Common in Hong Kong
- Full-time live-in helpers common
- Minimum wage: HK$4,870/month (2024)
- Employer provides: accommodation, food/allowance, insurance

### Hiring Process
1. Apply through agency or direct
2. Immigration approval needed
3. Contract registration
4. Helper gets visa

### Costs
- Salary: HK$4,870-6,000+/month
- Agency fee: HK$5,000-15,000
- Insurance: HK$300-500/year
- Food allowance: HK$1,200+/month (if not providing food)

---

## Quick Setup Checklist

### First Week
- [ ] Get tourist SIM card
- [ ] Download Octopus app
- [ ] Get Octopus card
- [ ] Download OpenRice, MTR Mobile
- [ ] Download WhatsApp (everyone uses it)

### First Month
- [ ] Apply for HKID (if staying 180+ days)
- [ ] Open bank account (HSBC/virtual bank)
- [ ] Get permanent SIM/phone plan
- [ ] Set up home internet
- [ ] Register utilities in your name
- [ ] Set up FPS/PayMe for payments

### Ongoing
- [ ] Get all essential apps
- [ ] Set up auto-pay for bills
- [ ] Register with consulate
- [ ] Get health insurance sorted
- [ ] Find local doctor/dentist

---

## Pro Tips

1. **WhatsApp is essential** - everyone uses it for everything
2. **Cash still needed** - small shops, markets, some restaurants
3. **Octopus for daily life** - it's the universal payment
4. **FPS for transfers** - instant, free between banks
5. **Virtual banks for speed** - open account in minutes
6. **OpenRice before eating** - check reviews, queue times
7. **Citymapper over Google Maps** - better for HK transport
8. **Keep receipts** - for tax deductions and returns
9. **Learn 7-Eleven services** - pay bills, buy SIMs, top up
10. **Government services online** - surprisingly efficient
