# Hong Kong Dining Practical Guide

Essential information for navigating Hong Kong's dining scene-from payment to dietary needs.

## Tipping Culture

### The Rules

**Tipping is NOT expected in Hong Kong.** Most restaurants add a 10% service charge automatically.

| Situation | Tip Amount | Notes |
|-----------|------------|-------|
| Casual restaurants | None | Service charge included |
| Fine dining | Optional 5-10% | If service exceptional |
| Hotel restaurants | Round up bill | HKD 20-50 if pleased |
| Cha chaan teng | Never | Would be unusual |
| Dai pai dong | Never | Cash only, exact amount |
| Takeaway | Never | Not customary |

### Payment Tips
- **Cash** - Still king at local spots, dai pai dongs, markets
- **Octopus card** - Works at chains, convenience stores, some restaurants
- **Credit cards** - Accepted at mid-range and up; may have minimum (HKD 100-300)
- **Mobile pay** - Alipay, WeChat Pay widely accepted

### Service Charge Notes
- 10% service charge = no extra tip needed
- Service charge goes to the house, not servers
- For truly excellent service, tip in cash directly to server

---

## Dietary Restrictions

### Communicating Restrictions

**Useful phrases:**

| English | Cantonese | Pronunciation |
|---------|-----------|---------------|
| I'm vegetarian |  | Ngo sik jai |
| No meat |  | M yiu yuk |
| No pork |  | M yiu jyu yuk |
| No shellfish |  | M yiu bui lui |
| I'm allergic to... | ... | Ngo dui...man gam |
| Peanuts |  | Fa sang |
| Gluten-free |  | Mo fu jat |
| No MSG |  | M yiu mei jing |

### Common Hidden Ingredients

**Watch out for:**
- **Oyster sauce** - In most stir-fries, vegetable dishes
- **Shrimp paste** - Common in Cantonese cooking
- **Dried shrimp** - In many noodle dishes, congee
- **Chicken/pork stock** - Base for most soups
- **Fish sauce** - Thai restaurants
- **Lard** - Traditional pastries, some dim sum

### Halal Dining

**Halal restaurants:**
| Restaurant | Location | Cuisine | Price (HKD) |
|------------|----------|---------|-------------|
| Islamic Centre Canteen | Wan Chai | Dim sum | 60-120 |
| Bismillah | Wan Chai | Indian-Pakistani | 80-150 |
| Ma's Restaurant | TST | Chinese-Muslim | 60-100 |
| Ebeneezer's | Multiple | Middle Eastern | 80-150 |
| Islam Food | Wan Chai | Chinese-Muslim | 50-90 |

**Halal-friendly tips:**
- Avoid most Cantonese restaurants (pork is ubiquitous)
- Indian restaurants are safest bet
- Ask specifically about cooking oil and utensils

---

## Vegetarian & Vegan Options

### Vegetarian-Friendly Restaurants

**Dedicated Vegetarian:**
| Restaurant | Location | Price (HKD) | Style |
|------------|----------|-------------|-------|
| LockCha | Admiralty/Central | 100-200 | Vegetarian dim sum + tea |
| Veggie Kingdom | TST/Causeway Bay | 100-180 | Chinese vegetarian |
| Grassroots Pantry | Central | 200-350 | Vegan caf |
| Mana! | Central | 100-180 | Vegan bowls |
| Green Common | Multiple | 80-150 | Vegan fast casual |

**Vegetarian Dim Sum:**
| Restaurant | Location | V Options | Notes |
|------------|----------|-----------|-------|
| LockCha | Hong Kong Park | Full menu | Excellent quality |
| One Harbour Road | Grand Hyatt | Set menu | Upscale, advance book |
| Dim Sum Library | Admiralty | Several items | Modern takes |

**Chinese Buddhist Vegetarian:**
- Look for "" (jai) in restaurant name
- Po Lin Monastery (Lantau) - Famous vegetarian lunch
- Wong Tai Sin Temple area - Several options

### Vegan Challenges

**Hard to find vegan:**
- Egg is in almost all noodles, pastries
- Dim sum wrappers often contain egg
- Oyster sauce is default for vegetables

**Vegan-safe orders:**
- Steamed vegetables with garlic (specify no oyster sauce)
- Mapo tofu (ask: vegetarian broth, no pork)
- Stir-fried mushrooms
- Congee (specify vegetable broth)

### Gluten-Free Dining

**Naturally GF options:**
- Rice noodles (, lai fun)
- Congee
- Rice dishes
- Most non-breaded stir-fries

**Watch out for:**
- Soy sauce (contains wheat)-request tamari
- Dumpling/dim sum wrappers
- Noodles (most are wheat)
- Oyster sauce (often contains wheat)

---

## Alcohol Laws & Bars

### Legal Framework
- **Drinking age:** 18
- **Purchase age:** 18
- **No public drinking restrictions** (unlike Singapore)
- **Licensed hours:** Most bars until 2-4am, some 24hr

### Where to Drink

**Craft Beer:**
| Bar | Location | Price (HKD) |
|-----|----------|-------------|
| The Globe | Central | 70-100/pint |
| Moonzen Brewery | Kennedy Town | 60-80 |
| Heroes Beer | Central | 60-90 |
| Yau | Causeway Bay | 80-120 |

**Cocktails:**
| Bar | Location | Price (HKD) | Notes |
|-----|----------|-------------|-------|
| COA | Central | 120-180 | World's Best Bar 2023 |
| The Old Man | Central | 100-150 | Hemingway-themed |
| Quinary | Central | 130-180 | Molecular |
| Stockton | Central | 100-160 | Whisky focus |

**Cheap Drinks:**
| Spot | Location | Price (HKD) |
|------|----------|-------------|
| 7-Eleven | Everywhere | 15-30 |
| Convenience stores | Everywhere | Beer from HKD 12 |
| Lan Kwai Fong happy hour | Central | HKD 40-60/beer |

### Wine in Hong Kong
- **No wine tax** since 2008
- Excellent wine lists at fine dining
- Wine bars: Mashi no Mashi, Somm's Table
- Hotel bars have premium selections

### BYOB Spots
Some dai pai dongs allow bringing your own beer/wine:
- Tung Po (corkage-free)
- Various cooked food centres
- Ask before bringing

---

## Late Night Eating

### 24-Hour Restaurants

| Restaurant | Location | Cuisine | Price (HKD) |
|------------|----------|---------|-------------|
| Lin Heung Tea House | TST | Dim sum | 60-150 |
| Chui Wo Lee | Wong Tai Sin | Dai pai dong | 50-120 |
| McDonald's | Various | Fast food | 30-60 |
| Fairwood | Various | HK fast food | 40-80 |
| Caf de Coral | Various | HK fast food | 40-80 |

### Late Night (Until 2-4am)

**Noodles & Congee:**
| Restaurant | Location | Hours | Known For |
|------------|----------|-------|-----------|
| Tasty Congee | Multiple | Until 4am | Congee, noodles |
| Good Hope Noodle | Mong Kok | Until 4am | Cart noodles |
| Law Fu Kee | Jordan | Until 3am | Congee |

**Dai Pai Dong/Cooked Food:**
| Restaurant | Location | Hours | Specialty |
|------------|----------|-------|-----------|
| Tung Po | Wan Chai | Until 1am | Full menu, karaoke |
| Temple Street stalls | Jordan | Until midnight | Claypot, seafood |
| Daisy Kitchen | Sai Ying Pun | Until 2am | Stir-fry |

**Hot Pot:**
| Restaurant | Location | Hours | Price (HKD) |
|------------|----------|-------|-------------|
| Lau Haa | Causeway Bay | Until 2am | 200-400 |
| Hot Pot restaurants | Various | Many until midnight+ | Varies |

### Early Morning (3am-7am)

The special category-for night owls and early risers:

| Restaurant | Location | Opens | Known For |
|------------|----------|-------|-----------|
| Sun Hing | Kennedy Town | 3am | Traditional dim sum |
| Chui Wo Lee | Wong Tai Sin | 24hr | Dim sum from 2:30am |
| Some cha chaan tengs | Various | 6am | Breakfast sets |

---

## Quick Reference

### Restaurant Categories by Budget

| Budget | Per Person (HKD) | Options |
|--------|------------------|---------|
| $ | Under 100 | Street food, cha chaan teng, budget noodles |
| $$ | 100-300 | Dai pai dong, casual dining, dim sum |
| $$$ | 300-800 | Mid-range, hotel lunches, popular spots |
| $$$$ | 800-2,000 | Fine dining, Michelin starred |
| $$$$$ | 2,000+ | Three-star, omakase |

### When Things Are Closed
- **Public holidays:** Many local spots closed during Chinese New Year (1-3 days)
- **Sundays:** Some business-district restaurants closed
- **Typhoon Signal 8+:** Most restaurants close; hotels stay open

### Essential Apps
- **OpenRice** - Reviews, reservations (Chinese & English)
- **Google Maps** - Restaurant finding, hours
- **The Fork** - International restaurant bookings
- **Eatigo** - Discounts on restaurants

### Useful Tips Summary
1. **Carry cash** - Many local spots don't take cards
2. **Book ahead** for Michelin spots and weekend dim sum
3. **Lunch sets** offer 30-50% savings at fine dining
4. **Service charge** = no tip needed
5. **Ask about dietary needs** before ordering, not after
6. **Peak hours:** 12:30-1:30pm lunch, 7:30-8:30pm dinner
7. **Queue culture:** Lines at famous spots are normal-join them!
8. **Table sharing** is common at busy local restaurants
