# Hong Kong Local Cuisine Guide

Cantonese cuisine reigns supreme in Hong Kong, with centuries-old traditions preserved alongside modern innovations. This guide covers the essential local dishes and where to find the best versions.

## Dim Sum Essentials

### The Classic Dishes

**Har Gau - Shrimp Dumplings**
- Translucent wrapper, plump shrimp filling
- Hallmark of dim sum craftsmanship
- Best: Fook Lam Moon (HKD 68), Maxim's Palace (HKD 42)

**Siu Mai - Pork & Shrimp Dumplings**
- Open-topped, yellow wrapper, often topped with crab roe
- Best: Tim Ho Wan (HKD 32), One Dim Sum (HKD 28)

**Cha Siu Bao - BBQ Pork Buns**
- Fluffy white steamed bun with sweet BBQ pork
- Best: Tim Ho Wan's baked version (famous crispy top)
- Classic steamed: Lin Heung Lau, Maxim's Palace

**Cheung Fun - Rice Noodle Rolls**
- Silky rice sheets with shrimp, beef, or char siu
- Best: Mak's Noodle (simple), Duddell's (premium)

**Lo Mai Gai - Sticky Rice in Lotus Leaf**
- Glutinous rice with chicken, mushroom, wrapped in lotus
- Best: Sun Tung Lok, Eton Restaurant

### Top Dim Sum Restaurants

**Budget-Friendly (HKD 50-120/person)**
| Restaurant | Location | Specialty | Hours |
|------------|----------|-----------|-------|
| Tim Ho Wan | Sham Shui Po | Baked cha siu bao | 10am-9pm |
| One Dim Sum | Prince Edward/Central | Traditional | 9:30am-10pm |
| Dim Dim Sum | Mong Kok | Wasabi dumplings | 10am-midnight |
| Sun Hing | Kennedy Town | Classic (from 3am!) | 3am-4pm |

**Mid-Range (HKD 150-300/person)**
| Restaurant | Location | Specialty | Hours |
|------------|----------|-----------|-------|
| Yat Tung Heen | Jordan (Eaton HK) | Mango rice rolls | 11am-3pm, 6-10pm |
| Eton Restaurant | Mong Kok | Honey egg rolls | 10am-11pm |
| Lin Heung Lau | Central | Cart-service | 6am-11pm |
| Luk On Kui | Sheung Wan | Classic Cantonese | 6am-5pm |

**Upscale (HKD 400-1,000/person)**
| Restaurant | Location | Specialty | Hours |
|------------|----------|-----------|-------|
| Lung King Heen | Four Seasons | Lobster dumplings | 11:30am-2:30pm |
| Duddell's | Central | Contemporary | 12pm-3pm |
| Spring Moon | The Peninsula | X.O. sauce | 11:30am-2:30pm |
| Man Wah | Mandarin Oriental | Refined classics | 12pm-2:30pm |

## Cantonese Roast Meats

### The Holy Trinity

**Roast Goose**
Hong Kong's signature roast-crispy skin, juicy meat, served over rice or noodles.

**Best restaurants:**
- **Yat Lok** (Central) - Michelin 1-star, HKD 88 for plate
  - 34-38 Stanley Street, Central
  - Known for perfectly crispy skin
- **Kam's Roast Goose** (Wan Chai) - Michelin 1-star, HKD 98
  - Po Wah Commercial Centre, Hennessy Road
  - Premium quality, longer queues
- **Yung Kee** (Central) - Historic, HKD 138
  - 32-40 Wellington Street
  - Iconic since 1942

**Char Siu - BBQ Pork**
Honey-glazed, caramelized pork-sweet, savory, slightly charred edges.

**Best restaurants:**
- **Joy Hing Roasted Meat** (Wan Chai) - HKD 45 for rice plate
  - 265-267 Hennessy Road
  - Pink, melt-in-mouth char siu
- **Sun Kee** (Western District) - HKD 52
  - Known for fatty, traditional style
- **Kam's Roast Goose** - Premium Iberico char siu, HKD 88

**Siu Yuk - Roast Pork Belly**
Crackling crispy skin, succulent pork layers.

**Best restaurants:**
- **Yung Kee** - Classic preparation
- **Yat Lok** - Excellent accompaniment to goose
- **Loaf On** (Sheung Wan) - Michelin 1-star

### Where to Get Roast Meat Combo
- Order "" (roast three treasures rice) for char siu + roast pork + roast goose/duck
- Price: HKD 68-120 at most shops

## Wonton Noodles

### The Dish
Thin egg noodles in shrimp-enriched broth, topped with plump shrimp wontons. The noodles should be springy ("al dente"), wontons should be 70% shrimp, 30% pork.

### Best Wonton Noodle Shops

**Michelin Recognized:**
| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| Tsim Chai Kee | Wellington St, Central | HKD 45 | Bib Gourmand, always packed |
| Mak's Noodle | Wellington St, Central | HKD 48 | Classic preparation |
| Ho Hung Kee | Causeway Bay | HKD 52 | Michelin 1-star |

**Local Favorites:**
| Restaurant | Location | Price | Notes |
|------------|----------|-------|-------|
| Lau Sum Kee | Fuk Wing Street, SSP | HKD 38 | Handmade bamboo noodles |
| Kwan Kee | Cheung Sha Wan | HKD 35 | Old-school atmosphere |
| Wing Wah | Wan Chai | HKD 42 | Generous portions |

### Noodle Ordering Tips
- "" (jau cheng) = no spring onions
- "" (ga dai) = extra noodles
- "" (lou mein) = dry noodles, soup on side

## Congee

**Classic varieties:**
- **Sampan congee** - Mixed seafood, peanuts, youtiao
- **Century egg & pork** - Most popular
- **Fish slice** - Light, delicate

**Best spots:**
- **Sang Kee** (Western District) - HKD 38-55
- **Tasty Congee & Noodle** (multiple) - HKD 42-60
- **Law Fu Kee** (Jordan) - Open late

## Dai Pai Dong Culture

### What to Expect
- Open-air cooking with industrial wok burners
- Communal tables, plastic stools
- No menus at some-ask what's fresh
- Cash only at traditional spots
- BYOB beer at many locations

### Best Dai Pai Dongs

**Traditional (Street-side):**
| Name | Location | Specialty | Price Range |
|------|----------|-----------|-------------|
| Sing Kee | Stanley St, Central | Sweet & sour pork, claypot | HKD 80-150/person |
| Oi Man Sing | Sham Shui Po | Razor clams, typhoon shelter crab | HKD 100-200 |
| Keung Kee | Ki Lung St, SSP | Claypot rice, beef ho fun | HKD 60-100 |

**Modern/Indoor:**
| Name | Location | Specialty | Price Range |
|------|----------|-----------|-------------|
| Tung Po | KONNECT, Wan Chai | Wind sand chicken, karaoke | HKD 150-250 |
| ChorLand | Multiple | Truffle beef balls | HKD 100-180 |
| Ladies Street Sik Faan | TST/Mong Kok | Nostalgic decor, grouper | HKD 120-200 |

**Cooked Food Centres:**
- **Bowrington Cooked Food Centre** (Wan Chai) - Multiple stalls, local favorite
- **Haiphong Road Hawker Bazaar** (TST) - 9 stalls, renovated 2020
- **Woosung Street Hawker Bazaar** (Yau Ma Tei) - Seafood focus, evening dining

### Must-Order Dai Pai Dong Dishes
1. **Typhoon shelter crab** - Garlic-fried crab
2. **Salt & pepper squid**
3. **Stir-fried clams with black beans**
4. **Wind sand chicken**
5. **Claypot rice** - Winter specialty
6. **Garlic morning glory**

## Hidden Local Gems

### Off-the-Tourist-Path

**Noodles:**
- **Sister Wah** - Tin Hau, satay beef noodles (Bib Gourmand)
- **Good Hope Noodle** - Mong Kok, late night

**Claypot Rice:**
- **Kwan Kee** - Queen's Road West, charcoal-fired
- **Four Seasons** - Temple Street, traditional

**Offal & Adventurous:**
- **Tso Kee** - Yau Ma Tei, beef offal
- **Temple Street Beef Offal** - Michelin Selected

**Desserts:**
- **Yuen Kee Dessert** - Causeway Bay, tofu pudding
- **Kung Wo Beancurd** - Sham Shui Po, fresh beancurd

### Best for Locals-Only Experience
1. Arrive at Sun Hing at 4am for fresh dim sum with taxi drivers
2. Order by pointing at other tables' dishes
3. Rinse your bowl and chopsticks with tea before eating
4. Share a beer (San Miguel is classic) at dai pai dong
5. Finish with a sweet tofu pudding

## Seasonal Specialties

| Season | Specialty | Where to Try |
|--------|-----------|--------------|
| Jan-Mar | Pen cai | Yuen Long restaurants |
| Apr-Jun | Hairy crab | Fook Lam Moon |
| Sep-Nov | Claypot rice | Kwan Kee, Four Seasons |
| Oct-Dec | Snake soup | Ser Wong Fun (since 1895) |
| Year-round | Roast meats, dim sum | Everywhere |
