# Hong Kong Cost of Living Guide

> Last updated: February 2025 | Currency: HKD (1 USD  7.8 HKD)

## Overview

Hong Kong is **expensive**, particularly for housing. It consistently ranks among the world's most expensive cities. However, daily expenses like food, transport, and entertainment can be very affordable if you know where to look.

**Key insight:** Rent is the main expense. Everything else can range from cheap to luxurious depending on your choices.

---

## Monthly Budget Summary

### Budget Breakdown by Lifestyle

| Category | Budget | Mid-Range | Comfortable |
|----------|--------|-----------|-------------|
| **Rent (studio/1BR)** | HK$8,000-12,000 | HK$15,000-20,000 | HK$25,000-40,000 |
| **Food** | HK$3,000-4,000 | HK$5,000-7,000 | HK$10,000+ |
| **Transport** | HK$500-800 | HK$800-1,200 | HK$1,500+ |
| **Utilities** | HK$500-800 | HK$1,000-1,500 | HK$1,500-2,500 |
| **Phone/Internet** | HK$200-350 | HK$350-500 | HK$500+ |
| **Entertainment** | HK$1,000-2,000 | HK$3,000-5,000 | HK$8,000+ |
| **TOTAL** | **HK$13,000-20,000** | **HK$25,000-35,000** | **HK$45,000-70,000** |
| **USD Equivalent** | **$1,650-2,550** | **$3,200-4,500** | **$5,750-9,000** |

---

## Rent (The Big One)

Housing is Hong Kong's defining expense. Expect small spaces at high prices.

### Rent by Area (Monthly)

| Area | Studio/1BR | 2BR | 3BR | Notes |
|------|------------|-----|-----|-------|
| **Central/Mid-Levels** | HK$20,000-35,000 | HK$35,000-55,000 | HK$50,000-80,000 | Prime location, expat heavy |
| **Wan Chai/Causeway Bay** | HK$18,000-28,000 | HK$30,000-45,000 | HK$45,000-70,000 | Busy, nightlife, shopping |
| **Tsim Sha Tsui** | HK$15,000-25,000 | HK$25,000-40,000 | HK$40,000-60,000 | Tourist area, convenient |
| **Mong Kok/Yau Ma Tei** | HK$12,000-18,000 | HK$20,000-30,000 | HK$30,000-45,000 | Local vibe, markets |
| **Sham Shui Po** | HK$10,000-14,000 | HK$15,000-22,000 | HK$25,000-35,000 | Budget area, gentrifying |
| **Tai Po/Sha Tin** | HK$10,000-16,000 | HK$18,000-28,000 | HK$25,000-38,000 | New Territories, more space |
| **Tung Chung** | HK$12,000-18,000 | HK$20,000-30,000 | HK$28,000-45,000 | Near airport, newer builds |
| **Discovery Bay** | HK$18,000-28,000 | HK$30,000-45,000 | HK$45,000-70,000 | Expat suburb, beach |

### What Rent Gets You
- **HK$10,000-15,000**: Tiny studio (~200-300 sq ft), older building, outer areas
- **HK$15,000-20,000**: Small 1BR (~350-450 sq ft), decent building
- **HK$20,000-30,000**: 1BR in good location OR 2BR in outer area
- **HK$30,000+**: Comfortable space in prime location

### Hidden Costs (IMPORTANT!)

| Cost | Amount | Notes |
|------|--------|-------|
| **Security Deposit** | 2 months' rent | Refundable at end |
| **Agency Fee** | 0.5-1 month's rent | Usually split with landlord |
| **Stamp Duty** | ~0.25-0.5% of total rent | Government tax |
| **First Month** | 1 month advance | Standard |

**Total upfront:** 3.5-4.5 months' rent before moving in!

---

## Food & Dining

Hong Kong has incredible food at every price point.

### Restaurant Prices (per person)

| Type | Price Range | Examples |
|------|-------------|----------|
| **Cha Chaan Teng** (local cafe) | HK$40-70 | Breakfast sets, milk tea |
| **Dai Pai Dong** (street stall) | HK$30-60 | Noodles, rice dishes |
| **Fast Food** | HK$45-60 | McDonald's combo: HK$50 |
| **Casual Restaurant** | HK$80-150 | Local Chinese, Japanese chains |
| **Mid-range** | HK$200-400 | Decent sit-down |
| **Dim Sum** | HK$150-300 | Yum cha brunch |
| **Fine Dining** | HK$500-1,500+ | Michelin-starred |

### Grocery Prices

| Item | Price (HKD) | USD |
|------|-------------|-----|
| Milk (1L) | HK$24 | $3.00 |
| Bread (500g) | HK$18 | $2.30 |
| Rice (1kg) | HK$16 | $2.00 |
| Eggs (12) | HK$26 | $3.30 |
| Chicken breast (1kg) | HK$78 | $10.00 |
| Beef (1kg) | HK$163 | $21.00 |
| Apples (1kg) | HK$30 | $3.80 |
| Bananas (1kg) | HK$19 | $2.40 |
| Tomatoes (1kg) | HK$24 | $3.10 |
| Bottled water (1.5L) | HK$15 | $1.90 |
| Local beer (0.5L) | HK$14 | $1.80 |
| Wine (mid-range) | HK$125 | $16.00 |

### Where to Shop
- **Wellcome/PARKnSHOP**: Main supermarkets, reasonable prices
- **Market Street**: Wet markets for fresh produce, cheaper
- **AEON/City'super**: Premium supermarkets, imports
- **759 Store**: Discount snacks and groceries

### Eating Budget Tips
- Local cha chaan teng = HK$40-60 per meal
- Cook at home = HK$100-150/day
- Wet markets = 30-50% cheaper than supermarkets
- Lunch sets cheaper than dinner

---

## Drinks & Coffee

| Item | Price Range |
|------|-------------|
| Milk tea (local) | HK$15-25 |
| Starbucks coffee | HK$40-55 |
| Local cafe coffee | HK$25-40 |
| Beer (bar) | HK$50-100 |
| Beer (convenience store) | HK$15-25 |
| Cocktail (bar) | HK$80-150 |
| Bottled water (0.5L) | HK$8-10 |
| Soft drink | HK$10-15 |

---

## Transport Costs

Hong Kong transport is remarkably cheap.

| Transport | Monthly Cost |
|-----------|--------------|
| MTR commute | HK$400-800 |
| Monthly Pass | HK$435-800 |
| Buses | HK$200-400 |
| Total typical | **HK$500-1,200** |

*See transport.md for detailed fares*

---

## Utilities

### Monthly Costs (2-person apartment)

| Utility | Range | Notes |
|---------|-------|-------|
| Electricity | HK$400-800 | Higher with AC in summer |
| Gas | HK$100-200 | Towngas |
| Water | HK$100-200 | Very cheap |
| **Total** | HK$600-1,200 | ~HK$1,700 average for 85m |

### Notes
- Electricity expensive in summer (AC)
- Many buildings include water
- No central heating needed

---

## Telecom & Internet

### Mobile Plans

| Type | Monthly Cost | Data |
|------|--------------|------|
| Budget | HK$50-100 | 5-10GB |
| Standard | HK$150-200 | 15-30GB |
| Unlimited | HK$200-400 | Unlimited |

Main carriers: **3 Hong Kong**, **csl**, **SmarTone**, **China Mobile HK**

### Home Internet
- Basic broadband: HK$150-200/month
- High-speed (1Gbps): HK$200-400/month
- Often bundled with mobile

---

## Entertainment

### Common Costs

| Activity | Price |
|----------|-------|
| Cinema ticket | HK$90-150 |
| Gym membership | HK$300-1,500/month |
| Yoga class (drop-in) | HK$150-300 |
| Concert ticket | HK$300-1,500+ |
| Museum entry | HK$0-30 (many free) |
| Theme park (Ocean Park) | HK$498 |
| Disneyland | HK$639+ |

### Nightlife
- Happy hour drinks: HK$40-60
- Club entry: HK$150-400
- LKF (Lan Kwai Fong) expensive: HK$100+ per drink

---

## Healthcare

### Public vs Private

| Type | Cost | Notes |
|------|------|-------|
| Public hospital | HK$100/day | Long waits, subsidized |
| Private GP visit | HK$300-600 | Quick |
| Private specialist | HK$800-2,000+ | Varies widely |
| Private hospital | HK$3,000-10,000+/day | Full-service |

### Insurance
- Basic medical: HK$3,000-8,000/year
- Comprehensive: HK$10,000-30,000+/year
- Many employers provide coverage

---

## Taxes (The Good News!)

Hong Kong has a simple, low-tax system-one of its biggest advantages.

### Salaries Tax (Income Tax)

| Net Taxable Income (HKD) | Tax Rate |
|--------------------------|----------|
| 0 - 50,000 | 2% |
| 50,001 - 100,000 | 6% |
| 100,001 - 150,000 | 10% |
| 150,001 - 200,000 | 14% |
| Above 200,000 | 17% |

**Maximum rate: 15%** on total income (standard rate) or progressive (whichever is lower).

### What's NOT Taxed
-  No VAT/GST
-  No sales tax
-  No capital gains tax
-  No dividend tax
-  No inheritance/estate tax (abolished 2006)
-  No tax on worldwide income (territorial system)

### Tax Deductions
- MPF contributions
- Self-education expenses
- Charitable donations
- Home loan interest
- Various personal allowances

**Filing:** Annual (April 1 year-end), simple online system.

---

## Cost Comparison

### Hong Kong vs Other Cities

| Expense | Hong Kong | Singapore | NYC | London |
|---------|-----------|-----------|-----|--------|
| 1BR Rent (City) | HK$17,400 | S$3,000 | $3,500 | 2,200 |
| Meal (cheap) | HK$60 | S$8 | $15 | 12 |
| Monthly Transit | HK$550 | S$120 | $127 | 160 |
| Cappuccino | HK$39 | S$6 | $5 | 3.50 |
| Income Tax (top) | 15% | 22% | 37%+ | 45% |

---

## Money-Saving Tips

### Accommodation
1. Live in Kowloon/NT instead of HK Island
2. Share apartments (common for young professionals)
3. Consider serviced apartments for short-term
4. Negotiate rent (market favors tenants recently)

### Food
1. Eat at cha chaan tengs and local spots
2. Shop at wet markets
3. Cook at home occasionally
4. Lunch sets are 20-40% cheaper than dinner

### General
1. Use Octopus card everywhere
2. Skip LKF nightlife (expensive)
3. Happy hours are your friend
4. Free hiking and beaches everywhere
5. Many museums free on Wednesdays

---

## Sample Monthly Budgets

### Solo Professional (Mid-Range)
| Category | Amount |
|----------|--------|
| Rent (1BR Kowloon) | HK$16,000 |
| Food | HK$5,000 |
| Transport | HK$800 |
| Utilities | HK$1,000 |
| Phone/Internet | HK$400 |
| Entertainment | HK$3,000 |
| Misc | HK$2,000 |
| **TOTAL** | **HK$28,200 (~$3,600)** |

### Couple (Comfortable)
| Category | Amount |
|----------|--------|
| Rent (2BR good area) | HK$30,000 |
| Food | HK$8,000 |
| Transport | HK$1,500 |
| Utilities | HK$1,500 |
| Phone/Internet | HK$600 |
| Entertainment | HK$5,000 |
| Helper (optional) | HK$5,500+ |
| Misc | HK$3,000 |
| **TOTAL** | **HK$55,100 (~$7,000)** |

---

## Average Salary Context

- **Average monthly salary:** HK$25,600 (~$3,280)
- **Median household income:** HK$30,000 (~$3,850)
- **Expat professional salary:** HK$50,000-150,000+ depending on role

**Reality check:** Many locals struggle with housing costs. Expats often have housing allowances.
