# Hong Kong Climate Guide

> Last updated: February 2025 | Source: Hong Kong Observatory (1991-2020 normals)

## Overview

Hong Kong has a **subtropical climate** with distinct seasons. Summers are hot and humid with typhoons; winters are mild and dry. The city is designed around its climate-expect heavy air conditioning and covered walkways.

**Key fact:** Humidity is the defining feature. Summer feels hotter than the numbers suggest.

---

## Annual Climate Summary

| Metric | Annual Average |
|--------|----------------|
| Mean temperature | 23.5C (74.3F) |
| Mean max temperature | 26.0C (78.8F) |
| Mean min temperature | 21.6C (70.9F) |
| Annual rainfall | 2,431 mm (96 inches) |
| Rainy days | 140 days/year |
| Mean humidity | 78% |
| Sunshine hours | 1,829 hours/year |

---

## Seasonal Breakdown

### Spring (March - May)

| Month | Avg Temp | Rain | Humidity |
|-------|----------|------|----------|
| March | 19.5C (67F) | 75mm | 82% |
| April | 23.0C (73F) | 153mm | 83% |
| May | 26.3C (79F) | 291mm | 83% |

**What to expect:**
-  Pleasant early spring, warming rapidly
-  Rain increases, especially May
-  **Fog season** (Feb-Mar)-affects flights
-  Light layers, umbrella essential

**Activities:**
-  Great for hiking (Mar-Apr)
-  Outdoor activities (before May heat)
-  May getting humid

---

### Summer (June - September)

| Month | Avg Temp | Rain | Humidity |
|-------|----------|------|----------|
| June | 28.3C (83F) | 492mm | 82% |
| July | 28.9C (84F) | 386mm | 81% |
| August | 28.7C (84F) | 453mm | 81% |
| September | 27.9C (82F) | 321mm | 78% |

**What to expect:**
-  **HOT and HUMID** - feels like 35C+
-  Peak rainfall (June = wettest month)
-  **Typhoon season** (June-September)
-  Frequent thunderstorms

**Activities:**
-  Beach/pool weather
-  Indoor malls, museums (escape AC)
-  Outdoor hiking challenging
-  Check typhoon signals

---

### Autumn (October - November)

| Month | Avg Temp | Rain | Humidity |
|-------|----------|------|----------|
| October | 25.7C (78F) | 120mm | 73% |
| November | 22.2C (72F) | 39mm | 72% |

**What to expect:**
-  **BEST WEATHER** of the year
-  Clear skies, low humidity
-  Comfortable temperatures
-  Sunny and dry

**Activities:**
-  Perfect for hiking
-  Outdoor activities ideal
-  Beach still possible (Oct)
-  Photography (clear skies)

---

### Winter (December - February)

| Month | Avg Temp | Rain | Humidity |
|-------|----------|------|----------|
| December | 18.2C (65F) | 29mm | 70% |
| January | 16.5C (62F) | 33mm | 74% |
| February | 17.1C (63F) | 39mm | 79% |

**What to expect:**
-  Cool but **mild** (rarely below 10C)
-  Overcast, occasional cold snaps
-  Need jacket, layers
-  Fog returns (Feb)

**Activities:**
-  Comfortable hiking weather
-  Indoor activities comfortable
-  Christmas markets/events
-  Chinese New Year (Jan/Feb)

---

## Typhoon Season

### When & Frequency
- **Season:** June - October (peak: July-September)
- **Average:** 6-8 typhoons approach HK per year
- **T8 signals:** ~2.4 days per year
- **Direct hits:** Rare but happen

### Typhoon Warning Signals

| Signal | Wind Speed | What Happens |
|--------|------------|--------------|
| **T1** | Typhoon 800km away | Standby |
| **T3** | Strong winds expected | Some transport affected |
| **T8** | Gale force (63+ km/h) | **Everything closes** |
| **T9** | Increasing gale | Stay indoors |
| **T10** | Hurricane force | Severe, rare |

### What To Do
1. **Monitor:** Hong Kong Observatory (hko.gov.hk)
2. **T8+ issued:**
   - Work/school suspended
   - MTR may continue (reduced)
   - Buses/ferries stop
   - Stay indoors
   - Stock up on food/water
3. **After typhoon:** Check transport before going out

### Typhoon Tips
- Buildings are typhoon-proof-stay inside
- Tape windows (some people do)
- Keep devices charged
- T8 = legitimate day off work

---

## Monthly Climate Data

### Temperature (C)

| Month | Daily Max | Mean | Daily Min |
|-------|-----------|------|-----------|
| January | 18.7 | 16.5 | 14.6 |
| February | 19.4 | 17.1 | 15.3 |
| March | 21.9 | 19.5 | 17.6 |
| April | 25.6 | 23.0 | 21.1 |
| May | 28.8 | 26.3 | 24.5 |
| June | 30.7 | 28.3 | 26.5 |
| July | 31.6 | 28.9 | 26.9 |
| August | 31.3 | 28.7 | 26.7 |
| September | 30.5 | 27.9 | 26.1 |
| October | 28.1 | 25.7 | 23.9 |
| November | 24.5 | 22.2 | 20.3 |
| December | 20.4 | 18.2 | 16.2 |

### Rainfall (mm)

| Month | Rainfall | Rainy Days |
|-------|----------|------------|
| January | 33 | 5.7 |
| February | 39 | 8.0 |
| March | 75 | 10.5 |
| April | 153 | 11.4 |
| May | 291 | 15.4 |
| June | **492** | 19.3 |
| July | 386 | 18.4 |
| August | 453 | 17.5 |
| September | 321 | 14.9 |
| October | 120 | 7.8 |
| November | 39 | 5.7 |
| December | 29 | 5.3 |

---

## Best Times to Visit

### Ideal: October - December
-  Clear skies
-  Low humidity (70-73%)
-  Comfortable temperatures
-  No typhoons
-  Best for outdoor activities

### Good: March - April
-  Warming up, pleasant
-  Some fog (Mar)
-  Rain increasing (Apr)

### Challenging: June - September
-  Very hot and humid
-  Typhoon risk
-  Heavy rain
-  Good for beaches/pools
-  Off-peak pricing

### Acceptable: January - February
-  Cool, overcast
-  Chinese New Year crowds
-  Some fog (Feb)

---

## Surviving Summer Humidity

### The Reality
- Humidity **80%+** with 30C+ = oppressive
- "Feels like" temperature often 35-40C
- You **will** sweat constantly
- Clothes stick, glasses fog

### Survival Tips

1. **Embrace AC**
   - Malls, MTR, restaurants = refuges
   - Carry a light cardigan (AC is COLD)
   - Plan activities around indoor breaks

2. **Hydration**
   - Drink water constantly
   - Electrolytes help
   - Avoid excessive alcohol

3. **Clothing**
   - Light, breathable fabrics
   - Quick-dry materials
   - Bring spare shirt
   - Avoid dark colors

4. **Timing**
   - Early morning/evening for outdoor activities
   - Midday = indoor time
   - Dawn hiking popular

5. **Other**
   - Carry tissues/handkerchief
   - Umbrella for sun AND rain
   - Sunscreen essential
   - Portable fan helpful

---

## Indoor vs Outdoor Culture

### Summer (Indoor Focus)
Hong Kong is designed for summer heat:
- Massive **air-conditioned malls**
- Connected walkways between buildings
- MTR stations cool
- "Mall culture" dominant

**Popular summer activities:**
- Shopping malls
- Cinema
- Indoor dining
- Museums
- Swimming pools

### Autumn/Winter (Outdoor Prime)
When weather improves, Hong Kongers go outside:
- Hiking trails busy
- Country parks popular
- Outdoor dining
- Beach (autumn)

---

## What to Pack by Season

### Summer (June-September)
- Lightweight, breathable clothes
- Light cardigan/jacket (for AC)
- Umbrella (compact, sturdy)
- Sunscreen, sunglasses, hat
- Waterproof bag for electronics
- Sandals + walking shoes

### Autumn (October-November)
- Light layers
- Long pants, light jacket
- Comfortable walking shoes
- Hiking gear (optional)
- Light rain jacket

### Winter (December-February)
- Warm layers (not heavy winter coat)
- Medium jacket/fleece
- Scarf (cold days)
- Closed shoes
- Umbrella

### Spring (March-May)
- Layers (temperature varies)
- Rain jacket/umbrella
- Light sweater
- Sunscreen (starting to need)

---

## Climate vs Lifestyle

### Adaptations
- **Malls:** Climate-controlled social centers
- **Covered walkways:** Connect major areas
- **Drinking water:** Available everywhere
- **AC everywhere:** Sometimes too cold!
- **Indoor exercise:** Gyms popular year-round

### Work Impact
- T8 typhoon = legitimate work closure
- Summer dress codes often relaxed
- Many offices overcool (bring layers)

---

## Quick Reference

| Question | Answer |
|----------|--------|
| Best weather? | October-November |
| Avoid? | June (wettest) |
| Typhoon peak? | August-September |
| Coldest month? | January (16.5C avg) |
| Hottest month? | July (28.9C avg) |
| Need AC? | May-October definitely |
| Need heating? | Rarely, occasional in Jan |
| Rain gear? | Year-round, essential Apr-Sep |
