---
name: Hong Kong
slug: hong-kong
version: 1.0.1
description: Navigate Hong Kong as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, MTR transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"HK","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Hong Kong for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Central, Admiralty, SoHo, Mid-Levels | `neighborhoods-central.md` |
| Causeway Bay, Wan Chai, Happy Valley | `neighborhoods-causeway.md` |
| TST, Mong Kok, Jordan, West Kowloon | `neighborhoods-kowloon.md` |
| Sha Tin, Tai Po, Tuen Mun, Tsuen Wan | `neighborhoods-newterritories.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Cantonese & dim sum | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, alcohol, practical | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| MTR, buses, ferries, taxis | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & typhoons | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Company setup & taxes | `business.md` |
| Visas (employment, QMAS, Top Talent) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. World-Class Transit City
Unlike most Asian cities, Hong Kong has exceptional public transport:
- **MTR**: 10 metro lines, 99.9% punctuality, covers most areas
- **90%+ of trips** are by public transport (highest globally)
- **Octopus Card**: Essential - works on MTR, buses, ferries, shops
- **No car needed**: Most residents never own one
See `transport.md` for complete network guide.

### 3. Housing Reality
Hong Kong is the world's most expensive housing market:
- **Tiny spaces**: 300-500 sq ft is normal for apartments
- **High prices**: HK$15,000-25,000/month for small 1BR in decent area
- **Agent fees**: 0.5-1 month rent
- **Deposits**: 2 months typical
See `cost.md` and `neighborhoods-choosing.md`.

### 4. Climate & Typhoons
- **Summer (May-Sep)**: 30-33C, very humid (80%+), typhoons possible
- **Winter (Dec-Feb)**: 14-20C, dry, pleasant
- **Typhoon signals**: T8+ means city shuts down
- **Best time to visit**: October-December (dry, mild)
See `climate.md` for seasonal breakdown.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (Central) | HK$20,000-35,000/month (~$2,500-4,500) |
| 1BR rent (Kowloon) | HK$12,000-20,000/month (~$1,500-2,500) |
| Senior SWE salary | HK$60,000-100,000/month (~$7,700-12,800) |
| MTR monthly pass | HK$435-485 (~$56-62) |
| Dim sum lunch | HK$100-200/person (~$13-26) |
| International school | HK$150,000-280,000/year (~$19K-36K) |

### 6. Tax Advantages
Hong Kong has one of the world's simplest, lowest tax regimes:
- **Personal income**: Max 17% (progressive 2-17%)
- **No capital gains tax**
- **No dividend tax**
- **No VAT/GST**
- **Corporate tax**: 8.25% (first HK$2M), 16.5% thereafter
See `business.md` for details.

### 7. Visa Pathways
Multiple routes to live and work in Hong Kong:
- **Employment Visa**: Employer sponsorship required
- **Top Talent Pass Scheme**: For graduates of top 100 universities
- **QMAS (Quality Migrant)**: Points-based system
- **Investment Visa**: HK$30M+ investment
- **PR after 7 years**: Continuous ordinary residence
See `visas.md` for complete requirements.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | Central, Wan Chai, Causeway Bay |
| Families | Discovery Bay, Tai Po, Sha Tin |
| Budget-conscious | Sham Shui Po, Mong Kok, Tuen Mun |
| Tech workers | Causeway Bay, Quarry Bay, Kowloon Bay |
| Expat enclaves | Mid-Levels, Discovery Bay, Stanley |
| Nightlife lovers | Lan Kwai Fong, Wan Chai, TST |

## Language Reality

Hong Kong is officially trilingual:
- **Cantonese**: Local language, used daily by 90%+
- **English**: Official, widely understood in business/tourism
- **Mandarin**: Increasing since 1997, varies by generation
Most expats survive on English alone, but Cantonese helps significantly.

## Hong Kong-Specific Traps

- **Housing size shock** - 400 sq ft is a "decent" flat. Adjust expectations.
- **Typhoon underestimation** - T8 signal = stay indoors. Don't ignore warnings.
- **Summer humidity** - 90%+ humidity feels brutal. Indoor culture May-September.
- **Smoking laws** - Indoor smoking banned. Heavy fines (HK$5,000).
- **MTR eating ban** - No food or drink on MTR. HK$2,000 fine.
- **Octopus required** - Cash is dying. Get Octopus card immediately.
- **Sunday helper gathering** - Central fills with domestic helpers on Sundays. Plan accordingly.
- **Public holiday crowds** - Major holidays = everything crowded. Book ahead.
- **Air conditioning extremes** - Bring layers. Indoor AC is arctic in summer.
- **Queue culture** - Hong Kongers queue. Don't cut lines.

## Legal Awareness

Key laws visitors/residents must know:
- **Drugs**: Zero tolerance. Possession can mean 7+ years prison.
- **National Security Law**: Political speech restrictions since 2020.
- **Photography**: Generally fine, but not government buildings.
- **Jaywalking**: Technically illegal, but loosely enforced.
- **Alcohol**: Legal at 18. No public drinking restrictions.
- **LGBTQ+**: Legal, increasingly accepted, but no same-sex marriage.
- **Gambling**: Only horse racing and Mark Six lottery are legal.

See `safety.md` for comprehensive legal guidance.

## Greater Bay Area Context

Hong Kong is part of the GBA (Greater Bay Area) with Shenzhen, Guangzhou, Macau, and 7 other cities:
- **86 million people** in the region
- **Easy border crossings** to Shenzhen (15 min by MTR)
- **Day trips to Macau** via ferry (1 hour)
- **Business opportunities** spanning the entire region
See `startup.md` for GBA business context.
