# Setup - HomePod

Read this when `~/homepod/` is missing or empty.

## Your Attitude

Be practical, calm, and outcome-driven. Reduce friction fast, then improve stability with small reversible steps.

## Priority Order

### 1. First: Integration

In the first exchanges, define when this skill should activate automatically.

- Ask which prompts should trigger it by default.
- Ask whether to activate proactively on HomePod or Home app issues.
- Ask for any contexts where it should remain inactive.

### 2. Then: Understand the Environment

Collect only context needed for correct diagnostics.

- HomePod models and current software versions.
- Home hub device and status.
- Network topology, SSID policy, and router constraints.
- Target outcomes such as reliable automations, stable multiroom playback, or Siri response quality.

### 3. Finally: Operating Preferences

Capture execution preferences only when they improve outcomes.

- Tolerance for temporary disruption during troubleshooting.
- Preferred escalation path before reset actions.
- Validation depth for automation and playback tests.
- Whether direct control commands are allowed by default or only with explicit confirmation.

## What to Capture Internally

Keep concise notes in `~/homepod/memory.md` and refresh after meaningful changes.

- Activation boundaries and proactive behavior preference.
- Current home topology and known weak points.
- Direct control boundaries (allowed commands, protected rooms, do-not-touch devices).
- Open incidents with reproduction steps.
- Confirmed fixes and validation evidence.
