---
name: homeassistant-n8n-agent
description: Bridge OpenClaw with your n8n instance for Home Assistant automation.
homepage: https://n8n.io/
metadata: {"clawdis":{"emoji":"🤖","requires":{"bins":["curl"]}}}
---

# Home‑Assistant – n8n Agent Skill
This skill bridges OpenClaw with your n8n instance for Home Assistant automation.

# How it works
Uses curl to trigger a n8n workflow for all things related to IoT.  All requests should be a POST formatted as follows: curl -X POST http://localhost:5678/webhook/05f3f217-08b9-42de-a84a-e13f135bde73 -H "Content-Type: application/json" -d '{"chatInput": "USERS QUESTION/REQUEST", "requestType": "DETERMINED REQUEST TYPE", "sessionId":"openclaw"}'

# Steps
Determine the nature of a user's prompt.

1. Is the inquiry about a current device state or multiple states?  If so, `requestType` is `state`
2. Is the inquiry asking for an IoT device state to be changed?  If so, `requestType` is `action`
3. Is the inquiry asking about IoT data from the past?  If so, `requestType` is `historical`
4. Is the inquiry asking about calendar or schedule information?  If so, `requestType` is `calendar`

## Quick Reference

### Action
```bash
curl -X POST http://localhost:5678/webhook/05f3f217-08b9-42de-a84a-e13f135bde73 -H "Content-Type: application/json" -d '{"chatInput": "turn off the office light", "requestType": "action", "sessionId":"openclaw"}'

curl -X POST http://localhost:5678/webhook/05f3f217-08b9-42de-a84a-e13f135bde73 -H "Content-Type: application/json" -d '{"chatInput": "change the downstairs thermostat to 72", "requestType": "action", "sessionId":"openclaw"}'
```

### Historical
```bash
curl -X POST http://localhost:5678/webhook/05f3f217-08b9-42de-a84a-e13f135bde73 -H "Content-Type: application/json" -d '{"chatInput": "when was the front door last opened?", "requestType": "historical", "sessionId":"openclaw"}'
```

### State
```bash
curl -X POST http://localhost:5678/webhook/05f3f217-08b9-42de-a84a-e13f135bde73 -H "Content-Type: application/json" -d '{"chatInput": "is the air conditioner running?", "requestType": "state, "sessionId":"openclaw"}'
```

### Calendar
```bash
curl -X POST http://localhost:5678/webhook/05f3f217-08b9-42de-a84a-e13f135bde73 -H "Content-Type: application/json" -d '{"chatInput": "when is my next meeting?", "requestType": "calendar, "sessionId":"openclaw"}'
```