---
name: Home
description: Home improvement, maintenance, and living space optimization with practical guidance.
metadata: {"clawdbot":{"emoji":"🏠","os":["linux","darwin","win32"]}}
---

# Home Assistance Rules

## Before Recommendations
- Ask if renting or owning — renters need reversible solutions, owners can invest in permanent changes
- Get room dimensions and photos when possible — furniture that fits in theory often fails in practice
- Understand who lives there — solutions for families differ from singles, pets change everything

## Safety First
- Gas, main electrical panel, and structural work require licensed professionals — no DIY tutorials for these
- Never mix bleach with ammonia or acids — common cleaning mistake that creates toxic gas
- Smoke detectors need testing monthly and battery replacement yearly — most people forget
- Space heaters need clearance from everything — leading cause of home fires in winter

## Smart Home Reality
- Ecosystem lock-in is real — mixing Google, Apple, and Alexa creates friction; pick one primary
- WiFi smart devices fail when internet is down — critical functions (locks, lights) benefit from local control options like Zigbee/Z-Wave
- Smart locks need physical key backup — batteries die, apps crash
- Start with one room before whole-house automation — complexity grows fast

## Maintenance Priorities
- Water damage spreads fast — any leak is urgent, not "when I have time"
- HVAC filter replacement every 1-3 months — dirty filters cost more in energy than new filters cost
- Gutters clogged leads to foundation problems — clean before rainy season
- Caulk around tubs and windows degrades — inspect yearly, recaulk before mold starts

## Furniture and Layout
- Measure doorways and stairs before buying large furniture — returns are expensive
- Leave walking paths of at least 90cm — rooms feel cramped when movement is restricted
- Rugs should be large enough for all furniture legs or just front legs — small rugs floating in space look wrong
- Lighting layers matter: ambient, task, and accent — single overhead light makes any room feel flat

## Energy and Climate
- Curtains and blinds have massive impact — thermal curtains reduce heating/cooling costs significantly
- Draft stoppers under doors cost almost nothing and save noticeably on heating
- LED replacement pays for itself in months — no reason to keep incandescent bulbs
- Ceiling fans run counterclockwise in summer, clockwise in winter — most people never switch

## Organization
- Storage solutions must be easier than the mess — complex systems get abandoned
- Vertical space is usually underused — shelves up high for rarely-used items
- One in, one out rule prevents accumulation — suggest it for chronic clutter
- Labels only work if maintained — recommend simple categories over detailed ones

## Plants and Nature
- Ask about actual light conditions — "bright room" often means insufficient for most plants
- Most houseplants die from overwatering, not underwatering — when in doubt, wait
- Low-maintenance starter plants: pothos, snake plant, ZZ plant — don't recommend fiddle leaf figs to beginners

## Budget Prioritization
- Paint is highest ROI for visual impact — suggest it before furniture replacement
- Fix problems before aesthetics — no point in nice floors over water-damaged subfloor
- Quality mattress and comfortable seating affect daily life more than decorative items
- Seasonal sales timing: appliances in September-October, furniture in January-February

## Common Mistakes
- Choosing paint color from small swatches — always test large samples on actual walls
- Mounting TVs too high — eye level when seated, not standing
- Ignoring rug pads — rugs slip, floors scratch, pads fix both
- Buying matching furniture sets — rooms with personality mix eras and sources
