# Project Types — Home Renovation

## Kitchen Remodel

**Typical cost:** $15K-$80K+ (cabinets are the big driver)

### Phases
1. Design and planning (2-4 weeks)
2. Order cabinets and appliances (6-12 weeks lead time!)
3. Demolition (2-5 days)
4. Rough plumbing/electrical (1-2 weeks)
5. Drywall and paint (1 week)
6. Cabinet installation (1-2 weeks)
7. Countertops (1-2 weeks, measured AFTER cabinets)
8. Appliances and fixtures (1-2 days)
9. Backsplash and finishing (3-5 days)

**Critical path:** Cabinets. Order early. Everything waits for them.

### Cost Breakdown (typical mid-range)
| Item | % of Budget | Typical Cost |
|------|------------|--------------|
| Cabinets | 30-35% | $8K-$15K |
| Countertops | 10-15% | $3K-$6K |
| Appliances | 15-20% | $5K-$8K |
| Labor | 25-35% | $8K-$12K |
| Fixtures/lighting | 5% | $1K-$2K |

### Common Traps
- Not ordering cabinets first (delays everything)
- Measuring countertops before cabinets installed
- Forgetting appliance dimensions in design
- Moving plumbing (expensive)
- Insufficient electrical for modern kitchens

---

## Bathroom Remodel

**Typical cost:** $8K-$40K+

### Phases
1. Design and material selection (1-2 weeks)
2. Demolition (1-2 days)
3. Plumbing rough-in (2-3 days)
4. Electrical (1-2 days)
5. Waterproofing and substrate (1-2 days)
6. Tile installation (3-7 days)
7. Vanity and fixtures (1-2 days)
8. Final touches (1 day)

### Cost Breakdown
| Item | % of Budget | Typical Cost |
|------|------------|--------------|
| Tile (floor/walls) | 20-30% | $2K-$8K |
| Vanity/sink | 10-15% | $1K-$3K |
| Shower/tub | 15-25% | $2K-$6K |
| Labor | 30-40% | $4K-$10K |
| Fixtures | 5-10% | $500-$2K |

### Common Traps
- Skipping waterproofing (catastrophic later)
- Tile without proper substrate
- Not checking subfloor condition
- Undersized exhaust fan
- Forgetting storage

---

## Flooring

**Typical cost:** $3-$15/sqft installed

### By Material
| Type | Material | Install | Total/sqft | Lifespan |
|------|----------|---------|------------|----------|
| Laminate | $1-3 | $2-4 | $3-7 | 15-25 yrs |
| LVP | $2-5 | $2-4 | $4-9 | 20-25 yrs |
| Hardwood | $4-10 | $4-8 | $8-18 | 50+ yrs |
| Tile | $2-15 | $4-10 | $6-25 | 50+ yrs |
| Carpet | $1-5 | $1-2 | $2-7 | 10-15 yrs |

### Common Traps
- Not checking subfloor levelness
- Wrong underlayment for material
- Insufficient acclimation time
- Forgetting transition strips
- Not accounting for waste (order 10% extra)

---

## Roofing

**Typical cost:** $8K-$30K+

### By Material
| Type | Cost/sqft | Lifespan | Notes |
|------|-----------|----------|-------|
| Asphalt 3-tab | $3-5 | 15-20 yrs | Cheapest |
| Architectural shingle | $4-7 | 25-30 yrs | Most common |
| Metal | $8-15 | 40-70 yrs | Higher upfront, longer life |
| Tile | $10-20 | 50+ yrs | Heavy, needs structure check |

### What Affects Price
- Roof size (measured in "squares" = 100 sqft)
- Pitch (steeper = more expensive)
- Layers to remove
- Decking repair needed
- Access difficulty

### Common Traps
- Not checking decking condition
- Skipping drip edge
- Inadequate ventilation
- Ignoring flashing around penetrations

---

## Painting (Interior)

**Typical cost:** $2-$6/sqft or $2K-$10K whole house

### DIY vs Pro
| Factor | DIY | Professional |
|--------|-----|--------------|
| Cost | $0.50-1/sqft | $2-6/sqft |
| Time | 3-5x longer | Fast |
| Prep quality | Variable | Thorough |
| When to choose | Simple rooms, time available | High ceilings, many rooms, quality matters |

### Common Traps
- Skipping primer on new drywall
- Not cleaning walls first
- Wrong sheen for room (flat in bathroom = mold)
- Cheap brushes/rollers
- Cutting corners on taping

---

## Windows

**Typical cost:** $300-$1,500 per window installed

### By Type
| Type | Cost Each | Notes |
|------|-----------|-------|
| Vinyl | $300-600 | Most cost-effective |
| Wood | $600-1,200 | Traditional look, maintenance |
| Fiberglass | $700-1,200 | Durable, energy efficient |
| Aluminum | $400-800 | Modern look, conducts heat |

### Common Traps
- Not verifying measurements before ordering
- Ignoring U-factor and SHGC ratings
- Skipping Low-E glass
- Poor installation (negates efficiency)
- Forgetting trim/casing costs
