# Renovation Phases — Home Renovation

## The Golden Rule

**Wrong order = expensive rework.** Always follow the sequence.

## Standard Phase Order

```
1. Planning & Design
   ↓
2. Permits & Approvals
   ↓
3. Demolition
   ↓
4. Structural Changes
   ↓
5. Rough-In (MEP)
   ├── Electrical
   ├── Plumbing  
   └── HVAC
   ↓
6. Inspection (rough)
   ↓
7. Insulation
   ↓
8. Drywall
   ↓
9. Priming & Texture
   ↓
10. Finish Work
    ├── Cabinets
    ├── Trim/molding
    ├── Doors
    └── Hardware
    ↓
11. Flooring
    ↓
12. Paint
    ↓
13. Fixtures & Appliances
    ↓
14. Final Inspection
    ↓
15. Punch List & Completion
```

## Phase Details

### 1. Planning & Design (Weeks 1-4)
**What happens:**
- Finalize design and layout
- Select materials
- Get quotes from contractors
- Order long-lead items (cabinets: 6-12 weeks!)

**Don't skip:**
- Measuring twice (or three times)
- Checking building codes
- Getting spouse/partner approval on selections

### 2. Permits & Approvals (1-4 weeks)
**What happens:**
- Submit permit applications
- Respond to any questions
- Wait (this is government, patience required)

**Common permits needed:**
- Building permit (structural changes)
- Electrical permit (new circuits, panel work)
- Plumbing permit (new fixtures, moving pipes)
- HVAC permit (new systems, ductwork)
- Sometimes: zoning, historic review

**Skip permits?** Don't. Insurance won't cover. Resale nightmare. Code violations.

### 3. Demolition (Days to 1 week)
**What happens:**
- Remove old materials
- Dispose of debris
- Expose what you're working with

**Watch for:**
- Asbestos (pre-1980 homes)
- Lead paint (pre-1978 homes)
- Hidden water damage
- Unexpected structural issues

**Pro tip:** Demo often reveals surprises. Have contingency ready.

### 4. Structural Changes (1-2 weeks)
**What happens:**
- Move/remove walls
- Add beams/headers
- Foundation work if needed

**Must happen before:** Any finish work
**Inspection required:** Usually yes

### 5. Rough-In MEP (1-3 weeks)
**What happens:**
- Electrical wiring run (not connected)
- Plumbing pipes installed (not fixtures)
- HVAC ductwork (not vents)

**Order:**
1. HVAC (needs most space)
2. Plumbing (less flexible)
3. Electrical (most flexible)

**Inspection required:** Yes, before covering walls

### 6. Rough Inspection
**What happens:**
- Inspector checks MEP work
- Must pass before closing walls
- Schedule early (inspectors are busy)

**If you fail:** Fix issues, reschedule. Don't proceed.

### 7. Insulation (2-5 days)
**What happens:**
- Install insulation in walls/ceiling
- Seal air gaps
- Vapor barrier if required

**Must happen:** After rough inspection, before drywall

### 8. Drywall (1-2 weeks)
**What happens:**
- Hang drywall
- Tape and mud joints (multiple coats, drying time)
- Sand smooth

**Common mistake:** Rushing the mud. Each coat needs to dry.

### 9. Priming & Texture (Days)
**What happens:**
- Prime drywall
- Add texture if desired
- Prep for paint

### 10. Finish Work (1-3 weeks)
**What happens:**
- Install cabinets
- Install trim and molding
- Hang doors
- Install hardware

**Order matters:**
1. Cabinets first (counters measured after)
2. Then trim/molding
3. Then doors

### 11. Flooring (Days to 1 week)
**What happens:**
- Install flooring material
- May need acclimation time first

**Why after cabinets?**
- Flooring under cabinets = wasted money
- Easier to scribe flooring to cabinets
- Exception: Some prefer continuous floor first

### 12. Paint (Days to 1 week)
**What happens:**
- Paint walls and ceilings
- Touch up trim

**Why near end?**
- No traffic damaging fresh paint
- All trim and patches done
- Final look

### 13. Fixtures & Appliances (Days)
**What happens:**
- Install light fixtures
- Install plumbing fixtures (toilets, faucets)
- Connect appliances
- Install outlet/switch covers

**Wait until:** Floors and paint done (less risk of damage)

### 14. Final Inspection
**What happens:**
- Inspector verifies code compliance
- Certificate of occupancy (if applicable)
- Permits closed out

**Must pass:** Before project is truly "done"

### 15. Punch List (Days to 1 week)
**What happens:**
- Walkthrough with contractor
- Note deficiencies (scratches, gaps, touch-ups)
- Contractor fixes items
- Final sign-off

**Hold final payment:** Until punch list complete

## Timeline Traps

| Trap | Impact | Prevention |
|------|--------|------------|
| Ordering cabinets late | Delays everything 6-12 weeks | Order in planning phase |
| Skipping permits | Rework, fines, insurance issues | Always pull permits |
| Rushing drywall mud | Visible seams, cracking | Allow proper dry time |
| Painting before electrical trim | Have to paint again | Follow the sequence |
| Not scheduling inspections early | Idle crews waiting | Schedule 1+ week ahead |
| Making changes mid-project | Delays, cost overruns | Finalize design upfront |

## Parallel vs Sequential

**Can run parallel:**
- Multiple rooms at same phase
- Different trades in different areas
- Material ordering during planning

**Must be sequential:**
- Rough-in before drywall
- Drywall before paint
- Cabinets before countertops
- Everything before final inspection
