# Contractor Evaluation — Home Renovation

## Before Hiring: Questions to Ask

### Licensing & Insurance
1. "Are you licensed in [state/city]?" — Verify online, don't just trust the answer
2. "Can I see your insurance certificate?" — Should have liability AND workers comp
3. "Who pulls the permits?" — Ideally them, not you

### Experience
4. "How long have you been doing this specific type of work?"
5. "Can you provide 3 references from similar projects in the last year?"
6. "Can I see photos of similar completed projects?"

### Process
7. "Who will be on-site daily? You or a foreman?"
8. "How do you handle communication and updates?"
9. "What's your change order process?"
10. "What warranty do you offer on your work?"

### Money
11. "What's your payment schedule?" — Red flag if >30% upfront
12. "Is this quote fixed or can it change?"
13. "What's included and what's extra?"
14. "How do you handle unexpected issues?"

## Quote Comparison Checklist

When you have multiple quotes, verify each includes:

| Item | Quote A | Quote B | Quote C |
|------|---------|---------|---------|
| Materials (brand/grade) | | | |
| Labor (hours/rate) | | | |
| Permits | | | |
| Dumpster/disposal | | | |
| Cleanup | | | |
| Timeline | | | |
| Warranty | | | |
| Payment terms | | | |

**Cheapest isn't best.** Middle quote often safest. Lowest quote = corners cut or change orders coming.

## Red Flags

**Run away if:**
- No license or won't show it
- No insurance or expired
- Demands >30% deposit
- Cash only, no contract
- Can start tomorrow (why are they free?)
- Pressure tactics ("price only good today")
- Bad reviews mentioning same issues repeatedly
- Won't provide references
- Won't pull permits ("saves you money")

**Yellow flags (proceed with caution):**
- Very new business (<2 years)
- Only has online reviews, no direct references
- Quote is significantly lower than others
- Vague about timeline
- Subcontracts everything

## Contract Must-Haves

Before signing, verify the contract includes:

- [ ] Full legal names and addresses (both parties)
- [ ] License and insurance numbers
- [ ] Detailed scope of work
- [ ] Specific materials (brand, model, color)
- [ ] Start and completion dates
- [ ] Payment schedule tied to milestones
- [ ] Change order process and pricing
- [ ] Warranty terms
- [ ] Who pulls permits
- [ ] Dispute resolution process
- [ ] Cancellation terms

## Payment Schedule (Recommended)

| Milestone | Payment | Running Total |
|-----------|---------|---------------|
| Contract signed | 10-20% | 10-20% |
| Materials delivered | 20-30% | 30-50% |
| Rough-in complete | 20-25% | 50-75% |
| Substantial completion | 20-25% | 70-100% |
| Punch list complete | 0-10% | 100% |

**Golden rule:** Never get ahead of the work. If 50% is done, never have paid more than 50%.

**Final payment:** Hold 5-10% until punch list complete and you're satisfied.

## Communication Best Practices

### During Project
- Weekly check-in (in person or call)
- Document everything in writing (text/email OK)
- Take photos before, during, after
- Address issues immediately, not later

### When Issues Arise
1. Discuss in person first
2. Follow up in writing: "To confirm our conversation..."
3. Give reasonable time to fix
4. Document if not resolved
5. Consult contract for dispute process

### Change Orders
Every change should be:
- In writing
- Priced before approval
- Signed by both parties
- Added to timeline

Never approve verbal changes. "They said it wouldn't cost extra" isn't enforceable.

## After Completion

- [ ] Final walkthrough with contractor
- [ ] Create punch list (in writing)
- [ ] Get lien waivers from subs
- [ ] Verify permits closed/inspected
- [ ] Get all warranties in writing
- [ ] Leave honest review
- [ ] Keep contractor info for future
