# Listing Scorecard

Use one weighted rubric so decisions are comparable.

## Scoring Model

`final_score = sum(weight_i * score_i)` where each score is 1 to 5.

| Category | Weight | What to score |
|----------|--------|---------------|
| Location fit | 0.25 | Commute, safety, services, long-term demand |
| Total affordability | 0.25 | All-in monthly and cash-to-close fit |
| Property condition risk | 0.20 | Age, major systems, visible maintenance signals |
| Resale resilience | 0.15 | Neighborhood liquidity and buyer demand |
| Lifestyle fit | 0.15 | Layout, must-haves, non-negotiables |

## Decision Thresholds

| Score | Meaning | Action |
|------:|---------|--------|
| >= 4.2 | Strong candidate | Advance to offer planning |
| 3.6 to 4.1 | Viable with caveats | Advance only with risk notes |
| < 3.6 | Weak candidate | Hold or reject |

## Tie-Breaker Rules

If two listings score within 0.2 points:
1. Choose lower all-in monthly cost.
2. Choose lower near-term capital expense risk.
3. Choose higher resale resilience.

## Exception Logging

If a low-scoring listing moves forward, record:
- Why exception was approved
- Which risk is being accepted
- What mitigation is in place
