# Due Diligence

Convert inspections and disclosures into explicit risk decisions.

## Issue Severity Bands

| Severity | Definition | Default action |
|----------|------------|----------------|
| High | Safety, structural, major system failure | Seller fix, major credit, or walk-away |
| Medium | Material cost or livability impact | Negotiate credit or scoped repair |
| Low | Cosmetic or low-cost maintenance | Accept and track post-close |

## Risk Transfer Matrix

For each issue, assign exactly one path:
- Seller repairs before closing
- Seller credit at closing
- Price reduction
- Buyer accepts risk with explicit budget reserve

If no path is selected, issue is unresolved.

## Documentation Discipline

Track for each issue:
- Evidence source (inspection, specialist quote, disclosure)
- Cost range (best, expected, worst)
- Deadline and responsible party
- Decision owner and sign-off date

## Contingency Deadline Control

- Keep a visible timeline for inspection, appraisal, loan, and title contingencies.
- Trigger escalation 48 hours before each deadline if unresolved high or medium issues remain.

## Walk-Away Triggers

Recommend walking away when:
- High-severity issue lacks feasible transfer path
- Aggregate repair exposure breaks budget guardrails
- Seller response pattern signals high execution risk
