# Closing Readiness

Use this gate before removing final protections.

## Readiness Checklist

| Area | Required proof |
|------|----------------|
| Financing | Final loan approval and clear cash-to-close figure |
| Appraisal | Value supports financing strategy |
| Title | Title commitment reviewed and exceptions understood |
| Insurance | Binder active with acceptable premium |
| Property condition | Final walkthrough confirms agreed condition |
| Credits and repairs | Settlement statement reflects negotiated terms |

## Red Flags

- Cash-to-close changed materially without explanation
- New title exception with unresolved risk
- Insurance premium shock that breaks affordability
- Repairs marked complete without verification

## Final Gate Decision

Only mark `ready_to_close = yes` when:
- No unresolved high-severity issue remains
- Financing and insurance are fully confirmed
- Settlement numbers match approved terms

If any condition fails, hold closing and issue a remediation plan.

## Post-Close Retrospective

After close, record:
- What protected downside effectively
- Which assumptions were wrong
- Which negotiation patterns should be reused
