# Budget Guardrails

Use this sheet before browsing listings or writing offers.

## All-In Monthly Cost Formula

Use one formula consistently:

`all_in_monthly = principal_interest + property_tax + insurance + HOA + utilities_estimate + maintenance_reserve`

Recommended default for maintenance reserve:
- 1.0% of purchase price per year for newer homes
- 1.5% to 2.0% for older homes or deferred maintenance risk

## Cash-to-Close Formula

`cash_to_close = down_payment + closing_costs + prepaid_items + immediate_repairs - seller_credits`

Quick planning range:
- Closing costs: 2% to 5% of purchase price
- Prepaids and reserves: market-specific and lender-specific

## Guardrail Bands

| Band | Rule | Action |
|------|------|--------|
| Green | <= target monthly | Proceed with standard diligence |
| Yellow | 1% to 8% above target | Proceed only with documented trade-off |
| Red | >8% above target | Reject unless user explicitly raises budget |

## Rate Sensitivity Check

Run at least three scenarios:
- Base case rate
- Base +0.50%
- Base +1.00%

If a property becomes unaffordable under +0.50%, mark financing risk as high.

## Non-Negotiable Buffers

Keep post-close liquidity buffer after cash-to-close.
Default suggestion: 3 to 6 months of essential expenses.

If buffer falls below minimum threshold, pause offer strategy and re-scope search.
