# 港股打新机制详解

## 公开发售 vs 国际配售

港股 IPO 的股份分为两部分：

- **公开发售（Public Offer）**：面向散户，通常占发行总量的 **10%**
- **国际配售（International Placing）**：面向机构投资者，通常占 **90%**

散户通过券商认购公开发售部分；机构通过簿记建档参与国际配售。

---

## 回拨机制（Clawback）

当公开发售超额认购达到一定倍数时，会从国际配售中"回拨"股份给公开发售，增加散户可认购数量。

### 传统规则（2025年8月前）

| 超额认购倍数 | 公开发售占比 |
|---|---|
| < 15x | 不回拨，维持 10% |
| 15–50x | 回拨至 **30%** |
| 50–100x | 回拨至 **40%** |
| ≥ 100x | 回拨至 **50%** |

### 2025年8月新规

港交所推出两种新机制供发行人选择：

- **机制 A**：保留回拨，但最高只回拨至 **35%**（降低了传统规则的上限）
- **机制 B**：**无回拨**，发行人在招股时预先设定公开发售比例

> 新规下需要关注招股书中选择的机制类型，直接影响散户可获分配的股数。

---

## 甲组 / 乙组

公开发售进一步分为两组，**各占公开发售的 50%**：

| 组别 | 认购金额 | 特点 |
|---|---|---|
| **甲组** | ≤ 500万港元 | 散户主力，人数多 |
| **乙组** | > 500万港元 | 大额认购，人数少 |

### 红鞋机制（甲组优先分配）

"红鞋"是港股打新圈的俗称，指**甲组"一人一手"优先分配**原则：

- 甲组分配时**优先保证尽可能多的人至少中 1 手**
- 剩余股份再按比例分配或抽签
- 来源：早年用红色纸张记录认购，俗称"红鞋"

**红鞋对散户的意义**：
- 小资金申购 1 手的中签率往往最高
- 申购多手不一定按比例增加中签概率
- 超购倍数极高时，1 手也可能变成纯抽签
- **对小散户友好** — 不需要大资金也有机会中签

### 甲组 vs 乙组怎么选？

| 情况 | 建议 |
|------|------|
| 资金 < 500万 | 只能打甲组 |
| 资金 > 500万 | 可选甲或乙，乙组竞争人数少但起步金额高 |
| 热门股、超购高 | 甲组 1 手就够，红鞋保护 |
| 冷门股、超购低 | 甲组多手或乙组，提高绝对中签数量 |

---

## 中签率

**中签率无法精确预测**，只能估算。影响因素包括：

1. **超购倍数**：越高，中签率越低
2. **申购账户数**：甲组人数越多，竞争越激烈
3. **甲乙组分配**：各占 50%，但人数差距巨大
4. **回拨比例**：回拨越多，散户可分配股数越多
5. **每手股数和入场费**：影响参与人数

### 估算方法

- 参考历史上超购倍数相近的 IPO 的实际中签率
- 关注券商公布的认购人数（部分券商会披露）
- 甲组 1 手中签率通常高于多手的边际中签率

---

## 其他重要概念

### 绿鞋机制（超额配售权）

- 承销商可在 IPO 后 30 天内额外发行不超过原发行量 **15%** 的股份
- 作用：稳定上市后股价
- 有绿鞋 = 承销商有动力在破发时买入托价
- **有绿鞋通常是正面信号**

### 基石投资者（Cornerstone Investors）

- 在 IPO 定价前承诺认购一定金额的机构或个人
- 通常有 **6 个月锁定期**，期间不得卖出
- 基石投资者的数量和质量反映市场对该 IPO 的信心
- 知名基石（高瓴、红杉、淡马锡等）= 强背书

### 暗盘交易

- **上市前一天下午 16:15–18:30** 在部分券商平台进行的场外交易
- 可以提前卖出或买入，锁定收益或抄底
- 暗盘价格对次日开盘有一定参考意义
- 流动性有限，价格波动可能较大

**暗盘卖出策略**：

| 情况 | 建议 |
|------|------|
| 暗盘涨幅达预期（如 +15%+） | 考虑暗盘卖出，落袋为安 |
| 热门股但涨幅一般 | 可持有观望首日 |
| 暗盘破发 | 视情况止损或持有博反弹 |
| 担心次日大幅回落 | 暗盘先出一部分 |
| 长期看好 | 可不参与暗盘，等首日或更长 |

**注意**：暗盘流动性有限，大单可能成交困难或滑点大。

---

## 入场费计算

**入场费 = 认购 1 手所需的总资金**

### 计算公式

```
入场费 = 每手股数 × 招股价上限 × (1 + 费率)
```

费率通常约 **1.0077%**，包括：
- 经纪佣金：约 0.25%（各券商不同）
- 交易征费：0.0027%
- 交投征费：0.005%
- 印花税：0.1%（取整至最近 1 元）
- 股票结算费：0.002%

### 示例

- 每手 500 股，招股价上限 14 港元
- 入场费 ≈ 500 × 14 × 1.01 ≈ **7,070 港元**

### 实际中

CLI 返回的 `entry_fee` 已经是计算好的值，直接使用即可。
