# 打新分析要点指引

## 财务数据怎么看

**财务数据是判断公司质量的核心**，CLI 数据不含财务，需要 web search 补充。

### 关键指标

| 指标 | 看什么 | 好的信号 | 警惕信号 |
|------|--------|----------|----------|
| **营收** | 近3年趋势 | 持续增长、年复合增长率>15% | 停滞或下滑 |
| **净利润** | 盈利能力 | 稳定盈利、增长中 | 亏损或下滑 |
| **毛利率** | 业务质量 | 高于行业平均、稳定 | 持续走低 |
| **最新季度** | 近期状况 | 同比增长 | 同比大幅下滑 |

### 怎么分析

1. **看趋势不看绝对值** — 增长 10% 比绝对数字更重要
2. **对比同行** — 毛利率 20% 在不同行业含义不同
3. **关注最新季度** — 比历史年度更能反映当前状态
4. **警惕增收不增利** — 营收涨但利润不涨，可能有问题

### 数据来源

- 招股书财务摘要
- 财经网站报道（雪球、同花顺、东方财富）
- 公众号分析文章

---

## 发行机制（A/B）怎么看

2025年8月新规后，发行人可选择机制 A 或机制 B：

| 机制 | 公开发售初始比例 | 最大回拨 | 特点 |
|------|------------------|----------|------|
| **机制 A** | 5% | 最高 35% | 散户份额少，但热门股可回拨 |
| **机制 B** | 10% | 最高 35% | 散户基础份额多 |

### 对散户的影响

- **机制 B** 对散户更友好（初始 10%）
- **热门股选 A** → 散户中签率可能更低
- **冷门股选 B** → 注意可能有认购不足风险

---

## 保荐人怎么看

保荐人（Sponsor）的质量直接影响 IPO 项目的可信度和定价合理性。

### 分级参考

| 级别 | 代表机构 | 说明 |
|---|---|---|
| **头部** | 高盛、摩根士丹利、中金（CICC）、中信证券 | 项目筛选严格，质量通常较高 |
| **中上** | 华泰、招商证券、德意志银行 | 有不错的项目，但需具体看 |
| **一般** | 小型券商 | 项目质量参差不齐，需更谨慎 |

### 怎么判断

- 查该保荐人近 1-2 年保荐的 IPO 首日表现
- 头部保荐人破发率通常更低
- 联合保荐人多 = 项目受关注度高

---

## 基石投资者怎么看

### 数量

- **10 家以上**算多，说明认购踊跃
- **3-5 家**正常
- **0-1 家**需警惕（市场兴趣不足？）

### 质量

知名机构参与是强信号：
- 高瓴资本、红杉中国、淡马锡（Temasek）、GIC
- 互联网巨头战略投资部门（腾讯、阿里）
- 主权基金

### 锁定期

- 通常 **6 个月**
- 锁定期越长，说明基石对公司长期看好

### 占比

- 基石认购占国际配售的比例
- **占比高（>50%）**= 机构信心足，但也意味着上市后流通盘小
- **占比过低（<20%）**= 可能机构兴趣一般

---

## A+H 折价怎么看

对于已有 A 股上市的公司来港上市（A+H），折价是重要安全垫。

### 计算方式

```
折价率 = (A股价格 - H股发行价) / A股价格 × 100%
```

### 判断标准

| 折价率 | 含义 |
|---|---|
| > 30% | 安全垫充足，有吸引力 |
| 15-30% | 有一定空间 |
| < 15% | 安全垫薄，需谨慎 |

### 注意事项

- 要看 A 股**近期走势**：如果 A 股正在下跌，折价可能是假象
- 折价会随 A 股波动变化，以**截止认购日**的数据为准
- 部分行业 A/H 长期存在折价（如银行股），不能简单类比

---

## 行业判断

**不要用简单的关键词匹配判断行业好坏。**

正确做法：
1. 参考当前市场热点和政策方向
2. 用 web search 查询最新市场情绪和行业新闻
3. 看同行业近期 IPO 表现
4. 关注政策利好/利空（如新能源补贴、医药集采）

### 近期热门 vs 冷门（需实时更新）

- 热门赛道在不同时期变化很大，**必须联网查询**
- 不要硬编码"AI 热门""医药冷门"这种判断

---

## 集资用途怎么看

招股书中的"募集资金用途"反映公司未来规划：

| 用途 | 信号 |
|---|---|
| 研发投入 | ✅ 正面 — 有增长野心 |
| 产能扩张 | ✅ 正面 — 业务在增长 |
| 营运资金 | ⚪ 中性 — 正常需求 |
| 战略并购 | ⚪ 中性 — 取决于具体方向 |
| **偿还债务** | ⚠️ 负面（尤其大比例） — 说明公司缺钱还债 |

### 红旗信号

- 超过 30% 用于还债 → 财务状况可能有压力
- 用途描述模糊 → 管理层可能没有清晰规划

---

## 入场费考量

入场费 = 1 手所需的资金（每手股数 × 上限价格 + 手续费）

| 入场费 | 特点 |
|---|---|
| < 3000 港元 | 门槛低，申购人数多，竞争激烈，中签率可能低 |
| 3000-7000 港元 | 中等，较平衡 |
| > 7000 港元 | 门槛高，申购人少，中签率可能高，但占用资金多 |

### 分析要点

- 入场费低 → 适合小资金散户，但中签后收益金额也小
- 入场费高 → 资金利用率低，需要考虑机会成本
- 结合超购倍数一起看：低入场费 + 高超购 = 中签难但可能涨幅好
