# Physical Task Delegation

When your AI agent hires humans for tasks that require physical presence.

## Common Physical Tasks

| Category | Examples |
|----------|----------|
| **Retrieval** | PO Box mail, package pickup, document collection |
| **Documentation** | Property photos, storefront inspection, inventory audit |
| **Verification** | Product condition check, business existence, address confirm |
| **Delivery** | Document drop-off, notarized papers, physical samples |
| **Attendance** | Event proxy, meetup networking, conference presence |
| **Services** | Notary, witness signature, queue holding |

## Verification Requirements

Always require proof of task completion:

| Proof Type | When to Use |
|------------|-------------|
| **Timestamped photo** | Most tasks — shows what, when |
| **GPS-tagged photo** | Location-critical tasks |
| **Video walkthrough** | Property inspection, complex tasks |
| **Signed receipt** | Deliveries, document handoffs |
| **Live video call** | High-value verification, real-time guidance |

## Platform Integration

**RentAHuman.ai** — Purpose-built for AI agents dispatching humans
- Native API for agents
- Structured task templates
- Built-in verification
- Escrow payment

**TaskRabbit** — Consumer platform, some API access
- Good for home services, errands
- Reviews and vetting
- Limited programmatic control

**Direct contractors** — For recurring needs
- Build a trusted roster
- Lower per-task overhead
- Higher setup investment

## Task Brief Template

```
TASK: [Clear one-line description]
LOCATION: [Full address]
DEADLINE: [Date/time with timezone]
DURATION: [Estimated time needed]

STEPS:
1. [First action]
2. [Second action]
3. [Third action]

PROOF REQUIRED:
- [ ] Photo of [specific thing]
- [ ] GPS verification at location
- [ ] Confirmation message with [detail]

BUDGET: $[amount]
CONTACT: [How to reach you if questions]
```

## Cost Management

- **Set maximum budget** agent can approve without human confirmation
- **Compare platforms** — TaskRabbit vs RentAHuman vs local options
- **Batch nearby tasks** — One trip for multiple errands
- **Tip appropriately** — Good taskers remember good clients

## Safety & Trust

- **Use platforms with insurance** for valuable items
- **Don't share sensitive info** beyond what's needed
- **Start with small tasks** before high-stakes work
- **Check reviews** and completed task history
- **Have backup contacts** for urgent/time-sensitive tasks

## Emergency Response

For urgent physical issues (server room problem, property emergency):
1. Pre-identify trusted local contacts
2. Have a "break glass" budget for emergencies
3. Agent should be authorized to dispatch immediately
4. Require live updates during resolution
5. Document everything for insurance/follow-up
