# Legal & Compliance Checklist

## Worker Classification (Critical)

**Misclassifying employees as contractors triggers:**
- Back taxes + penalties
- Back wages and benefits
- Potential lawsuits

**Factors indicating employee (not contractor):**
- You control how/when work is done
- They work exclusively for you
- You provide equipment/workspace
- Ongoing relationship without defined end
- You set their schedule

**Factors indicating contractor:**
- They control methods and schedule
- They work for multiple clients
- They provide own equipment
- Project-based with defined deliverables
- They can profit/loss from the work

**High-risk jurisdictions:**
- California (AB5 — ABC test applies)
- New York, New Jersey, Massachusetts
- EU countries (strong worker protections)

**When in doubt:** Consult employment lawyer before engaging

## Required Documents

### Before Work Begins
| Document | US Domestic | International |
|----------|-------------|---------------|
| Tax form | W-9 | W-8BEN |
| Service agreement | ✅ | ✅ |
| NDA (if needed) | ✅ | ✅ |
| IP assignment | ✅ | ✅ |

### Service Agreement Must Include
- Scope of work (specific deliverables)
- Payment terms (amount, milestones, method)
- Timeline and deadlines
- IP ownership clause
- Confidentiality terms
- Termination conditions
- Governing law and jurisdiction
- Independent contractor acknowledgment

## IP Assignment

**Essential language:**
- "All work product is work-for-hire"
- "Contractor assigns all rights to Client"
- "Contractor waives moral rights" (where applicable)
- Carve-out for pre-existing IP (if any)

**Without proper IP assignment:**
- Contractor may retain copyright
- You may have only a license
- They could resell/reuse the work

## Tax Compliance

### US Domestic Contractors
- Collect W-9 before first payment
- Issue 1099-NEC if payments ≥ $600/year
- File 1099s by January 31

### International Contractors
- Collect W-8BEN before first payment
- Generally no 1099 required
- Be aware of tax treaty implications
- Consider VAT/GST if applicable

## Payment Best Practices

- **Never 100% upfront** — milestone-based or upon delivery
- **Document everything** — invoices, receipts, scope changes
- **Written approval** for scope changes that affect price
- **Dispute process** — specify how conflicts are resolved

## Confidentiality & NDAs

**When to require NDA:**
- Access to proprietary information
- Working on unreleased products
- Access to customer data
- Competitive industry

**NDA should cover:**
- Definition of confidential information
- Permitted uses
- Duration of obligation (typically 2-5 years)
- Exclusions (public info, prior knowledge)
- Return/destruction of materials

## Data & Privacy

- Limit PII shared to minimum necessary
- Include data handling terms in agreement
- GDPR applies if contractor accesses EU resident data
- CCPA applies if handling California resident data

## Record Retention

Keep for at least 7 years:
- Contracts and amendments
- Payment records and invoices
- Tax documents (W-9, W-8BEN, 1099s)
- Correspondence about scope/changes

## When to Escalate to Human Review

- Worker classification is ambiguous
- Contract value exceeds threshold (e.g., $25k+)
- International contractor in unfamiliar jurisdiction
- Dispute arises that platform can't resolve
- Any request for unusual terms
