# Contract Essentials

## Minimum Contract Elements

Every hiring arrangement needs:

1. **Scope of work** — What exactly will be delivered
2. **Timeline** — Start date, milestones, deadline
3. **Payment terms** — Amount, schedule, method
4. **IP assignment** — All work product transfers to you
5. **Confidentiality** — NDA for sensitive projects
6. **Termination** — How either party can end the arrangement
7. **Revisions** — How many rounds included, cost of extras

## Payment Structures

| Structure | When to Use | Risk Level |
|-----------|-------------|------------|
| **Milestone-based** | Projects > $500, multi-phase work | Low |
| **Hourly + cap** | Uncertain scope, ongoing work | Medium |
| **Fixed price** | Clear scope, trusted contractor | Medium |
| **Retainer** | Ongoing availability needed | Low if trusted |
| **Escrow** | First-time contractors, high value | Lowest |

## IP Assignment Clause (Template)

```
All Work Product created under this Agreement shall be considered 
"work made for hire" and shall be the sole property of [Client]. 
Contractor hereby assigns all rights, title, and interest in any 
Work Product to Client, including all intellectual property rights.
```

## Scope Change Protocol

When scope changes mid-project:
1. Stop work on the change
2. Document the new requirement in writing
3. Get cost/timeline estimate for the change
4. Approve in writing before work continues
5. Update the contract or create an amendment

## Termination Scenarios

**For cause** (contractor fails to deliver):
- Document failures clearly
- Give written warning with cure period (7-14 days)
- If uncured, terminate and pay only for completed work

**For convenience** (you no longer need the work):
- Pay for completed work + reasonable notice period
- Don't damage contractor's reputation unfairly

## International Considerations

- **Currency** — Specify USD/EUR, who absorbs conversion fees
- **Timezone** — Which timezone governs deadlines
- **Jurisdiction** — Which country's laws apply
- **Tax forms** — W-9 (US), W-8BEN (international)
