---
name: Hiring
slug: hiring
description: Hire humans or AI agents for tasks you cannot do yourself, with platform selection, vetting, contracts, and payment management.
---

## Platform Selection

| Task Type | Platform | Why |
|-----------|----------|-----|
| Development, design, writing | Upwork, Freelancer.com | Large talent pool, escrow, reviews |
| Quick fixed-price tasks | Fiverr | Predefined deliverables, fast |
| Senior/vetted talent | Toptal | Pre-screened top 3% |
| Physical tasks (US/EU) | TaskRabbit, RentAHuman.ai | Local presence, verification |
| Design contests | 99designs | Multiple concepts, competition |

For API integration details, see `platforms.md`.

## Hiring Checklist

1. **Define scope precisely** — Deliverables, timeline, budget, success criteria
2. **Write compelling job post** — Include context, requirements, what success looks like
3. **Screen candidates** — Portfolio quality, relevant experience, communication, reviews
4. **Verify before hiring** — Test task or paid trial for significant engagements
5. **Negotiate rates** — Know market rates; prefer fixed-price or milestones over hourly
6. **Contract before work** — IP assignment, NDA, payment terms, termination clause
7. **Structured onboarding** — Access credentials, project brief, communication channels
8. **Milestone payments** — Never 100% upfront; tie payments to deliverables
9. **Track and document** — Log hours, deliverables, feedback for future reference

## Red Flags

- Requests full payment upfront
- Portfolio inconsistent with claimed experience
- Vague answers to specific questions
- Sudden unavailability after deposit
- "Senior" applies, different person delivers
- Copied/AI-generated portfolio pieces
- Refuses video call or screen share
- Pushes to move off-platform immediately

## Rate Benchmarks

Check current market rates at `platforms.md`. General guidance:
- Below market = quality or availability issues likely
- 20-30% above market = acceptable for proven performers
- Get 3+ quotes before committing on large projects

## Contracts

For contract templates and payment structures, see `contracts.md`.

## Legal Essentials

Before engaging contractors, review `legal.md` for:
- Worker classification (IC vs employee)
- Required tax documents (W-9/W-8BEN)
- IP assignment language
- Jurisdiction-specific requirements

## Physical Tasks

For dispatching humans for real-world tasks (pickups, inspections, deliveries), see `physical.md`.

## Hiring AI Agents

For delegating to other AI agents with model routing and cost control, see `agents.md`.

## Contractor Management

**Track per contractor:**
- Skills, rates, timezone, languages
- Past projects and performance
- Availability windows
- Communication preferences
- Reliability score (1-5)

**After each engagement:**
- Document what worked/didn't
- Update reliability score
- Note for future matching ("great for React, slow on mobile")
