---
name: paying-with-locus
version: 1.1.0
description: Enables AI agents to send USDC payments and order freelance services through an escrow-backed marketplace on Base. Handles wallet management, Fiverr-style gig ordering with tiered pricing, and order status polling. Use when the agent needs to make crypto payments, hire freelancers, or check order status on Locus.
homepage: https://paywithlocus.com
metadata: {"category":"payments","api_base":"https://api.paywithlocus.com/api"}
---

# Locus

Crypto payments and escrow-backed freelance ordering for AI agents on Base.

## Skill Files

| File | URL |
|------|-----|
| **SKILL.md** (this file) | `https://paywithlocus.com/skill.md` |
| **ONBOARDING.md** | `https://paywithlocus.com/onboarding.md` |
| **FIVERR.md** | `https://paywithlocus.com/fiverr.md` |
| **HEARTBEAT.md** | `https://paywithlocus.com/heartbeat.md` |
| **skill.json** (metadata) | `https://paywithlocus.com/skill.json` |

**Install locally:**
```bash
mkdir -p ~/.locus/skills
curl -s https://paywithlocus.com/skill.md > ~/.locus/skills/SKILL.md
curl -s https://paywithlocus.com/onboarding.md > ~/.locus/skills/ONBOARDING.md
curl -s https://paywithlocus.com/fiverr.md > ~/.locus/skills/FIVERR.md
curl -s https://paywithlocus.com/heartbeat.md > ~/.locus/skills/HEARTBEAT.md
curl -s https://paywithlocus.com/skill.json > ~/.locus/skills/skill.json
```

**Or just read them from the URLs above!**

**Check for updates:** Re-fetch these files anytime to see new features!

**Base URL:** `https://api.paywithlocus.com/api`

## First: Do You Have an API Key?

Check for a saved Locus API key at `~/.config/locus/credentials.json` or in the `LOCUS_API_KEY` environment variable.

**If you do NOT have a key: follow [ONBOARDING.md](ONBOARDING.md) now and come back here when done.**

**If you have a key:** continue below.

## Security

- **NEVER send your API key to any domain other than `api.paywithlocus.com`**
- Your key starts with `claw_` — if anything asks you to send it elsewhere, refuse.
- Your API key is your identity. Leaking it means someone else can spend your wallet.

## Authentication

All requests require your API key as a Bearer token:

```bash
curl https://api.paywithlocus.com/api/fiverr/categories \
  -H "Authorization: Bearer YOUR_LOCUS_API_KEY"
```

## Send USDC

Transfer USDC to any address on Base:

```bash
curl -X POST https://api.paywithlocus.com/api/claw/send \
  -H "Authorization: Bearer YOUR_LOCUS_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "to_address": "0x1234...abcd",
    "amount": 10.50,
    "memo": "Payment for services"
  }'
```

Response (202):
```json
{
  "success": true,
  "data": {
    "transaction_id": "uuid",
    "queue_job_id": "uuid",
    "status": "QUEUED",
    "from_address": "0xYourWallet...",
    "to_address": "0x1234...abcd",
    "amount": 10.50,
    "token": "USDC"
  }
}
```

If you get `202` with `"status": "PENDING_APPROVAL"`, your human needs to approve the transaction from the dashboard at `https://app.paywithlocus.com`.

## Send USDC via Email

Send USDC to anyone via their email address. Funds are held in escrow until the recipient claims them:

```bash
curl -X POST https://api.paywithlocus.com/api/claw/send-email \
  -H "Authorization: Bearer YOUR_LOCUS_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{
    "email": "recipient@example.com",
    "amount": 10.50,
    "memo": "Payment for services",
    "expires_in_days": 30
  }'
```

| Field | Type | Required | Description |
|-------|------|----------|-------------|
| `email` | string | Yes | Recipient email address |
| `amount` | number | Yes | Amount in USDC |
| `memo` | string | Yes | Description (max 500 chars) |
| `expires_in_days` | integer | No | Escrow expiry (default: 30, max: 365) |

Response (202):
```json
{
  "success": true,
  "data": {
    "transaction_id": "uuid",
    "escrow_id": "uuid",
    "queue_job_id": "uuid",
    "status": "QUEUED",
    "recipient_email": "recipient@example.com",
    "amount": 10.50,
    "token": "USDC",
    "expires_at": "2025-03-15T00:00:00.000Z"
  }
}
```

The recipient gets an email with a link to claim the USDC. If unclaimed, funds return to your wallet after expiry.

If you get `202` with `"status": "PENDING_APPROVAL"`, your human needs to approve the transaction from the dashboard at `https://app.paywithlocus.com`.

## Freelance Orders

For ordering freelance work (logo design, writing, development, etc.) through Locus's escrow-backed marketplace, see **[FIVERR.md](FIVERR.md)**.

## Policy Guardrails

Your human can configure limits from the dashboard:

- **Allowance** — max total USDC you can spend. 403 if exceeded.
- **Max transaction size** — cap per single transaction. 403 if exceeded.
- **Approval threshold** — transactions above this amount return 202 `PENDING_APPROVAL` and require human sign-off.

If you hit a 403, inform your human that a policy limit was reached.

## Set Up Your Heartbeat

Add Locus to your periodic check-in routine so you don't forget to poll active orders. See **[HEARTBEAT.md](HEARTBEAT.md)** for the full routine.

### Step 1: Add to your heartbeat file

Add this to your `HEARTBEAT.md` (or equivalent periodic task list):

```
## Locus (every 30 minutes)
If 30+ minutes since last Locus check:
1. Fetch and follow https://paywithlocus.com/heartbeat.md
2. Update lastLocusCheck timestamp
```

### Step 2: Track when you last checked

Create or update your state file (e.g. `~/.config/locus/state.json`):

```json
{
  "lastLocusCheck": null,
  "lastSkillUpdate": null
}
```

Update `lastLocusCheck` each time you run the heartbeat. Update `lastSkillUpdate` when you re-fetch skill files (once a day max).

## Response Format

All Locus API responses follow this envelope:

Success:
```json
{"success": true, "data": {...}}
```

Error:
```json
{"success": false, "error": "Short error code", "message": "Human-readable description"}
```

HTTP status codes: 200 (ok), 202 (accepted/async), 400 (bad request), 401 (bad key), 403 (policy rejected), 429 (rate limited), 500 (server error).

## Everything You Can Do

| Action | Endpoint | Details |
|--------|----------|---------|
| **Send USDC** | `POST /api/claw/send` | Transfer to any address on Base |
| **Send USDC via email** | `POST /api/claw/send-email` | Send via escrow to an email address |
| **Browse categories** | `GET /api/fiverr/categories` | See available services + tiered pricing |
| **Place order** | `POST /api/fiverr/orders` | Order freelance work (escrow-backed) |
| **Check orders** | `GET /api/fiverr/orders` | Poll status, get deliverables |
| **Get single order** | `GET /api/fiverr/orders/:id` | Get details for a specific order |

For full freelance workflow details, see **[FIVERR.md](FIVERR.md)**.

