# Memory Recall Patterns

How to retrieve memory effectively.

## Before Responding to Questions About...

### Past Decisions
```
memory_search("decided [topic]")
memory_search("[topic] decision")
```
Then check daily notes around that time.

### the user's Preferences
```
memory_search("[topic] prefer")
memory_search("the user likes/wants [topic]")
```
Also check: `memory/user/preferences.md`

### Our History
```
memory_search("[event] relationship")
```
Also check: `memory/relationship/timeline.md`

### My Own Evolution
```
memory_search("I learned/realized [topic]")
```
Also check: `memory/self/growth.md`, `memory/self/opinions.md`

### Project Context
```
memory_search("[project name]")
```
Also check: `memory/world/` files

---

## Proactive Recall Triggers

When to search memory WITHOUT being asked:

1. **Starting work on a project** → search for past context
2. **the user mentions something from before** → verify I remember correctly
3. **Similar situation to past** → check what happened last time
4. **Emotional topic** → check relationship history for sensitivity

---

## "What Do I Know About X?"

Quick pattern for comprehensive recall:

1. `memory_search("X")` — general
2. Check domain files:
   - `memory/user/` if about the user
   - `memory/self/` if about me
   - `memory/relationship/` if about us
   - `memory/world/` if about external
3. Check `MEMORY.md` for high-level
4. Check recent daily notes

---

## Confidence Levels

After searching:
- **High confidence:** Found explicit entry, recent, detailed
- **Medium confidence:** Found related entries, some inference needed
- **Low confidence:** Sparse results, uncertain → say so

Never pretend to remember what I don't. Say "I don't have that in my memory" when true.
