# Research Findings

What we know about dating app behavior, and where we know it from. This grounds the skill's recommendations in evidence — peer-reviewed research where it exists, platform data where it's available, and practical consensus where that's all there is.

We're honest about the evidence quality throughout. Three tiers:

- **Research** — Peer-reviewed, published in academic journals
- **Platform data** — Published by dating apps themselves (Hinge, OkCupid, Tinder). Credible but self-reported and selectively disclosed
- **Conventional wisdom** — Widely accepted in the dating coaching space but not formally studied. May be right, but treat as informed opinion

---

## Photos Matter More Than Text

The single most consistent finding across all dating app research: photos dominate decision-making.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Photos are the dominant factor in swipe decisions; bio text has minimal impact on right-swipe rates | Tyson et al. (2016), IEEE/ACM ASONAM | Research |
| Photos receive the majority of visual attention in dating profiles | Brand et al. (2012), *Computers in Human Behavior* | Research |
| Profile photos serve as the primary impression management tool; users are strategic in photo selection | Ward (2017), *Information, Communication & Society* | Research |
| Smiling faces are rated as more attractive and more trustworthy | Sedgewick et al. (2017), *Frontiers in Psychology* | Research |
| Profiles with all photo slots filled receive significantly more engagement | Hinge blog/press data | Platform data |
| Photos were less accurate than text — profile text was a better predictor of the actual person than photos were | Hancock & Toma (2009), *Journal of Communication* | Research |

**What this means:** First photo is the primary filter point. If it doesn't work, nothing else gets seen. But "10x impact" and "178% more matches from professional photos" — specific stats you'll see on dating advice blogs — are not from real studies. The directional finding is robust; the precise numbers are invented.

The Hancock & Toma finding is worth noting: photos are the first filter, but they're also where people are most likely to mislead (intentionally or not). Text is actually a more reliable signal of who someone is. This matters for the skill — we invest heavily in text because it's where authenticity lives.

### Photo red flags

Mirror selfies, bathroom pics, heavy filters, and all-selfie profiles are consistently cited as turn-offs across dating advice and survey data. This is **conventional wisdom** — no peer-reviewed study has measured the exact impact, but platform surveys and coaching experience consistently confirm it.

**Why red flags matter (research context):** Toma & Hancock (2010) found that less physically attractive daters were more likely to enhance their photos. Heavy filtering, unusual angles, and avoidance of full-body shots are processed by viewers — often unconsciously — as signals of deception. Even if someone isn't hiding anything, these choices trigger the same suspicion. The fix isn't "be more attractive" — it's "stop doing things that make people suspicious."

### Photo mix

The ideal 6-photo mix (opener, lifestyle, social proof, full body, personality, wildcard) comes from **conventional wisdom** — it's widely taught in dating coaching and makes intuitive sense, but isn't from a specific study. The underlying principle — that variety builds a complete picture — is supported by self-disclosure research: breadth of disclosure across multiple dimensions predicts higher attractiveness ratings (Gibbs et al., 2006).

### Smiling and expression

Sedgewick et al. (2017) found that smiling intensity affects both attractiveness and trustworthiness ratings. A genuine smile (Duchenne smile — involving the eyes) outperforms a posed smile. This is consistent with the broader signaling framework: a genuine expression is a costly signal (hard to fake convincingly), while a posed smile is cheap.

---

## Profile Text Actually Matters (More Than People Think)

While photos dominate the initial swipe, text independently predicts attractiveness and significantly affects outcomes — especially on prompt-based apps like Hinge.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Profile text independently predicted attractiveness ratings beyond photos. Creative, original profiles rated as more intelligent, funnier, and more attractive | Fiore et al. (2008), *CHI 2008* (DOI: 10.1145/1357054.1357181) | Research |
| Users with distinctive, creative self-presentation reported higher contact rates. Unique details serve as credibility signals because they're harder to fabricate | Ellison, Heino & Gibbs (2006), *JCMC* (DOI: 10.1111/j.1083-6101.2006.00020.x) | Research |
| Users seeking serious relationships (Hinge's core audience) valued profile completeness and text quality more than users seeking casual encounters | Sumter et al. (2017), *Telematics and Informatics* (DOI: 10.1016/j.tele.2016.04.009) | Research |
| Securely attached individuals preferred apps that emphasised text and profiles (like Hinge, OkCupid) over purely photo-based apps, and responded more positively to profiles demonstrating authenticity and emotional availability through text | Chin, Edelstein & Vernon (2019), *Mobile Media & Communication* | Research |
| Profiles with all prompts filled get significantly more engagement than those with empty or single-word answers | Hinge blog/press data | Platform data |

**What this means:** On Hinge specifically, text matters more than on purely swipe-based apps. The prompt architecture forces structured self-presentation, and the research says creative, specific text measurably improves outcomes. The Chin et al. finding is particularly relevant: people using Hinge (a relationship-oriented, text-heavy app) are disproportionately the kind of people who actually read and respond to good text. You're writing for an audience that cares.

---

## Specificity Beats Generic (Strong Evidence)

This is one of the best-supported findings in the research. Specific, concrete language consistently outperforms vague, abstract language in dating profiles.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Truthful profiles use more specific, concrete, sensory language. Deceptive profiles use vague, abstract language. Specificity signals honesty | Toma & Hancock (2012), *Journal of Communication* (DOI: 10.1111/j.1460-2466.2011.01619.x) | Research |
| Profiles with specific, verifiable lifestyle information produced significantly higher contact rates than vague descriptors | Hitsch, Hortacsu & Ariely (2010), *Quantitative Marketing and Economics* (DOI: 10.1007/s11129-010-9088-6) | Research |
| Specificity in profiles predicted stronger first-date outcomes. Specific details led to more accurate expectations and less disappointment at first meeting | Sharabi & Caughlin (2017), *Personal Relationships* (DOI: 10.1111/pere.12188) | Research |
| Concrete, specific language (low-level construals) creates psychological closeness. Abstract language creates distance | Trope & Liberman (2010), *Psychological Review* — Construal Level Theory | Research |
| Messages referencing specific shared interests had reply rates 30-40% higher than generic openers | OkCupid/OkTrends data (also in Rudder, *Dataclysm*, 2014) | Platform data |
| Generic profiles produced less accurate impressions and lower follow-through when people met | Frost, Chance, Norton & Ariely (2008), *Journal of Interactive Marketing* | Research |

**What this means:** "Jazz Cafe on a weeknight" genuinely works better than "live music" — and we can explain *why* through three independent research threads:

1. **Honesty signal** (Toma & Hancock): Specificity is a linguistic marker of truthfulness. Readers unconsciously process vague language as evasive and specific language as honest. When someone reads "I hate-watch Saturday Kitchen every week," they believe it — because why would you make that up?

2. **Psychological closeness** (Construal Level Theory): Concrete language puts the reader in the scene. "Jazz Cafe on a weeknight" creates a mental image — the room, the sound, the vibe. "Live music" creates nothing. Trope & Liberman (2010) showed that concrete details reduce psychological distance, making the writer feel more real and accessible.

3. **Better real-world outcomes** (Sharabi & Caughlin): Specific profiles create accurate expectations. When someone meets the person behind a specific profile, there's less gap between expectation and reality. Less disappointment. Better first dates. This is the whole chain: specificity improves not just matches but the quality of what happens after matching.

The Frost et al. finding closes the loop: generic profiles don't just get fewer matches — they produce worse dates. People show up expecting one thing and get another. Specificity is the fix at every stage.

---

## Show, Don't Tell (Strong Theoretical Basis)

Demonstrating a quality works better than claiming it. This maps onto signaling theory — one of the strongest theoretical frameworks in the skill.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| In text-only environments, demonstrated qualities are processed as more credible than claimed qualities | Walther (1996), *Communication Research* — Hyperpersonal Model | Research |
| Profiles demonstrating personality through examples beat trait-adjective lists ("I am funny" vs actually being funny). More honest, more appealing, higher contact rates | Gibbs, Ellison & Heino (2006), *Communication Research* (DOI: 10.1177/0093650205285368) | Research |
| "Showing" functions as a costly signal — it requires actually having the quality. "Telling" is a cheap signal anyone can make. Costly signals are more credible and persuasive | Donath (2007), *JCMC* — Signaling in Social Supernets | Research |
| Concrete examples trigger central-route processing (deeper, more durable evaluation). Abstract claims are processed peripherally and have weaker effects | Petty & Cacioppo (1986), Elaboration Likelihood Model | Research |

### Costly vs cheap signals — the framework

This comes from Donath (2007), building on Zahavi's handicap principle in evolutionary biology: signals that are expensive to produce are more credible because they're harder to fake.

| Signal type | Example | Why it works (or doesn't) |
|-------------|---------|--------------------------|
| **Costly** (hard to fake) | "Being nice about Timothée Chalamet" | Demonstrates actual humor — you have to be witty to write this |
| **Costly** | Specific venue/cultural references | Requires actual participation in that scene |
| **Costly** | Professional-quality photos | Investment of time and effort |
| **Costly** | Detailed, specific anecdotes | You'd have to have lived the experience to describe it convincingly |
| **Cheap** (easy to fake) | "I have a great sense of humor" | Anyone can say this; tells you nothing |
| **Cheap** | "Love to travel" | Everyone says this; zero differentiation |
| **Cheap** | Basic selfies | Minimal effort signal |
| **Cheap** | Trait adjective lists ("kind, loyal, fun") | Mass-produced language, no information content |

**The Elaboration Likelihood Model adds a layer:** Petty & Cacioppo (1986) showed that when people process persuasive messages, concrete examples trigger deeper evaluation (central route) and produce stronger, more lasting impressions. Abstract claims get shallow processing (peripheral route) and are forgotten quickly. In a dating profile, this means a specific story or detail is literally processed differently by the reader's brain than a generic claim. It sticks.

**What this means for the skill:** When we write "Being nice about Timothée Chalamet" instead of "I have dark humor," we're not just being clever — we're using a signal that's harder to fake, triggering deeper cognitive processing, and creating a more durable impression. The entire copy approach is built on this.

---

## Humor Works (Strong Evidence)

Humor in profiles significantly increases perceived attractiveness, and there's an important nuance: *producing* humor matters more than *appreciating* humor.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Humor in self-presentation significantly increased perceived attractiveness. Interpreted as signal of intelligence, creativity, and social competence | McGee & Shevlin (2009), *Journal of Psychology* (DOI: 10.3200/JRLP.143.1.67-77) | Research |
| Women preferred men who *produced* humor over men who *appreciated* humor. Men showed the reverse preference. For men's profiles, generating humor is more effective than signaling you enjoy humor | Bressler & Balshine (2006), *Evolution and Human Behavior* (DOI: 10.1016/j.evolhumbehav.2005.04.005) | Research |
| Humor production ability correlated with measured intelligence (r = .40) and mating success. Demonstrated humor functions as an honest signal of cognitive ability | Greengross & Miller (2011), *Intelligence* (DOI: 10.1016/j.intell.2011.03.006) | Research |
| Humor serves dual functions: signaling genetic fitness and indicating romantic interest | Li et al. (2009), *Personality and Social Psychology Bulletin* | Research |
| Messages containing humor had 15-20% higher reply rates than earnest messages | OkCupid/OkTrends data | Platform data |

### The gender nuance

Bressler & Balshine (2006) found an asymmetry: women valued humor *production* in men (actually being funny), while men valued humor *appreciation* in women (laughing at their jokes). This maps onto evolutionary psychology predictions about humor as a fitness indicator.

**Practical implication:** For men writing profiles, the priority is demonstrating wit — writing something that's actually funny, not claiming to be funny or saying "I appreciate humor." For women, the dynamic is different: demonstrated humor still works and differentiates, but warmth and responsiveness signals also carry weight.

This is a general pattern, not a rule. Individual variation matters more than group averages. But it's worth knowing when making strategic choices about what to emphasise.

### The failed humor risk

Failed humor is worse than no humor. Excessive self-deprecation reduces perceived confidence and attractiveness (Lundy, Tan & Cunningham, 1998, *PSPB*). The research draws a clear line: self-aware humor (acknowledging a quirk with confidence) works; self-deprecating humor that signals genuine insecurity doesn't.

**What this means for the skill:** "Balance edge with warmth" isn't just a style preference — it's grounded in research. Dark humor or strong opinions (edge) signal intelligence and personality. Family warmth, genuine enthusiasm (warmth) signal relationship potential and emotional availability. Pure edge reads as bitter; pure warmth reads as bland. The balance is the strategy.

---

## Self-Disclosure: How Much to Reveal

How much to share in a profile is a research question with a clear answer: moderate depth, high specificity, breadth across topics.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Breadth of disclosure (covering multiple topics) predicted higher attractiveness. Depth had a curvilinear effect — moderate depth optimal. Too shallow = boring; too deep = uncomfortable | Gibbs, Ellison & Heino (2006), *Communication Research* | Research |
| Self-disclosure increased liking, but strongest when it felt natural and appropriate to the relationship stage | Sprecher, Treger & Wondra (2013), *Journal of Relationships Research* | Research |
| Disclosure perceived as intentional and personal creates more intimacy than disclosure that feels mass-broadcast | Jiang, Bazarova & Hancock (2011), *Human Communication Research* | Research |
| The most effective profiles balanced idealization with authenticity, self-promotion with warmth, and individual distinctiveness with broad appeal | Whitty (2008), *Computers in Human Behavior* (DOI: 10.1016/j.chb.2007.07.002) | Research |

### The foundational theory

Self-disclosure research builds on Altman & Taylor's (1973) Social Penetration Theory: relationships develop as disclosure moves from superficial to intimate layers. The key insight for dating profiles is that disclosure should match the relationship stage. A profile is a first impression — it should reveal enough to create connection, but not so much that it violates norms of graduated intimacy.

### The practical framework

| Disclosure level | Example | Effect |
|-----------------|---------|--------|
| Moderate depth, high specificity | "I hate-watch Saturday Kitchen every week" | Creates connection without oversharing. Reveals personality through a specific detail. |
| Breadth across topics | Humor + values + lifestyle across 3 prompts | Shows multiple dimensions — you're a whole person, not a one-note character |
| Controlled vulnerability | Admitting a guilty pleasure, a niche obsession | Builds perceived authenticity. Signals trust ("I'm sharing this with you") |
| Too shallow | "I like music and food" | Boring, no connection. These are human universals, not personality markers |
| Too deep | "Still recovering from my parents' divorce" | Violates stage-appropriate norms. Creates discomfort, not intimacy |
| Mass-broadcast feeling | "Looking for my person, love to laugh" | Jiang et al. found this creates less intimacy — it feels like it was written for everyone, not for someone like you |

### The Whitty balance

Whitty (2008) studied which profiles got the most responses and found that the winners balanced three tensions:

1. **Idealisation vs authenticity** — Present your best self, but remain recognisable. Don't invent a persona.
2. **Self-promotion vs warmth** — Show what's impressive about you, but also show you're approachable and kind.
3. **Distinctiveness vs appeal** — Stand out from the crowd, but don't be so niche that no one relates.

These three balances are useful guidelines for the copy creation phase. A prompt answer that's too self-promoting ("I run a seven-figure business") misses warmth. One that's too niche ("I collect vintage Soviet calculators") might miss appeal. The skill aims for the intersection.

**What this means for the skill:** The discovery interview is designed to surface moderate-depth, high-specificity material across breadth of topics. That's not an accident — it maps to what self-disclosure research says works. The 150-character Hinge limit actually helps by forcing concision and preventing oversharing.

---

## The Foggy Mirror: Authenticity as Strategy

This is the most important section of this document for the skill's philosophy. Toma and Hancock's research program (five major papers, 2008-2015) is the most thorough investigation of self-presentation in online dating, and its findings directly inform how we work.

### What people actually lie about

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| 81% of online daters lied about at least one attribute, but deceptions were small — people stretch truth rather than fabricate | Toma, Hancock & Ellison (2008), *PSPB* (DOI: 10.1177/0146167208318067) | Research |
| Women were more likely to misrepresent weight; men more likely to misrepresent height. Both sexes misrepresented age | Toma, Hancock & Ellison (2008) | Research |
| Profile text was more accurate than photos; text deception was subtler (vague language rather than outright lies) | Hancock & Toma (2009), *Journal of Communication* (DOI: 10.1111/j.1460-2466.2009.01420.x) | Research |
| Deceptive profiles used fewer first-person pronouns, shorter descriptions, and more negation words | Toma & Hancock (2012) | Research |

### The foggy mirror principle

Toma et al. (2008) coined a useful metaphor: people present themselves as through a "foggy mirror" — slightly idealised but recognisable. Not fiction. Not a lie. You on a good day, well-lit, well-articulated.

81% of people stretch the truth somewhere. But the deceptions are small. People don't fabricate entire personas — they shave an inch off their age, use a photo from two years ago, describe their job in slightly grander terms. The foggy mirror, not a funhouse mirror.

**This is the operating principle for the entire skill.** We're not inventing characters. We're finding the most interesting true things about someone and making sure those things are visible. The 92-year-old great uncle is real. The Timothée Chalamet hatred is real. The exhibition catalogue is real. We're presenting real people at their best — aspirationally accurate.

### Why people hide behind generic language

Here's what happens without intervention: most people write generic profiles. Not because they're boring, but because being specific feels risky. Saying "I love live music" feels safe. Saying "Jazz Cafe on a weeknight" feels exposed — what if someone judges you for it?

The research says this instinct is exactly backwards:

- **Generic language reads as evasive.** Toma & Hancock (2012) found that vague, abstract language is literally a linguistic marker of deception. When someone reads "I love to laugh and have fun," their brain — without them knowing it — processes this the same way it processes someone dodging a question. The generic phrasing that feels safe is actually triggering suspicion.

- **Specific language reads as honest.** Concrete details, specific references, sensory language — these are markers of truthfulness. When someone reads "I hate-watch Saturday Kitchen every week," they believe it, because why would you make that up? The specificity that feels vulnerable is actually building trust.

- **The paradox of vulnerability:** Sharing something specific ("I have an irrational hatred of Timothée Chalamet") feels like you're opening yourself up to judgment. But it reads as confidence. You're secure enough to have opinions and share them. Meanwhile, the generic profile ("looking for my partner in crime") feels like hiding — and it is.

This is why the discovery phase pushes for specifics. Most people's first instinct is to generalise. Our job is to help them past that instinct.

### Profiles shape identity (Toma, 2015)

This is the finding that most directly supports the skill's philosophy.

Toma (2015) found that writing a dating profile actually changed how people saw themselves. The act of choosing what to highlight, articulating who you are, and presenting it publicly didn't just describe identity — it reinforced and sometimes *created* it.

The implications are bigger than matching:

**1. A good profile is an act of self-understanding.** When someone goes through the discovery interview and we find the specific things that make them them — the weird ritual, the niche interest, the relationship with the great uncle — and we shape those into a profile, we're not just optimising for matches. We're helping them see themselves more clearly. Many people have never articulated what makes them interesting. The process itself is valuable.

**2. Profiles become self-fulfilling.** If your profile says you're someone who goes to Jazz Cafe on weeknights and has strong opinions about brutalist architecture, you become more of that person. You lean into it. You go to Jazz Cafe. You notice the brutalist building on the way to work. Identity is partly performative, and a well-written profile performs a version of you that's true but more vivid.

**3. This is why "status affirming" matters.** Most people come into this process feeling like their profile sucks because *they* suck. Toma's research says the opposite: helping someone write a genuine, compelling profile that highlights their actual qualities doesn't just improve their match rate — it improves how they see themselves. The confidence boost isn't a side effect. It's part of the mechanism.

**4. Generic profiles do the opposite.** If your profile says "love to laugh, looking for my partner in crime," what identity does that reinforce? Nothing. It's a non-statement. It doesn't help you understand yourself and it doesn't help anyone else understand you. A generic profile isn't just strategically bad — it's a missed opportunity for genuine self-reflection.

### The whole chain: profile to relationship

| Stage | What happens with a generic profile | What happens with a specific, authentic profile |
|-------|--------------------------------------|------------------------------------------------|
| **Profile** | Vague impression. "They seem fine." | Clear impression. "I know something about this person." |
| **Match** | Matched on looks alone. No shared ground. | Matched on shared interest or compatible worldview. |
| **Conversation** | "Hey, how's your week?" — nowhere to start. | "Wait, you hate-watch Saturday Kitchen too?" — instant hook. |
| **First date** | Strangers discovering whether they have anything in common. | People who already know they share something specific. |
| **Outcome** | Expectation gap. Disappointment. Ghosting. | Expectations met or exceeded. Actual connection. |

This chain is supported across multiple studies:
- Frost et al. (2008): Generic profiles produce less accurate impressions and lower follow-through at meeting
- Sharabi & Caughlin (2017): Specificity in profiles predicts better first-date outcomes
- Toma & Hancock (2012): Specific language signals authenticity
- Toma (2015): Writing a specific profile reinforces genuine identity

**This is why the skill exists.** Not just to get more likes — to build the foundation for actual connections. Every phase of the process serves this chain: discovery finds the real material, copy makes it visible, specificity creates honest expectations, and honest expectations lead to better dates with better people.

---

## Competition Dynamics (Sobering Data)

The dating app market is extremely unequal. Understanding this grounds the "reality check" phase.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Most users pursue partners ~25% more desirable than themselves. Desirability follows a power-law distribution — top profiles receive 10-100x the messages of median profiles | Bruch & Newman (2018), *Science Advances* (DOI: 10.1126/sciadv.aap9815) | Research |
| Top 10% of male profiles received ~58% of all female likes. Women were 7x more selective than men | Tyson et al. (2016), IEEE/ACM ASONAM | Research |
| Strong homophily effects — people preferentially contact those similar on education, cultural tastes, lifestyle markers. Specific cultural references function as sorting mechanisms | Fiore & Donath (2005), *CHI Extended Abstracts* | Research |
| Users with more "desirable" profiles were significantly more selective and more sensitive to profile quality indicators including text quality and specificity | Hitsch, Hortacsu & Ariely (2010) | Research |

### What the power law means

Bruch & Newman (2018) — published in *Science Advances*, one of the highest-impact journals in science — analyzed messaging patterns of roughly 200,000 users across four US cities. Their findings are stark:

- Desirability follows a power-law distribution. A small number of profiles receive the vast majority of attention.
- The most desirable woman in their dataset received around 1,500 messages in the study period. The most desirable man received around 250. The median received far less.
- Most people message partners roughly 25% more desirable than themselves ("aspirational pursuit").
- People at the top have abundant options and are far more selective about who they respond to.

This isn't depressing — it's strategically useful. It means:

1. **Volume is the wrong strategy.** You can't out-swipe the power law. Sending more likes doesn't help if you're not memorable.
2. **Profile quality determines your tier.** The algorithm sorts people into visibility tiers based on engagement signals. A better profile moves you up. This has compounding effects.
3. **The right 30-50 people matter more than 1,000 random ones.** Filtering and differentiation beat broad appeal.

### What quality matches look for

Hitsch et al. (2010) found that users with the most desirable profiles were significantly more selective — and more sensitive to profile quality indicators. They noticed text quality, specificity, and evidence of cultural engagement at higher rates than average users.

**What this means:** The people you're trying to attract are the people who are most likely to read your prompts, notice the difference between specific and generic, and appreciate well-crafted text. Optimizing your profile isn't just about getting past the initial filter — it's about impressing the people who are actually paying attention.

### Homophily: why cultural specificity is a strategy

Fiore & Donath (2005) found strong homophily effects in online dating: people preferentially contact those who are similar to them in education, cultural tastes, and lifestyle markers.

This is why specific cultural references ("Jazz Cafe on a weeknight," "Brutalist architecture," "exhibition catalogues") are strategic, not self-indulgent. They function as sorting mechanisms: people who share those interests recognise the reference and feel affinity. People who don't, self-select out. In a power-law market, this is exactly what you want — not maximum likes, but the right likes from people who share your world.

---

## Algorithm & Engagement

What's known about how Hinge's algorithm works, and what's speculation.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Likes with comments are significantly more likely to lead to conversations than bare likes | Hinge press/blog data (circa 2018-2019) | Platform data |
| "Most Compatible" matches are significantly more likely to result in dates (Hinge claims 8x) | Hinge press release, 2018, announcing Most Compatible feature. Uses Gale-Shapley algorithm | Platform data |
| Hinge's algorithm rewards: profile completeness, engagement quality, response rate, activity consistency | Hinge blog/press, various | Platform data |

### Why comments work (research context)

The Hinge data on comments beating bare likes isn't just a platform quirk — it's explained by signaling theory. Donath (2007) established that signals requiring more effort are more credible. A comment requires reading the profile, finding something to respond to, and crafting a message. A bare like requires one tap. The comment is a costly signal; the bare like is cheap.

OkCupid's data (Rudder, *Dataclysm*, 2014) showed the same pattern from the other side: messages referencing specific profile content had reply rates 30-40% higher than generic openers ("Hey" / "What's up?"). Specificity signals genuine interest.

### Algorithmic tiering

While Hinge hasn't published details of its algorithm, all major dating apps use some form of desirability-based sorting. Tinder historically used an Elo rating system (adapted from chess) that ranked users by desirability based on who swiped right on them. High-Elo users were shown to other high-Elo users, creating de facto tiers.

Hinge has stated they moved beyond simple attractiveness ranking, but their algorithm still factors in engagement signals — profile completeness, comment rate, response speed, activity consistency. The practical implication: everything you do on the app affects who sees your profile. A better profile gets better engagement gets shown to better matches. It compounds.

**What we can infer but can't prove:**
- Incomplete profiles likely get deprioritised (Hinge nudges completion in-app; all recommendation systems reward complete data)
- Response rate likely affects visibility (standard in recommendation systems, but Hinge hasn't confirmed specifics)
- Daily activity likely keeps profiles visible (common across dating apps, but specifics are proprietary)

**The "10-20% like rate sweet spot"** — this is **conventional wisdom** from dating coaches. No published data confirms this specific number. The principle (being somewhat selective signals quality) is plausible but unverified.

---

## Messaging and Conversation

What happens after the match — research on what makes people respond and what leads to actual dates.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Messages referencing specific profile content had 30-40% higher reply rates than generic openers | OkCupid/OkTrends data; Rudder, *Dataclysm* (2014) | Platform data |
| Humor in messages increased reply rates by 15-20% compared to earnest messages | OkCupid/OkTrends data | Platform data |
| Specificity in profiles predicted better first-date outcomes — less gap between expectation and reality | Sharabi & Caughlin (2017), *Personal Relationships* | Research |

### The profile-to-date pipeline

The research reveals a chain: profile specificity improves not just match rate but everything downstream.

1. **Specific profile** → more honest impression (Toma & Hancock, 2012)
2. **More honest impression** → more accurate expectations (Frost et al., 2008)
3. **More accurate expectations** → better first dates (Sharabi & Caughlin, 2017)
4. **Better first dates** → actual relationships

Generic profiles break this chain at step 1. They create vague impressions, which create vague expectations, which lead to disappointing first dates where two strangers discover they have nothing specific in common.

This is why the skill invests so heavily in the discovery phase — we're not just writing clever prompts, we're building the foundation for better dates.

### Conversation hooks in context

A good profile doesn't just get likes — it makes it easy for someone to start a conversation. "Being nice about Timothée Chalamet" gives someone an immediate entry point ("Wait, what did he do?"). "Love to laugh" gives someone nothing to say.

This maps back to the OkCupid data: specific references get specific responses, and specific responses lead to actual conversations, and actual conversations lead to dates.

---

## Gender Differences

Several findings show gender-specific patterns that affect strategy.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Women were 7x more selective than men in swiping | Tyson et al. (2016) | Research |
| Women valued humor production in men; men valued humor appreciation in women | Bressler & Balshine (2006) | Research |
| The effect of creative/original profile text on attractiveness was stronger for women evaluating men's profiles | Fiore et al. (2008) | Research |
| Women's desirability peaked earlier in the dataset; men's desirability peaked later | Bruch & Newman (2018) | Research |
| Women were more likely to misrepresent weight; men were more likely to misrepresent height | Toma, Hancock & Ellison (2008) | Research |

### What this means for strategy

These are population-level patterns, not rules for individuals. But they have strategic implications:

**For men's profiles:** Text quality matters more because (a) women are more selective and actually read profiles, and (b) creative text has a stronger effect on women's attractiveness ratings. Demonstrated humor (actually being funny) is more effective than signaling you appreciate humor. Photo quality is table stakes — the text is where differentiation happens.

**For women's profiles:** The competition for attention is lower (men are less selective), but the competition for *quality* attention is real. Profiles that demonstrate personality and specificity attract more thoughtful engagement — comments instead of bare likes, which leads to better conversations.

**For everyone:** The specificity and signaling findings apply across the board. Individual variation within genders is far larger than the average differences between genders. The core strategy — find what's unique, be specific, show don't tell — works regardless.

---

## Profile Text Length

How much to write — the research says moderate length with high information density.

| Finding | Source | Evidence tier |
|---------|--------|---------------|
| Curvilinear relationship: very short profiles rated poorly, moderate length performed best, very long showed diminishing returns | Fiore et al. (2008), *CHI 2008* | Research |
| Longer profiles (up to a point) correlated with more contacts, but extremely long profiles saw decline | Hitsch et al. (2010) | Research |
| Profiles between 100-200 words performed best for women; 100-300 for men. Under 50 and over 500 both underperformed | OkCupid/OkTrends data; Rudder, *Dataclysm* (2014) | Platform data |

**The Hinge constraint:** 3 prompts × 150 characters = 450 characters max. The architecture enforces concision. The research says: use all the space, but make every word count. Hinge's character limit is actually well-designed — it sits in the sweet spot where you have enough room to show personality but not enough to ramble.

---

## What Consistently Predicts Better Outcomes

Drawing across the full research base, these qualities consistently improve dating profile performance. Ordered by evidence strength:

| Quality | Evidence strength | Key sources | How the skill uses it |
|---------|-------------------|-------------|----------------------|
| Specificity over generality | **Strong** (multiple studies) | Toma & Hancock (2012); Hitsch et al. (2010); Sharabi & Caughlin (2017) | Copy principles: "Jazz Cafe > live music" |
| Demonstrated personality ("show don't tell") | **Strong** (multiple studies + theory) | Gibbs et al. (2006); Donath (2007); Walther (1996) | Copy principles: costly vs cheap signals |
| Humor/wit | **Strong** (multiple studies) | McGee & Shevlin (2009); Bressler & Balshine (2006); Greengross & Miller (2011) | Copy principles: balance edge with warmth |
| Authenticity cues | **Strong** (Toma & Hancock research program) | Toma & Hancock (2010, 2012); Hancock & Toma (2009) | Philosophy: status affirming, not status fixing |
| Profile completeness | **Moderate-strong** (research + platform data) | Fiore et al. (2008); Hinge data; Sumter et al. (2017) | Audit criteria: completeness weighting |
| Warmth signals | **Moderate-strong** | Whitty (2008); self-disclosure research | Copy principles: warmth markers |
| Conversation hooks | **Moderate** (mostly platform data) | OkCupid data; Hinge comment data | Copy principles: every element = conversation hook |
| Unique/memorable content | **Moderate-strong** | Fiore et al. (2008); Ellison et al. (2006); von Restorff effect | Audit criteria: generic phrase penalties |
| Balanced self-disclosure | **Strong** (foundational theory) | Gibbs et al. (2006); Altman & Taylor (1973); Whitty (2008) | Discovery interview design |
| Cultural specificity / filtering | **Moderate** | Fiore & Donath (2005); homophily research | Copy principles: filter in AND filter out |

---

## Key Citations

### Peer-Reviewed Studies

1. Bruch, E.E. & Newman, M.E.J. (2018). "Aspirational Pursuit of Mates in Online Dating Markets." *Science Advances*, 4(8), eaap9815. DOI: 10.1126/sciadv.aap9815
2. Toma, C.L. & Hancock, J.T. (2012). "What Lies Beneath: The Linguistic Traces of Deception in Online Dating Profiles." *Journal of Communication*, 62(1), 78-97. DOI: 10.1111/j.1460-2466.2011.01619.x
3. Toma, C.L. & Hancock, J.T. (2010). "Looks and Lies: The Role of Physical Attractiveness in Online Dating Self-Presentation and Deception." *Communication Research*, 37(3), 335-351. DOI: 10.1177/0093650209356437
4. Fiore, A.T., Taylor, L.S., Mendelsohn, G.A. & Hearst, M. (2008). "Assessing Attractiveness in Online Dating Profiles." *CHI 2008*, 797-806. DOI: 10.1145/1357054.1357181
5. Gibbs, J.L., Ellison, N.B. & Heino, R.D. (2006). "Self-Presentation in Online Personals." *Communication Research*, 33(2), 152-177. DOI: 10.1177/0093650205285368
6. Ellison, N.B., Heino, R.D. & Gibbs, J.L. (2006). "Managing Impressions Online." *JCMC*, 11(2), 415-441. DOI: 10.1111/j.1083-6101.2006.00020.x
7. McGee, E. & Shevlin, M. (2009). "Effect of Humor on Interpersonal Attraction and Mate Selection." *Journal of Psychology*, 143(1), 67-77. DOI: 10.3200/JRLP.143.1.67-77
8. Bressler, E.R. & Balshine, S. (2006). "The Influence of Humor on Desirability." *Evolution and Human Behavior*, 27(1), 29-39. DOI: 10.1016/j.evolhumbehav.2005.04.005
9. Donath, J. (2007). "Signals in Social Supernets." *JCMC*, 13(1), 231-251.
10. Hitsch, G.J., Hortacsu, A. & Ariely, D. (2010). "What Makes You Click?" *Quantitative Marketing and Economics*, 8(4), 393-427. DOI: 10.1007/s11129-010-9088-6
11. Tyson, G. et al. (2016). "A First Look at User Activity on Tinder." IEEE/ACM ASONAM.
12. Sharabi, L.L. & Caughlin, J.P. (2017). "What Predicts First Date Success?" *Personal Relationships*, 24(2), 370-391. DOI: 10.1111/pere.12188
13. Sumter, S.R., Vandenbosch, L. & Ligtenberg, L. (2017). "Love Me Tinder." *Telematics and Informatics*, 34(1), 67-78. DOI: 10.1016/j.tele.2016.04.009
14. Walther, J.B. (1996). "Computer-Mediated Communication: Impersonal, Interpersonal, and Hyperpersonal." *Communication Research*, 23(1), 3-43.
15. Toma, C.L., Hancock, J.T. & Ellison, N.B. (2008). "Separating Fact from Fiction." *PSPB*, 34(8), 1023-1036. DOI: 10.1177/0146167208318067
16. Hancock, J.T. & Toma, C.L. (2009). "Putting Your Best Face Forward." *Journal of Communication*, 59(2), 367-386. DOI: 10.1111/j.1460-2466.2009.01420.x
17. Toma, C.L. (2015). "Effects of Online Dating Profiles on Daters' Self-Concept." *Communication Research*, 42(6), 773-793.
18. Frost, J.H., Chance, Z., Norton, M.I. & Ariely, D. (2008). "People are Experience Goods." *Journal of Interactive Marketing*, 22(1), 51-61.
19. Greengross, G. & Miller, G.F. (2011). "Humor Ability Reveals Intelligence." *Intelligence*, 39(4), 188-192. DOI: 10.1016/j.intell.2011.03.006
20. Li, N.P. et al. (2009). "An Evolutionary Perspective on Humor." *PSPB*, 35(7), 923-936.
21. Brand, R.J. et al. (2012). "Hot or Not? Visual attention to faces." *Computers in Human Behavior*.
22. Sedgewick, J.R. et al. (2017). "The Effect of Smile Intensity on Perceptions." *Frontiers in Psychology*.
23. Sprecher, S., Treger, S. & Wondra, J.D. (2013). "Effects of Self-Disclosure Role on Liking." *Journal of Relationships Research*, 4, e1.
24. Jiang, L.C., Bazarova, N.N. & Hancock, J.T. (2011). "The Disclosure-Intimacy Link in CMC." *Human Communication Research*, 37(1), 58-77.
25. Whitty, M.T. (2008). "Revealing the 'Real' Me." *Computers in Human Behavior*, 24(4), 1707-1723. DOI: 10.1016/j.chb.2007.07.002
26. Fiore, A.T. & Donath, J.S. (2005). "Homophily in Online Dating." *CHI '05 Extended Abstracts*, 1371-1374.
27. Ward, J. (2017). "What Are You Doing on Tinder?" *Information, Communication & Society*, 20(11), 1644-1659. DOI: 10.1080/1369118X.2016.1252412
28. Trope, Y. & Liberman, N. (2010). "Construal-Level Theory." *Psychological Review*, 117(2), 440-463.
29. Chin, K., Edelstein, R.S. & Vernon, P.A. (2019). "Attached to Dating Apps." *Mobile Media & Communication*, 7(1), 41-59.

### Platform & Industry Data

- Hinge press releases and blog posts (2018-2022) — comments vs likes, Most Compatible, profile completeness
- OkCupid/OkTrends blog; Rudder, C. (2014). *Dataclysm*. Crown — messaging data, profile length, specificity effects
- Hinge "Most Compatible" feature launch (2018) — Gale-Shapley algorithm, 8x claim

### Foundational Theory

- Altman, I. & Taylor, D.A. (1973). *Social Penetration Theory* — self-disclosure framework
- Petty, R.E. & Cacioppo, J.T. (1986). *Elaboration Likelihood Model* — why concrete examples persuade more than abstract claims
- Zahavi, A. (1975). Handicap Principle — costly signaling in mate selection

---

## How This Research Drives the Process

This section connects the findings back to what we actually do. Every phase of the skill exists for a reason, and the research explains why.

### Why the discovery interview works

The discovery phase asks a lot of seemingly random questions — guilty pleasures, pet peeves, weird rituals, strong opinions, family relationships. There's a method to it:

- **Self-disclosure research says breadth matters.** Gibbs et al. (2006) found that covering multiple topics (humor + values + lifestyle + interests) predicts higher attractiveness ratings. We ask across categories because the profile needs to show multiple dimensions of a person, not just one note.

- **We're mining for costly signals.** Every question is looking for something specific, unusual, or hard to fake. "What did you actually do last weekend?" surfaces real details. "What are you irrationally into?" finds the passions that can't be generic. These become the raw material for costly signals in the profile.

- **Moderate depth is the target.** Social Penetration Theory says disclosure should match the relationship stage. A dating profile is a first impression. We want the Saturday Kitchen hate-watch (moderate depth, high specificity), not the childhood trauma (too deep) or "I like food" (too shallow). The questions are designed to hit this level.

- **We're looking for what Whitty (2008) called the balance.** Every question is testing: what's distinctive about this person (uniqueness) that's also relatable (appeal) and genuinely true (authenticity) but presented at its best (idealisation)? The intersection of those four things is where the best profile material lives.

### Why the audit scores the way it does

Photos weighted at 40%, prompts at 30%, completeness at 15%, signaling at 15%. These aren't sacred numbers, but they reflect what research says matters:

- **Photos first** because every study confirms they dominate the initial decision (Tyson et al., 2016; Brand et al., 2012). A profile with excellent text and bad photos won't get read. Photos are the gatekeeper.

- **Prompts heavily weighted** because on Hinge, text matters more than on other apps (Sumter et al., 2017; Chin et al., 2019). The people using Hinge skew toward wanting substance. The prompts are where differentiation happens.

- **Completeness matters** because incomplete profiles signal low effort (a cheap signal of low investment), get algorithmically deprioritised, and miss opportunities. Fiore et al. (2008) found profile completeness correlated with perceived attractiveness.

- **Signaling analysis** because what a profile *communicates* often differs from what the person *intended*. The gap between intended and actual signals is where the biggest improvements hide.

### Why copy is written the way it is

Every copy principle maps to research:

- **"Jazz Cafe > live music"** — specificity signals honesty (Toma & Hancock, 2012), creates closeness (Trope & Liberman, 2010), and produces better real-world outcomes (Sharabi & Caughlin, 2017).

- **"Being nice about Timothée Chalamet" > "I have dark humor"** — costly signal vs cheap signal (Donath, 2007). Central-route processing vs peripheral (Petty & Cacioppo, 1986). Demonstrating vs claiming (Gibbs et al., 2006).

- **Conversation hooks in every prompt** — OkCupid data shows specific references get 30-40% more responses. A prompt someone can't respond to is a wasted prompt.

- **Filter in AND filter out** — homophily research (Fiore & Donath, 2005) shows people seek similarity. Cultural specificity attracts compatible matches and repels incompatible ones. In a power-law market (Bruch & Newman, 2018), this is the right strategy.

- **Balance edge with warmth** — humor signals intelligence (McGee & Shevlin, 2009) but pure edge reads as bitter. Whitty (2008) found the best profiles balance self-promotion with warmth, distinctiveness with appeal.

- **150 characters, every word earns its place** — Fiore et al. (2008) and Hitsch et al. (2010) both found moderate length with high density outperforms both extremes. Hinge's character limit enforces this naturally.

### Why the reality check matters

Most people's instinct is to cast a wide net. The research says this is wrong:

- **Bruch & Newman (2018):** The market follows a power law. The top profiles get wildly disproportionate attention. You can't out-volume the power law.

- **The strategy is quality, not quantity.** Being memorable to 30-50 right people beats being forgettable to 500. This is counterintuitive — it feels like narrowing your options. But filtering attracts better matches, and better matches lead to actual dates.

- **Settings matter more than people think.** A too-narrow age range, unnecessary dealbreakers, or wrong distance can dramatically shrink your pool before anyone sees your profile. The algorithm uses hard filters first (settings) and soft signals second (profile quality). If your settings are wrong, the best profile in the world won't help.

### Why we implement together

Most profile advice ends with "here's a document, good luck." We stay for implementation because:

- **Friction kills follow-through.** If someone has to come back later to implement changes, the probability drops dramatically. Doing it together, in the moment, while the rationale is fresh, gets it done.

- **Order matters.** Photo sequence, prompt placement, which photo gets which caption — these details affect how the profile reads as a whole. It's not just about individual elements; it's about the story the profile tells when someone scrolls through it.

- **The algorithm recalibrates.** When you change a profile significantly, the algorithm needs time to learn the new version. Understanding this prevents the "I changed everything and nothing happened in 24 hours" panic.

---

## Caveats

**Replication and recency:** Some older studies (pre-2015) were conducted on desktop dating sites, not mobile apps. User behaviour has evolved. However, the core psychological mechanisms (signaling, self-disclosure, construal level) are robust and platform-independent.

**Platform specificity:** Hinge's prompt-based architecture (3 prompts, 150 characters each) creates a different environment from free-form bio platforms. The constraints actually help — forced brevity plus the prompt frame naturally pushes toward the patterns research supports (specificity, hooks, show-don't-tell).

**Photo dominance:** Every study that compared photo impact to text impact found photos dominant. Text matters, but it matters *conditional on photos clearing the initial threshold*. Profile text optimisation is the second-highest-leverage intervention after photo quality.

**Individual variation:** Gender patterns, age effects, and cultural differences exist at the population level. Individual variation within any group is far larger than the average difference between groups. Use the research as a starting point, not a prescription.

---

## A Note on Evidence

Earlier versions of this document cited specific statistics ("10x impact," "178% more matches," "78% turn-off") attributed to sources that either don't exist as published research or are commercial blogs presenting marketing data as studies. We've replaced those with honestly sourced findings.

The advice in this skill is directionally consistent with what the research shows. Where we cite specific numbers, we name the actual source. Where the evidence is conventional wisdom rather than formal research, we say so. The goal is to be useful and honest, not to inflate credibility with fake precision.
