# Photo Guidelines

How to evaluate, select, and order photos.

---

## First Photo (Most Critical)

Photos dominate swipe decisions — research consistently shows they're the primary factor in whether someone keeps looking or moves on (Tyson et al., 2016; Brand et al., 2012). First photo matters most because profiles receive only seconds of attention, and most of that time is spent on photos.

### Requirements
- ☐ Face clearly visible (no sunglasses, not too distant)
- ☐ Good lighting (natural light best)
- ☐ Genuine expression (real smile, not forced)
- ☐ Solo (not cropped from group)
- ☐ Not a selfie
- ☐ Clean background (not cluttered)
- ☐ Eye contact with camera
- ☐ Recent (within last year)

### First Photo Red Flags
- Selfie (especially mirror selfie)
- Lying down
- Sunglasses
- Group photo
- Too distant (can't see face)
- Heavy filters
- Bathroom
- Orange/bad lighting

---

## Ideal Photo Mix (6 Photos)

### Position 1: The Opener
**Purpose:** Make them want to see more
- Best face photo
- Genuine warmth
- Clear, well-lit
- Makes a good first impression

### Position 2: Context/Lifestyle
**Purpose:** Show their world
- What their life looks like
- Activity or setting that reflects personality
- Workplace, hobby, cultural venue

### Position 3: Social Proof
**Purpose:** Show they have people in their life
- With friends (but face still clear)
- Not all group photos cropped
- Shows they're not a loner

### Position 4: Full Body
**Purpose:** Build trust, show they're not hiding
- Outdoor, natural setting
- Engaged in something
- Not awkward posed full-body shot

### Position 5: Personality/Interest
**Purpose:** Show what they're into
- Hobby, passion, activity
- Cultural engagement
- Something that sparks conversation

### Position 6: Wildcard
**Purpose:** Memorable closer
- Humor
- Unexpected
- Conversation starter
- Could be a meme if it fits their vibe

---

## Photo Evaluation Checklist

For each photo, assess:

| Criteria | Score 1-5 |
|----------|-----------|
| Face visibility | |
| Lighting quality | |
| Expression/energy | |
| Story/context | |
| Technical quality | |
| Conversation potential | |

### What Story Does This Photo Tell?

For each photo, articulate:
- What does this show about them?
- What kind of person would be attracted to this?
- Does it add something the other photos don't?
- Could someone easily comment on it?

---

## Red Flags to Eliminate

### Immediate Deletes
- **Mirror selfies** (widely cited as a top turn-off in platform surveys and dating coaching — signals low effort and low self-awareness)
- **Bathroom photos** (weird, low effort)
- **Shirtless gym pics** (unless that's explicitly their target)
- **Fish photos** (cliche, polarizing)
- **Heavily filtered** (signals hiding something — Toma & Hancock, 2010 found less attractive daters are more likely to enhance photos, so heavy filtering reads as deception even if that's not the intent)

### Probably Delete
- All selfies (suggests no friends to take photos)
- Group photos where subject unclear
- Sunglasses in multiple photos (hiding)
- Same angle/pose repeated
- Very old photos (misleading)
- Photos with exes cropped out (obvious)

### Context-Dependent
- Photos with kids (depends on their situation/target)
- Photos with alcohol (depends on vibe)
- Travel photos (fine, but not all travel)

---

## Common Gaps

### What's Usually Missing

**Workspace/Professional Context**
- Creative work environment
- Evidence of what they do
- Not corporate headshot, but authentic work setting

**Cultural Engagement**
- At gallery, venue, event
- Shows they actually do things
- Insider signal for similar people

**Full Body Outdoors**
- Not cropped, natural setting
- Builds trust
- Shows active lifestyle

**Social Photos Where Face is Clear**
- With friends but identifiable
- Not just group shots
- Warm, having fun

---

## Photo Shoot Guidance

If they need new photos, suggest:

**Framing:**
- "Let's get some photos that show your life"
- NOT "dating profile photoshoot" (too performative)

**What to Capture:**
1. Portrait in good natural light (near window, golden hour)
2. At a venue/place they actually go
3. Doing an activity they enjoy
4. With friends who can take candids
5. In their workspace (if interesting)

**Tips:**
- Natural light (near windows, outside)
- Take many, select few
- Candid often beats posed
- Ask a friend to take, not tripod/self-timer
- Capture real moments, not staged

---

## Ordering Logic

**Front-load strength:** Best photos first — both algorithm and human attention prioritize early photos. Users spend seconds on a profile (Brand et al., 2012), so the first 1-2 images carry disproportionate weight.

**Variety:** Each photo should add something different. Self-disclosure research (Gibbs et al., 2006) shows that breadth across multiple dimensions predicts higher attractiveness ratings — photos should cover different aspects of who this person is.

**Story arc:** Photos together should give sense of who this person is and what their life is like. This maps to the "warranting" principle (Ellison et al., 2006) — multiple specific, consistent signals build credibility.

**End strong:** Last photo should be memorable — humor, personality, conversation starter. The von Restorff effect means distinctive elements are remembered; closing with something unexpected creates lasting impression.

---

## Caption Strategy

On Hinge, every photo can have a prompt and caption. This means photo captions are roughly half of someone's total profile text. Leaving them empty wastes half your real estate — and on an app where text quality matters more than on purely swipe-based platforms (Sumter et al., 2017), that's a significant missed opportunity.

**The job of a photo caption:** The photo shows what you look like. The caption shows who you are. A photo of someone at a restaurant tells you nothing. A caption that says "I have opinions about this ramen" tells you something about their personality and gives you something to say.

**Photo captions should:**
- Add context the photo can't show (personality, humor, opinion)
- Create conversation hooks — something someone could easily comment on
- Show personality in the person's actual voice
- Be concise (the photo is doing the visual work; the caption adds the human layer)

**Don't:**
- Leave prompts empty (completeness affects both algorithm and perception)
- Just describe what's in the photo ("Me at the beach" — the viewer can see that)
- Be generic ("Good times!" — a cheap signal that says nothing)
- Waste the caption on a location tag alone — the location feature handles that

**The research context:** OkCupid data showed that messages referencing specific profile content got 30-40% more replies. A good photo caption gives someone that specific thing to reference. "Great photo" is a generic compliment; "Wait, is that the ramen place on Kingsland Road?" is a real conversation. The caption creates the hook that makes the photo a conversation starter instead of just a picture.
