# Hinge Settings Guide

Optimizing settings for visibility and quality matches.

---

## Distance Settings

### The Tradeoff
- **Too narrow:** Missing good people just outside radius
- **Too wide:** Matches from impractical distances, dilutes pool

### Recommendations by Context

| Situation | Suggested Radius |
|-----------|------------------|
| Major city (London, NYC) | 15-25 miles / 25-40 km |
| Suburban area | 25-50 miles / 40-80 km |
| Rural area | 50+ miles / 80+ km |
| Open to relocating | Maximum |

### Reality Check Questions
- "How far would you actually travel for a first date?"
- "Would you date someone who lives [X] away long-term?"
- "Are you getting enough people in your current radius?"

---

## Age Range Settings

### Common Mistakes
- Setting too narrow based on arbitrary numbers
- Not considering who actually fits their criteria
- Mismatch between stated preference and who they're attracted to

### Reality Check
- "What age range are you genuinely open to?"
- "Have your best past relationships/dates fit this range?"
- "Is this based on real preference or just what sounds right?"

### Market Reality (Heterosexual Dating)
- Men typically set wider ranges (often younger)
- Women in 40s competing with women in 30s for men in their age range
- Very narrow ranges dramatically shrink the pool
- Consider: does the person they're looking for actually date people their age?

**The research context:** Bruch & Newman (2018, *Science Advances*) analyzed ~200,000 users and found that most people pursue partners ~25% more desirable than themselves, desirability follows a power-law distribution, and women's desirability peaked earlier than men's in their dataset. This isn't about anyone's worth — it's about understanding the market you're operating in so settings don't accidentally filter out good matches.

---

## Dealbreakers

### What Hinge Offers
- Height
- Children (has/wants)
- Religion
- Smoking
- Drinking
- Drugs
- Politics
- Ethnicity
- Education

### Strategic Advice

**Be careful with:**
- Dealbreakers that filter on things that don't actually matter to them
- Multiple dealbreakers that compound to tiny pool

**Questions to ask:**
- "Is this actually a dealbreaker, or just a preference?"
- "Have you dated people outside this criterion happily?"
- "Is this filtering signal or actual incompatibility?"

**Example:** Setting "no smokers" when they'd actually date a social smoker filters people they might like.

---

## Profile Visibility Settings

### What's Visible at Top of Profile

Hinge shows certain info prominently. Some can be hidden.

**Consider hiding if not relevant:**
- Star sign (adds nothing for most, clutters profile)
- Height (if not a differentiator)
- Politics (if not crucial to filtering)
- Religion (if not practicing/important)

**Keep visible if:**
- It's a filtering mechanism they want active
- It's a positive differentiator
- It invites conversation

### The Clutter Problem

Every piece of info at top of profile competes for attention. If it's not adding value, it's taking space from things that do.

---

## Premium Features

### Hinge+ / HingeX

**If they have premium:**

- **See who liked you:** Can be strategic - prioritize people who already liked
- **Roses:** Use sparingly on standout profiles (limited resource = costly signal)
- **Advanced preferences:** More filtering options

**Roses strategy:**
- Don't spam roses
- Use on profiles where you'd actually want to stand out
- The scarcity is the point - it signals genuine interest

---

## Algorithm Optimization

### Activity Matters
- Daily activity (10-15 mins) keeps profile visible
- Extended inactivity = algorithm deprioritizes
- *Evidence tier: conventional wisdom. Hinge hasn't published specifics, but this is consistent with how recommendation systems work and is widely reported across dating coaching.*

### Engagement Quality
- Comments on likes significantly outperform bare likes — Hinge's own data says they're more likely to lead to conversations (Hinge press data, circa 2018-2019)
- Respond to matches promptly
- Extend conversations (not one-word answers)
- *Evidence tier: platform data for the comments claim. The rest is conventional wisdom.*
- *Why comments work (research): signaling theory (Donath, 2007) — a comment is a costly signal requiring effort, indicating genuine interest. A bare like is a cheap signal that communicates nothing specific.*

### Selectivity
- Being too selective may limit who the algorithm shows you to
- Being not selective enough means matches don't convert
- *Evidence tier: conventional wisdom. The "10-20% like rate sweet spot" is widely cited in dating coaching but has no published source. The principle (some selectivity signals quality) is plausible but unverified.*

### Most Compatible
- Check daily (refreshes every 24 hours)
- Hinge claims these are significantly more likely to result in dates (they've cited 8x in press materials around the 2018 feature launch). Uses the Gale-Shapley matching algorithm
- Algorithm learns from your choices here
- *Evidence tier: platform data — Hinge's own claim. The methodology behind the 8x figure has never been published.*

---

## Settings Checklist

Walk through before implementation:

### Distance
- [ ] Current setting: ___
- [ ] Appropriate for their situation?
- [ ] Discussed tradeoffs?

### Age Range
- [ ] Current setting: ___
- [ ] Realistic for market?
- [ ] Genuine preference or arbitrary?

### Dealbreakers
- [ ] Current dealbreakers: ___
- [ ] Each one actually a dealbreaker?
- [ ] Not over-filtering?

### Visible Info
- [ ] What's showing at top: ___
- [ ] Anything to hide? (clutter reduction)
- [ ] Anything to add/feature?

### Premium (if applicable)
- [ ] Has premium: Y/N
- [ ] Discussed roses strategy?
- [ ] Using "who liked you" feature?

---

## Implementation Notes

When adjusting settings:

1. **Make changes incrementally** - Don't change everything at once
2. **Give time to see effect** - Algorithm needs time to recalibrate
3. **Track what changes** - Note what settings were vs what they become
4. **Revisit after 2 weeks** - Assess if changes helped or hurt
