# Discovery Questions

Use conversationally, 3-4 questions per batch. Chase interesting threads. Skip what's not relevant.

## Why This Interview Works

The questions below look random. They're not. The interview is designed around what the research says makes profiles effective:

**We ask across many topics** because self-disclosure research (Gibbs et al., 2006) shows that breadth — covering humor, values, lifestyle, work, relationships — predicts higher attractiveness ratings. A profile that shows multiple dimensions of a person beats one that's all about one thing. We're gathering material for breadth.

**We push for specifics** because Toma & Hancock (2012) found that specific, concrete language is a linguistic marker of honesty, while vague language signals deception. Most people's first instinct is to generalise ("I love music"). Our job is to get past that to the real stuff ("Jazz Cafe on a weeknight"). Every question is angled to surface detail, not category.

**We're mining for costly signals** — things that are hard to fake, specific to this person, and credible because they require actual experience (Donath, 2007). The 92-year-old great uncle, the Saturday Kitchen hate-watch, the Timothée Chalamet opinion — these can't be mass-produced. Anyone can say "I love to laugh." Nobody else has these exact details.

**We batch 3-4 questions** because it feels like a conversation, not an interrogation. Sprecher et al. (2013) found that self-disclosure works best when it feels natural and reciprocal. Asking 20 questions at once kills the flow. Asking 3-4, following the interesting thread, then asking 3-4 more creates the right rhythm.

**We're looking for the Whitty balance** — Whitty (2008) found that the most effective profiles balance three tensions: idealisation vs authenticity, self-promotion vs warmth, distinctiveness vs appeal. Every question is testing: what's true about this person (authenticity) that's also interesting (distinctiveness) and relatable (appeal) and puts them in a good light (idealisation)?

---

## Framing

Before diving in:
> "I'll ask a bunch of questions — we won't use everything. Just gathering ingredients to see what we can build around. Skip anything you want."

---

## Work & Status

**The basics:**
- What do you do for work?
- How would you describe it to someone at a party?

**Digging deeper:**
- What's the most interesting project you've worked on?
- What would you never put in a bio but is actually impressive?
- Any clients/projects/achievements you're proud of?
- What do you actually love about what you do?

**For creatives/entrepreneurs:**
- What kind of work/clients do you focus on?
- What do you make that you're proud of?
- Anything tangible people could see?

---

## Personality & Opinions

**Specifics over generics:**
- What did you actually do last weekend?
- What's your Sunday usually look like?
- What are you weirdly into that most people don't know?

**Finding the opinions:**
- What do you irrationally love?
- What do you irrationally hate? (Gold for profiles)
- Any strong opinions on things most people don't care about?
- What's a hill you'll die on?

**The friend test:**
- What would your friends say is your "thing"?
- What do people always come to you for?
- How would your best friend describe you?

**Guilty pleasures:**
- Any hate-watches? Comfort shows?
- Guilty pleasure music?
- Things you enjoy that you "shouldn't"?

---

## Social & Warmth

**Relationships:**
- Who are you closest to?
- Tell me about your family setup
- Any unusual relationships? (Elderly relatives, unlikely friendships)
- Pets?

**Social style:**
- Big groups or small hangs?
- What's a typical hangout look like for you?
- Introvert, extrovert, depends?

---

## Lifestyle & Context

**Daily life:**
- Morning person or night owl?
- Cook or order in?
- Homebody or always out?
- How do you get around? (Walk, cycle, drive, tube)

**Places:**
- Neighborhoods you're always in?
- Regular spots? (Cafes, pubs, venues)
- Or more of an explorer - never same place twice?

**If they're location-specific:**
- What venues would someone who "gets it" know?
- Any insider spots?
- What makes your area/city yours?

---

## Cultural Interests

**Music:**
- What do you listen to?
- Last gig you went to?
- Any specific venues you love?
- Guilty pleasure music?

**Other cultural:**
- What do you read/watch/consume?
- Any regular cultural habits? (Gallery visits, cinema, theatre)
- Specific institutions you love?

---

## Dating Context

**What they want:**
- What are you actually looking for?
- Serious relationship, casual, open to seeing?
- What does "serious relationship" look like to you?

**What's gone wrong:**
- What's been frustrating about dating apps?
- What's the pattern with people you've matched with?
- What are you trying to avoid?

**The ideal:**
- What would a great first date look like?
- What would you actually do together?
- What qualities matter most?

---

## Target Market Questions

**Who they're hoping to attract:**
- What kind of person are you hoping will see this?
- Age range - what are you actually open to?
- Any deal breakers?
- What field/type/vibe?

**Reality check prep:**
- How specific are your criteria?
- How's it been going with that target?

---

## Finding the Unique Stuff

These often surface the best material:

- "What's something unusual about your life?"
- "What would surprise people about you?"
- "Any weird rituals or habits?"
- "What's the most niche interest you have?"
- "Anything in your life that's genuinely unique?"

---

## Following Threads

When something interesting comes up:

- "Tell me more about that"
- "How did that start?"
- "Why that specifically?"
- "Is that something that would go in a profile?"

---

## What You're Listening For

Each category maps to what the research says makes profiles work:

**Unique hooks** — The von Restorff effect: distinctive items are remembered, common ones forgotten. In a stack of 100 profiles, generic = invisible. You're listening for the thing nobody else could claim.
- Anything no one else would have
- Unusual relationships, hobbies, opinions
- Specific stories

**Costly signals** — Donath (2007): signals that are hard to fake are credible. You're listening for things that demonstrate qualities rather than claim them. "I make exhibition catalogues for galleries" demonstrates creativity. "I'm creative" claims it.
- Professional achievements framed humbly
- Evidence of an interesting life (not stated, but shown)
- Skills, knowledge, or access that's specific and verifiable

**Warmth markers** — Whitty (2008): profiles need warmth alongside distinctiveness. Pure edge reads as bitter. Warmth grounds a profile and signals relationship potential.
- Family connections (especially specific/unusual ones)
- Care for others
- Genuine enthusiasm (not performed enthusiasm)

**Personality markers** — Bressler & Balshine (2006): demonstrated humor is a signal of intelligence. Strong opinions are costly signals (they risk alienating people, which is what makes them credible). You're listening for the person's actual voice.
- Humor style (do they produce humor naturally in conversation?)
- Strong opinions (the irrational hatreds are gold)
- Quirks and pet peeves

**Cultural specificity** — Fiore & Donath (2005): homophily means people seek similarity. Specific cultural references sort for compatible matches. You're listening for the insider knowledge that would resonate with their target market.
- Venues, neighborhoods, artists, scenes
- Insider references
- Things their ideal match would recognise and light up at

---

## Notes Template

Use this to capture findings:

```
## Work/Status
- What they do:
- Interesting angle:
- Impressive but humble:

## Personality
- Humor style:
- Strong opinions:
- Pet peeves:
- Quirks:

## Unique Hooks
- (list anything distinctive)

## Warmth Markers
- Family:
- Friends:
- Care:

## Cultural Specificity
- Venues:
- Interests:
- Insider refs:

## Best Material for Profile
1.
2.
3.
```
