# Copy Principles

What makes profile copy work, with annotated examples. These principles aren't just style preferences — they're grounded in research on how people evaluate dating profiles.

---

## The Core Idea

Profile copy should:
1. Show who they actually are (not who they think they should be)
2. Give people something to respond to (conversation hooks)
3. Attract the right people AND repel the wrong ones (filtering)
4. Be memorable (stand out from thousands of generic profiles)

**The research basis:** Creative, original profiles are independently rated as more intelligent, funnier, and more attractive — even controlling for photos (Fiore et al., 2008). On relationship-focused apps like Hinge, text quality matters more than on purely swipe-based platforms (Sumter et al., 2017). And in a market where top profiles receive 10-100x the attention of median ones (Bruch & Newman, 2018), differentiation is survival.

---

## Principles

### 1. Specificity > Generic

Generic statements are forgettable and say nothing. Specific details show personality and create hooks.

**Why this works (research):** Toma & Hancock (2012) found that truthful, authentic profiles use more specific, concrete, sensory language — while deceptive profiles default to vague, abstract phrasing. Readers unconsciously detect this: specificity signals honesty. Separately, Construal Level Theory (Trope & Liberman, 2010) shows that concrete language creates psychological closeness — "Jazz Cafe on a weeknight" makes you feel like you're there, while "live music" keeps you at a distance. And Hitsch et al. (2010) showed that specific, verifiable lifestyle details produce significantly higher contact rates.

| Generic (Bad) | Specific (Good) |
|---------------|-----------------|
| "I love live music" | "Jazz Cafe on a weeknight" |
| "I like exploring the city" | "Walking everywhere with nowhere to be" |
| "I appreciate good food" | "Strong opinions about where to find the best ramen" |
| "I have a good sense of humor" | "I hate-watch Saturday Kitchen. Every week." |
| "Family is important to me" | "My 92-year-old great uncle could beat you at pub quiz" |

**The test:** Could 10,000 other people say the exact same thing? Then it's too generic.

### 2. Every Element = Conversation Hook

Every prompt answer should make it easy for someone to start a conversation.

**Why this works (research):** OkCupid's data (Rudder, *Dataclysm*, 2014) showed that messages referencing specific profile content had reply rates 30-40% higher than generic openers. Hinge's own data confirms the pattern: comments with likes significantly outperform bare likes. The mechanism is simple — a prompt that gives someone something to say gets comments; a prompt that's a closed statement doesn't. And on Hinge, comments are the primary signal of genuine interest.

**Good hooks invite:**
- Questions ("Wait, why do you hate him?")
- Shared opinions ("Oh my god I also hate that")
- Playful challenges ("I bet I could beat your uncle")
- Stories ("Tell me about that")

**Bad hooks are closed:**
- "I love my friends and family" (what do you say to this?)
- "Looking for someone genuine" (okay... and?)
- "Work hard play hard" (meaningless)

### 3. Filter In AND Filter Out

The goal isn't maximum likes - it's the right likes.

**Why this works (research):** Strong homophily effects in dating — people preferentially contact those similar on education, cultural tastes, and lifestyle markers (Fiore & Donath, 2005). Specific cultural references function as sorting mechanisms: insiders recognize them and feel affinity, while outsiders self-select out. In a power-law market where quality matches have abundant options (Bruch & Newman, 2018), you don't need volume — you need the right 30-50 people to remember you.

Good copy should:
- Make ideal matches think "yes, this person gets it"
- Make wrong matches think "not for me" (and that's good)

**Filtering mechanisms:**
- Niche references (insiders recognize, others don't)
- Strong opinions (compatible people agree, others bounce)
- Specific humor (right people laugh, wrong people confused)
- Cultural markers (signals belonging to particular worlds)

### 4. Balance Edge with Warmth

All edge = reads as bitter, negative, hard to be around
All warmth = reads as bland, generic, forgettable

**Why this works (research):** Humor significantly increases perceived attractiveness and is read as a signal of intelligence and social competence (McGee & Shevlin, 2009). But excessive self-deprecation reduces perceived confidence (Lundy, Tan & Cunningham, 1998). Self-disclosure research (Gibbs et al., 2006) shows the most effective profiles balance multiple dimensions — the optimal self-disclosure is moderate depth across breadth of topics. Edge (humor, opinions) signals personality; warmth (family, genuine care) signals relationship potential. You need both.

**The formula:** Dark humor or strong opinions PLUS genuine warmth markers

**Warmth markers:**
- Family connections (especially specific/unusual ones)
- Care for friends
- Genuine enthusiasm for things
- Vulnerability (appropriate level)
- Pets

### 5. Show, Don't Tell

Stating a quality is weak. Demonstrating it is strong.

**Why this works (research):** This maps directly to signaling theory. Donath (2007) distinguishes costly signals (hard to fake, therefore credible) from cheap signals (easy to fake, therefore ignored). Writing "I have dark humor" is a cheap signal — anyone can claim it. Writing "Being nice about Timothée Chalamet" is a costly signal — you have to actually be witty to produce it. Gibbs et al. (2006) confirmed this experimentally: profiles demonstrating personality through specific examples beat trait-adjective lists on honesty ratings, appeal, and contact rates.

| Telling (Weak) | Showing (Strong) |
|----------------|------------------|
| "I have dark humor" | "Being nice about Timothée Chalamet." |
| "I'm adventurous" | "Last month I took a train with no destination" |
| "I'm creative" | "I make exhibition catalogues for galleries" |
| "I value depth" | Reference to specific artists/thinkers/works |
| "I'm fun" | Specific story that demonstrates fun |

---

## Annotated Examples

### Example 1: The Opinion Hook

**Prompt:** "Together we can be terrible at"
**Answer:** "Being nice about Timothée Chalamet."

**Why it works:**
- Specific opinion (not generic)
- Polarizing = filters (fans swipe left, haters engage)
- Implies dark humor without stating it
- Instant conversation hook (everyone has a take)
- "Together" = collaborative framing, not solo bitterness
- Memorable (no one else has this exact take)

---

### Example 2: The Warmth + Uniqueness Combo

**Prompt:** "I'm convinced that"
**Answer:** "My 92-year-old great uncle could beat you at pub quiz. No offense."

**Why it works:**
- Completely unique (nobody else has this)
- Shows family warmth without being generic
- Playful challenge invites response
- "No offense" = dry wit
- Specific enough to be memorable
- Creates easy conversation starter

---

### Example 3: The Cultural Dog Whistle

**Prompt:** "My simple pleasures"
**Answer:** "Brutalist architecture and a good wander with nowhere to be."

**Why it works:**
- "Brutalist architecture" = design/architecture nerd filter
- Specific taste signals cultural engagement
- "Nowhere to be" = relaxed, not performatively busy
- Attracts: people who know what brutalism is
- Repels: people who need activities planned

---

### Example 4: The Guilty Pleasure Reveal

**Prompt:** "Don't judge me"
**Answer:** "I hate-watch Saturday Kitchen. Every week."

**Why it works:**
- Unexpected (not the usual guilty pleasures)
- Self-aware (knows it's ridiculous)
- Specific (not "cooking shows" but THIS one)
- British humor that resonates with right audience
- Easy conversation hook ("Who's your least favorite chef?")

---

### Example 5: The Cultural Insider

**Prompt:** "I go crazy for"
**Answer:** "Exhibition catalogues, Jazz Cafe on a weeknight, and people who walk everywhere."

**Why it works:**
- Three specific things (not generic categories)
- "Exhibition catalogues" = art world insider signal
- "Jazz Cafe" = specific venue, London cultural marker
- "People who walk everywhere" = lifestyle marker
- Each element filters for similar people

---

### Example 6: The Self-Deprecating Flex

**Prompt:** "Believe it or not"
**Answer:** "Literally my life. [Meme about career]. [Business name]: where corporate logos go to get slightly better."

**Why it works:**
- Uses humor to mention work without bragging
- Self-deprecating but confident
- Shows they don't take themselves too seriously
- Industry insider joke lands with right people
- Meme format = personality

---

## What to Avoid

### Generic Phrases (Everyone Says These)
- "Love to laugh"
- "Partner in crime"
- "Looking for my person"
- "Work hard play hard"
- "Living my best life"
- "Not here for hookups"
- "Love adventures"
- "Good vibes only"

### Closed Statements (No Hook)
- "Family and friends are important to me"
- "I value honesty"
- "Looking for something real"

### Negativity Without Balance
- "No time wasters"
- "If you can't handle me at my worst..."
- "Tired of games"
- Long lists of dealbreakers

### Vague Descriptors
- "Fun-loving"
- "Easygoing"
- "Down to earth"
- "Old soul"

---

## The Process

1. **Pull from discovery:** What specific details emerged?
2. **Find the unique:** What does no one else have?
3. **Create hooks:** How can each element start a conversation?
4. **Check filtering:** Who does this attract/repel?
5. **Balance tone:** Edge + warmth in right proportion
6. **Test specificity:** Could 10,000 people say this?
7. **Read aloud:** Does it sound like them?

---

## Character Limit

Hinge: 150 characters per prompt answer

Every word must earn its place. Cut ruthlessly.
