# Profile Audit Criteria

Use this framework to evaluate existing profiles. Score each category, identify critical issues.

---

## Overall Scoring

| Category | Weight | What to Assess |
|----------|--------|----------------|
| Photos | 40% | Quality, variety, first photo, red flags |
| Prompts | 30% | Completion, specificity, hooks, personality |
| Completeness | 15% | All slots filled, all prompts answered |
| Signaling | 15% | What the profile actually communicates |

**Why these weights:** Photos are weighted highest because research consistently shows they dominate swipe decisions (Tyson et al., 2016; Brand et al., 2012). Prompts at 30% reflects that on prompt-based apps like Hinge, text independently predicts attractiveness beyond photos (Fiore et al., 2008) and matters more to users seeking serious relationships (Sumter et al., 2017). Completeness is weighted because incomplete profiles likely get algorithmically deprioritized (platform data) and signal low effort — a cheap signal that repels quality matches (Donath, 2007). The exact percentages are a practical framework, not from a specific study.

---

## Photo Evaluation (40%)

### First Photo (Most Critical)
| Criteria | Score |
|----------|-------|
| Face clearly visible | /2 |
| Good lighting | /2 |
| Genuine expression/smile | /2 |
| Solo (not group) | /1 |
| Not a selfie | /1 |
| Clean background | /1 |
| Eye contact with camera | /1 |
| **First Photo Total** | **/10** |

### Photo Mix Assessment
| Photo Type | Present? | Quality |
|------------|----------|---------|
| Clear face opener | ☐ | /10 |
| Lifestyle/activity | ☐ | /10 |
| Social proof (with others) | ☐ | /10 |
| Full body | ☐ | /10 |
| Personality/interest | ☐ | /10 |
| Conversation starter | ☐ | /10 |

### Red Flag Check
- ☐ Mirror selfie (CRITICAL - delete immediately)
- ☐ Bathroom photo
- ☐ All selfies (no social proof)
- ☐ Group photo where subject unclear
- ☐ Sunglasses in most photos
- ☐ Heavy filters
- ☐ All same angle/pose
- ☐ Very old photos

**Each red flag = -1 point from photo score**

---

## Prompt Evaluation (30%)

### Completion Check
| Slot | Filled? | Has Text? |
|------|---------|-----------|
| Photo 1 prompt | ☐ | ☐ |
| Photo 2 prompt | ☐ | ☐ |
| Photo 3 prompt | ☐ | ☐ |
| Photo 4 prompt | ☐ | ☐ |
| Photo 5 prompt | ☐ | ☐ |
| Photo 6 prompt | ☐ | ☐ |
| Written prompt 1 | ☐ | ☐ |
| Written prompt 2 | ☐ | ☐ |
| Written prompt 3 | ☐ | ☐ |

**Completion rate:** ___/9 (should be 9/9)

### Quality Assessment (Each Prompt)

| Criteria | Points |
|----------|--------|
| Specific (not generic) | +2 |
| Creates conversation hook | +2 |
| Shows personality | +2 |
| Filters for right people | +1 |
| Appropriate length | +1 |
| Memorable/unique | +2 |
| **Max per prompt** | **/10** |

### Generic Phrase Penalties
Deduct points for:
- "Love to laugh" (-2)
- "Partner in crime" (-2)
- "Looking for my person" (-1)
- "Work hard play hard" (-2)
- "Not here for hookups" (-1)
- "Ask me anything" (-1)
- Lists of generic hobbies (-1)

**Why generic phrases are penalized:** Toma & Hancock (2012) found that vague, abstract language is a linguistic marker of deception — readers unconsciously process it as less trustworthy. Separately, the von Restorff effect (cognitive psychology) means distinctive items in a set are remembered while common items are forgotten. When someone scrolls through hundreds of "love to laugh" profiles, generic phrasing makes you invisible.

---

## Completeness (15%)

| Element | Complete? |
|---------|-----------|
| All 6 photo slots used | ☐ |
| All photo prompts have text | ☐ |
| All 3 written prompts filled | ☐ |
| Bio/basics completed | ☐ |
| Preferences set | ☐ |

**Score:** Count of complete items × 2 = /10

---

## Signaling Analysis (15%)

This section uses signaling theory (Donath, 2007) — the idea that some profile elements are "costly signals" (hard to fake, therefore credible) and others are "cheap signals" (easy to fake, therefore ignored by discerning matches).

### What Does This Profile Actually Communicate?

**Intended signals** (what they want to say):
- [ ] List what they're trying to convey

**Actual signals** (what it really says):
- [ ] List what the profile actually communicates

### Signal Quality Check

| Costly Signals (Good) | Present? | Notes |
|-----------------------|----------|-------|
| Effort invested (quality photos, thoughtful text) | ☐ | Signals genuine interest in finding someone |
| Specific cultural/venue references | ☐ | Requires actual participation — credible |
| Demonstrated personality (humor, opinions) | ☐ | Hard to fake — shows real person |
| Professional/creative evidence | ☐ | Verifiable status signal |
| Relationship intent (specific, not generic) | ☐ | "Looking for" is cheap; showing warmth is costly |

| Cheap Signals (Problematic) | Present? | Notes |
|-----------------------------|----------|-------|
| Low effort (empty prompts, basic selfies) | ☐ | Signals low investment in finding someone |
| Vague/generic claims ("love to laugh") | ☐ | Anyone can say this — zero information |
| Hiding (sunglasses, heavy filters, no full body) | ☐ | Signals deception, even if unintentional |
| Inconsistent tone | ☐ | Confuses the reader about who this person is |
| Negative/bitter framing | ☐ | Signals bad past experiences, not ready to date |

---

## Competitive Position

This matters more than most people realise. Bruch & Newman (2018) found that attention on dating apps follows a power law — the top profiles receive 10-100x more messages than median ones. Hitsch et al. (2010) found that users with the most desirable profiles are also the most selective and the most sensitive to profile quality. The people you want to attract are the people most likely to notice the difference between a good profile and a forgettable one.

### Target Market Alignment
- Who are they trying to attract?
- Does the profile appeal to that demographic specifically, or is it aimed at everyone (which means no one)?
- What would make their target market stop scrolling?
- What cultural markers, tone, or references would resonate with that specific audience?
- What's currently missing that their target market would want to see?

### Differentiation
- What makes this profile different from thousands of others?
- Does it contain any costly signals (Donath, 2007) — things that are specific, hard to fake, and demonstrate actual qualities?
- Or is it all cheap signals — generic claims, basic selfies, vague descriptors?
- Apply the 10,000 people test: could 10,000 other people have this exact profile? If yes, it's invisible.
- Would someone remember this profile tomorrow?

---

## Final Score Calculation

| Category | Weight | Score | Weighted |
|----------|--------|-------|----------|
| Photos | 40% | /10 | |
| Prompts | 30% | /10 | |
| Completeness | 15% | /10 | |
| Signaling | 15% | /10 | |
| **Total** | | | **/10** |

### Score Interpretation

| Score | Assessment |
|-------|------------|
| 8-10 | Strong profile, minor optimization |
| 6-7 | Good foundation, clear improvements needed |
| 4-5 | Significant issues, major revision needed |
| 1-3 | Critical problems, full rebuild recommended |

---

## Delivering the Audit

**Lead with positives:**
- "Here's what's working..."
- Find something genuinely good, even if small

**Frame gaps as opportunities:**
- "Here are the opportunities..." not "Here's what's wrong"
- Be honest but kind

**Prioritize:**
- Identify the 3 most impactful changes
- Don't overwhelm with everything at once
