# Hinge Dating Profile Optimizer

**A Claude Skill — research-backed profile optimization in 45 minutes**

<p align="center">
  <img src="claude-bots-love.svg" alt="Two Claude bots in love" width="280">
</p>

---

Everyone has something. The way they think, what they care about, their weird specific interests, how they show up for people, what makes them laugh.

Most dating profiles bury this under generic prompts and bad photo choices.

This skill finds it and puts it where people can see it.

---

## Time

**45 minutes.**

Not a quick fix. Not "5 tips for better prompts."

This is the full process: honest audit, proper interview, photo strategy, copy that sounds like you, settings cleanup, and help putting it live.

It's a small time cost to meet your life partner. Or your weekend 9/10 hookup. We don't judge.

---

## This Isn't Copy-Paste Advice

Most "profile tips" give you a template and send you on your way. Generic prompts, generic results.

This is a **structured 8-phase process** that actually gets to know you first:

| Phase | What Happens |
|-------|--------------|
| [Setup](SKILL.md#phase-0-setup--framing) | Frame the process, understand your situation |
| [Audit](references/audit-criteria.md) | Score your current profile (skip if starting fresh) |
| [Discovery](references/discovery-questions.md) | The big interview - find what actually makes you *you* |
| [Reality Check](SKILL.md#phase-3-reality-check) | Honest market math - who are you competing for? |
| [Photos](references/photo-guidelines.md) | Evaluate, order, identify gaps |
| [Copy](references/copy-principles.md) | Write prompts using *your* material, not templates |
| [Settings](references/hinge-settings.md) | Optimize visibility, hide the clutter |
| [Implementation](SKILL.md#phase-7-implementation) | Put it live together |
| [Algorithm](SKILL.md#phase-8-algorithm-strategy) | What to do in weeks 1-4 |

**Why it works:** The discovery phase is the key. Most advice is generic because it doesn't know you. This spends real time understanding your humor, opinions, relationships, weird rituals — then uses those as ingredients. Your 92-year-old great uncle who dominates pub quiz? That's going in the profile.

---

## The Research

This isn't vibes. It's grounded in published research from actual journals, data from dating platforms, and practical experience — and we're honest about which is which.

**People decide fast, and mostly from photos.** Users spend seconds on a profile, and most of that time goes to photos (Brand et al., 2012). Photos drive the swipe. But on prompt-based apps like Hinge, text matters more than people assume — creative, original profiles are independently rated as more attractive, even controlling for photos (Fiore et al., 2008).

**Specific language beats generic language.** This is one of the strongest findings. "Jazz Cafe on a weeknight" works better than "live music" — and we know why. Toma & Hancock (2012) found that specific, concrete language is a linguistic marker of honesty. Vague, abstract phrasing is a marker of deception. Readers pick up on this without knowing they're doing it. Separately, specific language creates a feeling of closeness — naming a real place puts someone there, while a category keeps them at arm's length (Trope & Liberman, 2010).

**Showing beats telling.** Writing "I have dark humor" tells people nothing — anyone can claim any trait. Writing "Being nice about Timothee Chalamet" demonstrates it. Signaling theory (Donath, 2007) explains the difference: a demonstrated quality is a costly signal — hard to fake, therefore credible. A stated quality is a cheap signal — easy to fake, therefore ignored.

**Humor works, but only if you're actually funny.** Humor in profiles increases perceived attractiveness and reads as a signal of intelligence (McGee & Shevlin, 2009). Producing humor matters more than claiming to appreciate it (Bressler & Balshine, 2006). Failed humor is worse than no humor.

**The market is unequal.** Bruch & Newman (2018), published in *Science Advances*, analyzed 200,000 users and found that desirability follows a power law. Most people pursue partners roughly 25% more desirable than themselves. The top profiles receive wildly disproportionate attention. This is why the skill focuses on differentiation and filtering rather than broad appeal — you're not trying to be liked by everyone.

29 cited studies, platform data from Hinge and OkCupid, plus foundational work on signaling theory and self-disclosure. Every claim tagged with its evidence tier. Full citations in [`references/research-findings.md`](references/research-findings.md).

---

## How to Use This

### Option 1: Claude Desktop (Recommended)

Best option for most people. Once installed, Claude keeps the skill loaded across every conversation — you can come back tomorrow, next week, or after a bad date without re-uploading anything.

**Step 1: Download the files**

1. Click the green **Code** button at the top of this page
2. Click **Local**
3. Click **Download ZIP**
4. Find the ZIP in your Downloads folder and unzip it (double-click on Mac, right-click → Extract on Windows)
5. You now have a folder called `hinge-profile-optimizer-main`

**Step 2: Add to Claude Desktop**

1. Open **Claude Desktop** (the app, not the browser)
2. Click the **⚙️ Settings** icon (bottom left)
3. Click **Projects** in the sidebar
4. Click **+ Create Project** and name it something like "Hinge Profile Help"
5. Once inside your project, look for **Project Knowledge** or the **📎 Add Content** button
6. Add these files from the folder you downloaded:
   - `SKILL.md` (the main skill — add this first)
   - Everything inside the `references/` folder (7 files)

**Step 3: Start chatting**

Just say: *"Help me optimize my Hinge profile"*

Claude now has the full process and will guide you through it.

---

### Option 2: SkillsMP

This skill is listed on [SkillsMP](https://skillsmp.com/skills/b1rdmania-hinge-profile-optimizer-skill-md). One-click install if you're already on the platform.

---

### Option 3: Claude.ai in Browser

Don't have Claude Desktop? You can do this directly at [claude.ai](https://claude.ai).

1. Download the files using the **Code → Local → Download ZIP** button above
2. Start a new chat at [claude.ai](https://claude.ai)
3. Click the **📎 attachment** icon and upload `SKILL.md` plus the files from the `references/` folder
4. Tell Claude you want to optimize your Hinge profile

**Note:** You'll need to re-upload the files each time you start a new conversation. Desktop (Option 1) is better if you want to come back to this over multiple sessions.

---

### Option 4: Claude Code

If you're already using Claude Code, you know what to do.

---

## Philosophy

**You're not making someone more appealing. You're making them visible.**

The interesting stuff is already there. A 92-year-old great uncle who's a pub quiz champion. An irrational hatred of a specific celebrity. A hate-watch ritual every Saturday morning. The exhibition catalogue they're prouder of than anything else they've made.

These details get lost in "love to laugh" and "partner in crime."

This process pulls them out.

---

## The Point

There's someone for everyone. They just can't find each other when every profile says the same thing.

This skill helps people show who they actually are to the people who'd appreciate that person.

---

## License

MIT
