---
name: Hindi
description: Write Hindi that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Hindi is technically correct but sounds off. Too शुद्ध (pure). Too formal. Natives mix Hindi-English (Hinglish) and use casual registers. Match that.

## Formality Default

Default register is too high. Casual Hindi is warm and direct. Unless explicitly formal: lean casual. आप is not always needed. तुम/तू with peers is natural.

## तुम vs आप

Critical distinction:
- आप: elders, strangers, formal respect
- तुम: friends, peers, casual respect
- तू: very close friends, family, intimate (or rude if wrong context)
- Online peers usually use तुम

## Hinglish is Natural

Native Hindi speakers mix English constantly:
- "यार, वो movie बहुत amazing थी"
- "Actually, मुझे लगता है..."
- "Let me know करना"
- Pure Hindi without English = overly formal, artificial

## Fillers & Flow

Real Hindi has fillers:
- यार, अरे, अच्छा
- बस, वो, मतलब
- असल में, सच में
- हाँ तो, तो फिर

## Particles & Emphasis

Natural emphasis patterns:
- ही: emphasis ("यही चाहिए")
- तो: "so, then" ("तो फिर चलते हैं")
- ना: seeking agreement ("अच्छा है ना?")
- भी: "also, even" 

## Casual Shortcuts

Spoken patterns:
- क्या हुआ → क्या हुआ यार
- कुछ नहीं → कुछ नी
- रहा है → रहा है ना
- Use है ना? frequently

## Expressiveness

Don't pick the safe word:
- अच्छा → बढ़िया, मस्त, झक्कास, कमाल
- बुरा → बेकार, घटिया, बकवास
- बहुत → बोहोत, काफी, एकदम

## Common Expressions

Natural expressions:
- चलता है, कोई बात नहीं
- क्या बात है!, बहुत बढ़िया!
- हाँ हाँ, ठीक है ठीक है
- अरे वाह!, क्या scene है!

## Reactions

React naturally:
- सच में?, अच्छा?, पक्का?
- अरे वाह!, OMG!, क्या!
- हाहाहा, lol, 😂
- यार!, भाई!

## Regional Flavors

If region known:
- Mumbai: भाई, बोले तो, टपोरी style
- Delhi: यार, बे, दिल्ली वाली attitude
- UP/Bihar: का हो, रउआ, भोजपुरी influence
- Stay consistent

## Script Flexibility

Be consistent within message:
- Devanagari: नमस्ते, कैसे हो
- Roman: namaste, kaise ho
- Both are valid, don't mix randomly

## The "Native Test"

Before sending: would an Indian screenshot this as "AI-generated"? If yes—too शुद्ध, no English mixing, too formal. Add Hinglish.
