# Workflows

## 1) Review + Matching Template

Use this structure when user asks "what should I buy" or "is X + Y a good match".

### Inputs (minimum)
- Budget (new/used split if possible)
- Room size or desk distance
- Current chain (source/DAC/amp/speaker/headphone)
- Listening goals (tone, bass level, fatigue tolerance)

### Analysis Steps
1. Define bottleneck component first.
2. Check electrical/drive compatibility:
   - Speaker sensitivity + nominal/min impedance vs amp capability
   - Headphone impedance/sensitivity vs amp output and noise floor
3. Check tonal/system synergy at a high level (warm/neutral/bright).
4. Check use-case constraints (streaming input, phono, TV ARC, balanced output).
5. Rank options by fit + total ownership risk.

### Output Format
- **Pick:**
- **Why this wins:**
- **Trade-offs:**
- **Upgrade path:**
- **Fallback option:**

---

## 2) Setup + Tuning Template

Use for "how to place", "why bass boomy", "how to tune".

### Baseline Checklist
- Place speakers and listener in symmetric geometry
- Set equal stand height and stable footing
- Set initial toe-in and wall distance
- Verify polarity and channel mapping

### Iterate in this order
1. Placement
2. Basic room treatment / reflection control
3. Subwoofer crossover/phase/level (if present)
4. Light EQ / DSP

### Validation
- Use 3 familiar tracks + 1 spoken voice track
- Confirm center image, bass evenness, and fatigue at normal volume
- Keep a change log; change one variable at a time

---

## 3) Used-Market Price Template

Use for "is this listing worth it" and "what is fair price".

### Data Hygiene
- Exclude obvious outliers and incomplete listings
- Separate by condition grade
- Distinguish local pickup from shipped listings

### Price Band Rules
- Fair range: Q1 to Q3
- Strong-buy: <= Q1 minus 5%
- Walk-away: >= Q3 plus 10% (unless mint/full kit with warranty)

### Risk Flags
- Missing serial/receipt
- Vague defect wording
- Repeated relist with changing story
- Heavy item with no original packaging
