# Helsinki Visitor Tips

## Essential Knowledge

### Payment
- **Cash rarely needed** - Cards accepted everywhere, even for EUR 1
- **Contactless**: Widely supported
- **Currency**: Euro (EUR)
- **Tipping**: Not expected, service included. Round up if excellent.

### Language
- **English**: Spoken excellently by almost everyone
- **Finnish**: Appreciated but not expected
- **Useful words**: Kiitos (thanks), Moi (hi/bye), Anteeksi (excuse me)

### Safety
- **Very safe**: Walk anywhere, any time
- **Petty crime**: Rare, use normal precautions
- **Emergency**: 112 (EU-wide)

### Connectivity
- **WiFi**: Free in cafes, libraries, hotels
- **EU roaming**: No extra charges for EU SIMs
- **Public WiFi**: Helsinki City free network in center

## Getting Around

### HSL App (Essential)
- Download before arriving
- Buy tickets, plan routes, real-time info
- Works offline once downloaded

### Transport Zones
| Zone | Coverage | Single (80 min) | Day Pass |
|------|----------|-----------------|----------|
| AB | Helsinki proper | EUR 2.95 | EUR 9.50 |
| ABC | + Vantaa Airport | EUR 4.10 | EUR 12.00 |
| ABCD | + Espoo edges | EUR 5.70 | EUR 14.50 |

### Getting from Airport
- **Train (best)**: 30 min to Central Station, EUR 4.10
- **Bus 615**: Slower, same price
- **Taxi**: EUR 45-55, unnecessary
- **Airport train runs**: 5:00-24:00

### Trams
- Yellow/green trams, 13 lines
- **Tram 2 and 3**: Tourist-friendly loops
- Board any door, validate HSL ticket

### Metro
- Two lines: North-South and West
- Clean, efficient, limited coverage
- Useful for: Kallio, Itaekeskus, Espoo (Tapiola)

### Ferries
- **Suomenlinna**: Every 15-20 min from Market Square
- **Included in HSL ticket** (zone AB)
- **JT-Line**: Private waterbus, scenic route, EUR 7

### Cycling
- **City bikes**: Apr-Oct, EUR 5/day or HSL integration
- **Safe**: Good bike lanes
- **Helmet**: Recommended, not required

## Weather Preparation

### Winter (Nov-Mar)
- **Layers**: Thermal base, wool middle, windproof outer
- **Footwear**: Waterproof, grippy soles (ice!)
- **Accessories**: Warm hat, gloves, scarf
- **Indoor options**: Plan museum days for worst weather

### Summer (Jun-Aug)
- **Light layers**: Temperature varies 15-25 deg C
- **Rain jacket**: Showers common
- **Sunscreen**: Long days, reflection off water

### Spring/Fall
- **Unpredictable**: Prepare for both warm and cold
- **Waterproof shoes**: Melting snow, rain

## Money Saving

### Free Activities
- Oodi Library - Architecture, facilities, views
- Suomenlinna ferry ride (with HSL day pass)
- Walking the Design District
- Parks: Esplanadi, Kaivopuisto
- Window shopping on Esplanadi
- Many museum free days (check schedules)

### Budget Food
- Lunch specials (lounas): EUR 10-14, often includes salad bar
- Supermarket picnics: S-Market, K-Market, Alepa
- Market halls: Cheaper than restaurants
- Student cafes (if you look young): EUR 3-6

### Transport Savings
- Walk: City is compact
- Day passes if 3+ trips
- Bike rental in summer

### Helsinki Card
- 24/48/72 hour options
- Includes: Public transport, many museums, discounts
- Worth it if: Many museums + public transport
- Not worth if: Focus on free attractions, walking

## Food and Drink Tips

### Must Try
- **Salmon soup** (lohikeitto): Creamy, satisfying
- **Karelian pie** (karjalanpiirakka): Rice-filled pastry with egg butter
- **Reindeer**: At Old Market Hall or restaurants
- **Cinnamon roll** (korvapuusti): Every cafe
- **Salmiakki**: Salty licorice, acquired taste

### Coffee Culture
- Finns drink most coffee per capita globally
- Long coffee breaks are cultural
- Filter coffee (kahvi) standard
- Good chains: Fazer Cafe, Johan & Nystrom

### Alcohol
- **Beer/wine**: Supermarkets until 21:00
- **Spirits**: Only at Alko stores (close 18:00-20:00)
- **Age**: 18 for beer/wine, 20 for spirits
- **Prices**: High, EUR 7-10 for beer in bars

### Restaurant Tips
- **Lunch (11:00-14:00)**: Best value, set menus
- **Dinner**: More expensive, book ahead for popular spots
- **Service charge**: Included, no tipping expected
- **Water**: Free tap water at restaurants (just ask)

## Day Trips

### Porvoo (Easy)
- 50 min by bus from Kamppi
- Charming old town, red wooden houses
- Half day minimum, full day ideal
- Good lunch options

### Nuuksio National Park (Easy)
- 45 min by bus from Helsinki
- Hiking trails, lakes, forests
- Pack lunch, limited facilities
- See Finnish nature properly

### Tallinn, Estonia (Full Day)
- 2 hour ferry each way
- Book early: Viking Line, Tallink Silja
- Medieval old town, different country
- Cheaper food and drinks than Helsinki

### Turku (Full Day or Overnight)
- 2 hour train
- Former capital, castle, cathedral
- Gateway to archipelago
- Worth overnight if time

## Cultural Notes

### Sauna Etiquette
- **Naked is normal**: Mixed saunas rare, usually gender-separated
- **Swimwear**: Only in tourist/hotel saunas
- **Shower before**: Always
- **Temperature**: 70-100 deg C typical
- **Loyly**: Throwing water on stones, creates steam
- **Cool down**: Between rounds, swim or cold shower
- **Quiet**: Sauna is for relaxation, not loud chat

### Finnish Behavior
- **Silence is fine**: Do not fill pauses with small talk
- **Personal space**: More than other cultures
- **Punctuality**: Be on time, always
- **Queuing**: Take a number, wait your turn
- **Eye contact**: Limited, not rude

### Shopping Hours
- **Weekdays**: 9:00/10:00 to 20:00/21:00
- **Saturday**: 10:00 to 18:00
- **Sunday**: Limited, malls open 12:00-18:00
- **Alko (alcohol)**: Closes earlier

## Best Time to Visit

| Period | Pros | Cons |
|--------|------|------|
| Jun-Aug | White nights, outdoor life, festivals | Busy, most expensive |
| Dec | Christmas markets, cozy | Very dark, cold |
| Sep-Oct | Fall colors, fewer tourists | Weather unpredictable |
| Apr-May | Spring awakening, Vappu | Melting, muddy |
| Jan-Feb | Cheapest, winter sports | Dark, very cold |
