# Finland Visas and Residence Permits

## Who Needs What

| Status | Short Visit | Living/Working |
|--------|-------------|----------------|
| EU/EEA/Swiss | No visa | Register after 90 days |
| Schengen visa country | Yes | Residence permit |
| Visa-free country | No (90 days) | Residence permit |
| Other | Yes | Residence permit |

## EU/EEA Citizens

### Rights
- No visa needed
- Can work immediately
- Can study immediately
- Can stay indefinitely

### Registration
After 90 days, register right of residence:
- At DVV (Maistraatti)
- Simple process
- Bring ID, proof of employment/study/funds

### Family Members
Non-EU family can get residence card:
- Based on EU citizen's rights
- Apply at Migri
- Faster processing than regular permits

## Non-EU Citizens

### Short Visits (Under 90 Days)

**Schengen visa required for some countries.**

Check if you need visa: um.fi/visa-requirement

**Visa-free countries:**
- USA, Canada, Australia
- Japan, South Korea
- Many others (90 days in 180)

### Residence Permits

**Required for stays over 90 days.**

Types:
- Work-based
- Study-based
- Family-based
- Startup
- Other (research, etc.)

## Work-Based Permits

### Specialist Residence Permit

**Most common for tech workers.**

**Requirements:**
- Job offer from Finnish employer
- Relevant qualifications
- Salary at market level

**Process:**
1. Employer registers at Enter Finland
2. Applicant submits application
3. TE Office assesses labor market
4. Migri decides

**Timeline:** 1-4 months

**Validity:** Usually 1-2 years, renewable

### EU Blue Card

**For highly qualified workers.**

**Requirements:**
- Higher education degree (3+ years)
- Job contract 1+ year
- Salary min EUR 5,296/month gross (2026)

**Benefits:**
- Faster permanent residence
- EU-wide mobility rights
- Family reunion easier

**Timeline:** 1-3 months

### Intra-Company Transfer (ICT)

For transfers within multinational companies.
- Manager, specialist, or trainee
- Employed by company 3-12 months before
- Valid up to 3 years

## Startup Permit

**For entrepreneurs starting business in Finland.**

### Requirements
- Innovative business idea
- Evaluated by Business Finland
- Sufficient funds
- Business plan

### Process
1. Apply to Business Finland for evaluation
2. Positive evaluation received
3. Apply for residence permit at Migri
4. Permit granted

### Validity
- Initial 2 years
- Renewable based on business progress

### Benefits
- Can work only on your startup
- Path to permanent residence
- Support ecosystem access

## Student Permits

### Requirements
- Accepted to Finnish institution
- Health insurance
- Sufficient funds (EUR 560/month)
- Tuition paid (if applicable)

### Process
1. Get acceptance letter
2. Apply at Migri
3. Processing 1-3 months

### Benefits
- Can work 25h/week during term
- Full-time during holidays
- Path to post-study work permit

### After Studies
- Extended permit to find work (2 years)
- Can switch to work permit

## Family Permits

### Types
- Spouse of Finnish citizen
- Spouse of residence permit holder
- Child of resident
- Parent of Finnish minor

### Requirements vary by type
Generally:
- Proof of relationship
- Income requirements
- Housing requirements

### Processing: 4-12 months

## Application Process

### Where to Apply

**Outside Finland:**
- Finnish embassy/consulate
- VFS Global centers
- Online via Enter Finland

**Inside Finland:**
- Migri service points
- Online via Enter Finland
- Only if legally present

### Enter Finland Portal

**enterfinland.fi**

- Create account
- Submit application online
- Upload documents
- Pay fee
- Track status

### Required Documents (Typical)

| Document | Notes |
|----------|-------|
| Passport | Valid 3+ months beyond stay |
| Photo | Recent, passport-style |
| Application form | Online or PDF |
| Employment contract | For work permit |
| Degree certificates | Authenticated |
| CV | Work history |
| Insurance | Sometimes required |
| Proof of funds | Bank statements |
| Fee | Varies by type |

### Fees (2026)

| Permit Type | Online | Paper |
|-------------|--------|-------|
| Employee/Specialist | EUR 470 | EUR 650 |
| EU Blue Card | EUR 470 | EUR 650 |
| Startup | EUR 470 | EUR 650 |
| Student | EUR 350 | EUR 450 |
| Family | EUR 470 | EUR 650 |

## Processing Times

| Type | Typical Time |
|------|--------------|
| Specialist | 1-4 months |
| EU Blue Card | 1-3 months |
| Student | 1-3 months |
| Family | 4-9 months |
| Startup | 2-4 months |

**Factors affecting time:**
- Application completeness
- Background checks
- Labor market test (some permits)
- Current workload

## Living in Finland During Application

### Can You Stay?

**If applied inside Finland:**
- Can stay while processing
- May work if previous permit allowed

**If applied outside:**
- Must wait for decision
- Some fast-track options

### First Permit vs Renewal

**First permit:** Usually from abroad or with valid status
**Renewal:** Apply before current expires, can stay while processing

## Path to Permanent Residence

### Continuous Residence Permit (A)

After 4 years of continuous A-permit residence:
- Apply for permanent (P) permit
- Finnish language requirement (basic level)
- No major criminal record
- Sufficient income

### Finnish Citizenship

After permanent residence or 5+ years continuous A-permit:
- Language requirement (intermediate)
- Integration requirement
- No major issues
- Dual citizenship allowed

## Practical Tips

### Speed Up Processing

- Apply online (faster than paper)
- Complete documentation first attempt
- Use fast-track if eligible
- Respond quickly to requests

### Common Mistakes

- Incomplete documentation
- Wrong permit type
- Missing authentication/apostille
- Insufficient funds proof
- Late renewal

### After Arrival

1. Register residence at DVV
2. Get Finnish ID number
3. Register address
4. Apply for Kela
5. Open bank account

## Resources

- **Migri** (migri.fi): Immigration authority
- **Enter Finland** (enterfinland.fi): Application portal
- **InfoFinland** (infofinland.fi): Living in Finland guide
- **TE Services**: Labor market info
- **Finnish missions**: Consulates, embassies
