# Helsinki Transport

## HSL Overview

**HSL (Helsingin seudun liikenne)** operates all public transport in Helsinki region.

**Coverage**: Helsinki, Espoo, Vantaa, Kauniainen + nearby municipalities

**Modes**: Metro, trams, buses, commuter trains, ferries

## Zone System

| Zone | Coverage | Single (80 min) | Day | Month |
|------|----------|-----------------|-----|-------|
| AB | Helsinki proper | EUR 2.95 | EUR 9.50 | EUR 62.70 |
| ABC | + Vantaa, airport | EUR 4.10 | EUR 12.00 | EUR 74.00 |
| BC | Espoo/Vantaa focus | EUR 4.10 | EUR 12.00 | EUR 74.00 |
| ABCD | Full region | EUR 5.70 | EUR 14.50 | EUR 88.70 |

**Children 7-17**: Half price
**Under 7**: Free

## HSL App (Essential)

**Download immediately.** Does everything:
- Route planning
- Real-time arrivals
- Ticket purchase
- Mobile ticket display

**Tips:**
- Works offline for planning
- Save home/work locations
- Enable notifications for disruptions

## Metro

### Network
Two lines forming Y-shape:
- **West**: Matinkylae (Espoo) through center
- **East**: Vuosaari through center
- Common section through city center

### Key Stations
| Station | Connects To |
|---------|-------------|
| Rautatientori | Central Railway Station |
| Kamppi | Bus terminal, shopping |
| Hakaniemi | Kallio neighborhood |
| Ruoholahti | Tech offices, ferries |
| Soernaeinen | Kallio bars, sports |
| Tapiola | Espoo center |
| Keilaniemi | Nokia, business |

### Hours
- Mon-Sat: ~5:30-23:30
- Sunday: ~6:30-23:30
- Night buses replace metro late night

### Frequency
- Rush hour: 3-5 minutes
- Off-peak: 5-10 minutes
- Weekends: 8-10 minutes

## Trams

### Network
13 lines covering central Helsinki. Iconic yellow/green vehicles.

### Useful Lines
| Line | Route | Useful For |
|------|-------|------------|
| 2 | Circular | City tour, major sights |
| 3 | Circular (opposite) | City tour alternative |
| 4/4T | Munkkiniemi-Katajanokka | East-west cross-city |
| 6/6T | Arabia-Hietaniemi | Design district |
| 9 | Jaetkasaari-Pasila | Western suburbs |

### Tips
- Board any door, validate ticket
- Very reliable
- Good in all weather
- Scenic way to see city

## Buses

### Network
Extensive coverage where metro/tram do not reach.

**Types:**
- Regular buses: Normal routes
- Trunk buses (500-series): High frequency main routes
- Regional buses: Espoo, Vantaa connections

### Key Routes
| Route | Purpose |
|-------|---------|
| 615/617 | Airport (budget alternative to train) |
| 550 | Trunk line east-west |
| 560 | Trunk line north-south |

### Tips
- Enter front door, validate
- Request stop with button
- Night buses (N-series) late hours

## Commuter Trains

### Network
Four lines radiating from Helsinki Central Station:
- **A, E, U, L**: Northern suburbs
- **Y, S, X**: Northern/western connections
- **I, P**: Ring line (connects to airport)

### Key for Commuters
- Fastest to Espoo (Leppaevaara)
- Only rail to airport
- Tikkurila, Pasila connections

### Airport Train
- Lines I and P connect to airport
- 30 minutes Central Station to Airport
- Zone ABC ticket required (EUR 4.10)

## Ferries

### Suomenlinna Ferry
- From Market Square
- Every 15-20 minutes
- Included in HSL ticket
- 15-minute crossing

### Other Ferries
- Vallisaari, other islands (summer)
- JT-Line (private, scenic route to Suomenlinna)
- Commuter ferries to eastern islands

## City Bikes

### System
**Helsinki City Bikes** (operated by HSL)

### Season
April/May to October (weather dependent)

### Pricing (2026)
- Day pass: EUR 5
- Season pass: EUR 35
- 30 minutes free per trip, then fees

### Coverage
Stations throughout Helsinki and Espoo
- Not Vantaa
- Dock-to-dock system

### Tips
- Great for summer commutes
- Check bike condition before taking
- Return to any station
- App shows availability

## Driving

### Need a Car?
**Most residents do not need a car.** Public transport excellent.

**Consider car if:**
- Living in far suburbs
- Regular trips to cottage (moekki)
- Family with multiple activities
- Work outside metro area

### If You Do Drive
- Finnish license or IDP required (non-EU)
- EU licenses valid
- Studded tires required in winter (Dec-Feb)
- Parking expensive in center (EUR 4-6/hour)

See `driving.md` for full details.

## Taxis and Ride-Hailing

### Apps
- **Uber**: Works normally
- **Bolt**: Popular alternative
- **Taksi Helsinki**: Traditional taxis

### Costs
- Base fare: EUR 5-8
- Per km: EUR 1-2
- Airport to center: EUR 40-55

### Tips
- Expensive compared to public transport
- Book in advance for reliability
- Tipping not expected

## Airport Connections

### Helsinki-Vantaa Airport

**Train (recommended):**
- 30 minutes to Central Station
- EUR 4.10 (ABC zone)
- Runs 5:00-24:00

**Bus 615:**
- 45-50 minutes
- Same price as train
- More stops

**Taxi:**
- EUR 45-55 to center
- Fixed price options available

**Car:**
- Parking available at airport
- 25-35 minutes to center

## Night Transport

### After Metro/Tram Close (~23:30)

**Night buses (N-series):**
- Run Fri-Sat nights until ~4:00
- Cover main routes
- Normal HSL tickets valid

**Taxis:**
- Always available
- More expensive late night
- Book via apps for reliability

## Accessibility

**Generally excellent:**
- All metro stations accessible
- Most trams accessible
- Buses have ramps
- Real-time info includes accessibility

## Practical Tips

### Commuter Strategy
1. Find home near metro/tram
2. Monthly pass if commuting daily
3. HSL app for all planning
4. Consider bike for last-mile

### Tourist Strategy
1. Day pass for exploration days
2. Single tickets for light use
3. Airport train both ways
4. Tram 2/3 for city tour

### Cost Comparison

| Method | Example Trip | Cost |
|--------|--------------|------|
| HSL monthly | Daily commute | EUR 62.70/month |
| HSL single | Occasional | EUR 2.95/trip |
| Taxi | Airport | EUR 50 |
| Train | Airport | EUR 4.10 |
| City bike | Summer commute | EUR 35/season |
