# Helsinki Tech Industry

## Overview

**Helsinki is a major tech hub**, especially for gaming, mobile, and cleantech.

**Key facts:**
- Home to Nokia HQ
- Gaming giants (Supercell, Rovio, Remedy)
- Strong startup ecosystem
- High English proficiency in tech
- Government supports tech innovation

## Tech Hubs and Clusters

### Keilaniemi (Espoo)
Nokia HQ and major tech companies.
- Direct metro connection
- Corporate environment
- Many multinationals

### Ruoholahti
Tech offices, gaming companies.
- Close to city center
- Modern office buildings
- Good cafes, lunch options

### Maria 01 (Kamppi)
Largest startup campus in Nordics.
- 170+ startups
- Events, networking
- Former hospital converted

### Otaniemi (Espoo)
Aalto University tech campus.
- Research collaboration
- Deep tech startups
- Student innovation

### Pasila
Growing tech presence.
- Good transit connections
- More affordable than center
- Conference center nearby

## Major Tech Employers

### Gaming

| Company | Games | Size |
|---------|-------|------|
| Supercell | Clash of Clans, Brawl Stars | ~400 |
| Rovio | Angry Birds | ~500 |
| Remedy | Control, Alan Wake | ~350 |
| Housemarque | Returnal | ~100 |
| Next Games | Walking Dead games | ~100 |

### Telecoms/Hardware

| Company | Focus | Size |
|---------|-------|------|
| Nokia | Networks, 5G | ~5,000+ |
| HMD Global | Nokia phones | ~500 |

### Software/Services

| Company | Focus |
|---------|-------|
| Wolt | Food delivery |
| Smartly.io | Social advertising |
| Aiven | Cloud databases |
| Supermetrics | Marketing analytics |
| Swappie | Refurbished phones |

### International Offices

Many global companies have Helsinki presence:
- Google
- Microsoft
- Uber
- Amazon (AWS)
- Accenture
- KPMG, Deloitte

## Salary Ranges (Feb 2026)

### Software Development

| Level | Gross Monthly | Notes |
|-------|---------------|-------|
| Junior (0-2 yrs) | EUR 3,500-4,500 | Entry level |
| Mid (2-5 yrs) | EUR 4,500-6,000 | Independent work |
| Senior (5-10 yrs) | EUR 6,000-8,000 | Leadership, expertise |
| Lead/Principal | EUR 8,000-12,000 | Architecture, strategy |
| Director/VP | EUR 10,000-15,000+ | Management |

### Other Tech Roles

| Role | Mid-Level Range |
|------|-----------------|
| Product Manager | EUR 5,000-7,500 |
| UX Designer | EUR 4,000-6,000 |
| Data Scientist | EUR 5,000-7,500 |
| DevOps Engineer | EUR 5,000-7,000 |
| QA Engineer | EUR 4,000-5,500 |
| Scrum Master | EUR 4,500-6,000 |

### Gaming Industry

Often pays above average:
- Senior game dev: EUR 6,000-9,000
- Profit sharing/bonuses common
- Supercell famously well-compensated

### Equity/Stock

- Startups often offer equity
- Larger companies may have stock programs
- Tax treatment complex, seek advice

## Work Culture

### Finnish Tech Culture

**Positives:**
- Flat hierarchies
- Direct communication
- Work-life balance prioritized
- Flexible working common
- Trust-based management
- Good benefits

**Adjustments needed:**
- Silence in meetings is normal
- Less small talk
- Email/Slack preferred over calls
- Punctuality expected
- Summer holidays sacred (July especially)

### Typical Benefits

| Benefit | Typical |
|---------|---------|
| Vacation | 25-30 days |
| Parental leave | Generous (both parents) |
| Sick leave | Full pay |
| Lunch benefit | EUR 10-12/day |
| Sports/culture | EUR 200-500/year |
| Remote work | Flexible, often 2-3 days home |
| Equipment | Laptop, monitors provided |
| Phone | Often company plan |

### Work Hours

- Standard: 37.5-40 hours/week
- Overtime: Rare, compensated if required
- Flexible hours: Common in tech
- Core hours: Often 10:00-15:00

## Finding Tech Jobs

### Job Boards

| Platform | Notes |
|----------|-------|
| LinkedIn | Primary for tech |
| Duunitori.fi | Finnish jobs |
| Monster.fi | General jobs |
| Indeed.fi | Aggregator |
| The Hub (Helsinki) | Startup focused |
| AngelList | Startup equity jobs |

### Company Career Pages

Apply directly to:
- Supercell, Rovio (gaming)
- Wolt, Smartly (startups)
- Nokia (telecoms)
- Consulting firms

### Networking

**Events:**
- Slush (November) - Major startup conference
- Junction (November) - Hackathon
- Arctic15 (May) - Tech conference
- Meetup.com tech groups

**Communities:**
- Finnish startup scene small, connected
- Reaktor, Futurice known for community
- Gaming industry tight-knit

### Recruiters

Tech recruiters active:
- Academic Work
- Barona
- Talented
- Many specialists

## Visa/Work Permit

### EU/EEA Citizens
- No permit needed
- Register after 3 months
- Start working immediately

### Non-EU Citizens

**Options:**
- **Specialist residence permit** - Most tech workers
- **EU Blue Card** - High-skill, higher salary
- **Startup permit** - Founding company

**Specialist permit:**
- Employer sponsors
- 2-4 month processing
- Tied to employer initially
- Renewal easier

See `visas.md` for details.

## Remote Work Considerations

### From Finland

- Time zone: EET (UTC+2), EEST (UTC+3)
- Good overlap with Europe
- Morning overlap with Asia
- Afternoon overlap with East Coast US
- Difficult for West Coast US

### For Remote Jobs

- Finnish companies often remote-friendly
- Tax implications if employer abroad
- Healthcare through Kela if resident

## Learning and Development

### Education

**Aalto University:**
- Top tech education
- Strong startup culture
- Industry connections

**University of Helsinki:**
- Computer science
- Research focus

**Hive Helsinki:**
- Free coding school
- 42 network
- No prerequisites

### Bootcamps

- Hive Helsinki
- Reaktor Academy (occasional)
- Various short courses

### Communities

- Meetup groups
- Discord servers
- Slack communities (various tech)

## Starting a Tech Career in Helsinki

### With Experience

1. Apply to jobs remotely
2. Interview (often remote)
3. Negotiate relocation
4. Company helps with visa
5. Move and start

### Fresh Start

1. Study (Aalto, UH, Hive)
2. Network during studies
3. Internships common
4. Graduate and work

### From Related Field

1. Take relevant courses
2. Build portfolio
3. Apply to entry-level
4. Tech transfers happen regularly
