# Helsinki Startup Ecosystem

## Overview

**Helsinki has one of Europe's strongest startup ecosystems**, particularly for gaming, deep tech, and sustainability.

**Key strengths:**
- Slush conference (global reach)
- Strong gaming success stories
- Government support (Business Finland)
- High education levels
- Nordic collaboration

## The Ecosystem

### Major Players

**Accelerators/Incubators:**
| Program | Focus | Notes |
|---------|-------|-------|
| Startup Foundation | Pre-seed | Grants, training |
| Maria 01 | General | Largest Nordic campus |
| Kiuas | General | Accelerator program |
| NewCo Helsinki | Early stage | Free city service |
| Aalto Startup Center | University | Research spin-offs |

**Events:**
| Event | When | Focus |
|-------|------|-------|
| Slush | November | Major global conference |
| Junction | November | Europe's largest hackathon |
| Arctic15 | May/June | Tech conference |
| Startup Day | Various | Community events |

### Success Stories

**Global exits:**
- Supercell (gaming): EUR 8.6B to Tencent
- Wolt (food delivery): EUR 7B to DoorDash
- Rovio (Angry Birds): IPO, acquisition
- Unity (games): Finnish roots
- MySQL: Finnish founders

**Current unicorns/scale-ups:**
- Aiven (cloud databases)
- Smartly.io (social advertising)
- Swappie (refurbished phones)
- Relex Solutions (retail tech)
- Blueprint Genetics (health)

## Funding Landscape

### Stages and Amounts (Typical)

| Stage | Amount | Sources |
|-------|--------|---------|
| Pre-seed | EUR 50-200K | Angels, grants, accelerators |
| Seed | EUR 200K-1M | Angels, early VCs, grants |
| Series A | EUR 1-5M | VCs |
| Series B+ | EUR 5M+ | International VCs |

### Grants (Non-Dilutive)

**Business Finland:**
- **Tempo** - EUR 50K for validation
- **R&D funding** - Up to 50% of costs
- **Young Innovative Company** - Larger grants
- **NIY (Nuori Innovatiivinen Yritys)** - Special status

**Other grants:**
- ELY Center
- Horizon Europe (EU)
- Nordics funds

### Angel Investors

**FiBAN (Finnish Business Angels Network):**
- 600+ members
- Invest EUR 10-150K typically
- Often sector specialists

**Notable angels:**
- Many gaming millionaires
- Former Nokia executives
- Previous founders

### Venture Capital

**Finnish VCs:**
| VC | Focus | Stage |
|----|-------|-------|
| Lifeline Ventures | General | Seed-A |
| Inventure | General | Seed-B |
| Maki.vc | General | Seed-A |
| Voima Ventures | Deep tech | Seed-A |
| Superhero Capital | Gaming, consumer | Seed |

**Nordic VCs active in Finland:**
- Northzone
- EQT Ventures
- Creandum
- Project A
- Atomico

### Startup Permit Funding

For non-EU founders:
- Business Finland evaluates viability
- Positive evaluation needed for visa
- Access to grant system

## Support Infrastructure

### Maria 01

**Largest startup campus in Nordics.**

Location: Former hospital in Kamppi
- 170+ startups
- Events space
- Community programs
- Investor connections

### Aalto University

**Strong entrepreneurship culture:**
- Startup Center
- Aalto Ventures Program
- Student projects
- Research commercialization

### NewCo Helsinki

**Free city service:**
- Advisors for new businesses
- Workshops
- Connections
- Available in English

### Startup Life

**Community-building org:**
- Events
- Startup sauna
- Resources for founders

## Practical Startup Matters

### Legal Structure

**Oy (Osakeyhtioe)** is standard:
- EUR 2,500 minimum capital
- 1-2 weeks to register
- Investor-friendly

### Equity and Vesting

**Finnish norms:**
- 4-year vesting typical
- 1-year cliff standard
- Option pools 10-15%
- Founder vesting varies

### Employee Stock Options

**Tax-favorable regime:**
- Options can be tax-efficient
- Complex rules, consult accountant
- Important for hiring

### IP Protection

**Strong IP regime:**
- PRH handles trademarks, patents
- EU-wide protection available
- Consult IP lawyer for strategy

## Hiring for Startups

### Finding Talent

**Channels:**
- LinkedIn
- The Hub Helsinki
- Aalto/University networks
- Slush/event networking
- Referrals

### Competing with Corporates

**Startups offer:**
- Equity upside
- Impact/ownership
- Flexibility
- Learning opportunity

**Challenges:**
- Lower base salary often
- Less stability
- Benefits may be simpler

### International Hiring

- Startup permit for non-EU founders
- Specialist permit for employees
- English common in tech startups
- Relocation support often provided

## Challenges

### Small Market

- Finland: 5.5M people
- Nordics: ~27M people
- **Go international early**

### Talent Competition

- Big companies pay well
- Limited senior talent pool
- International hiring important

### Bureaucracy

- Improving but exists
- Permits take time
- Language barriers in government

### Winter and Darkness

- Affects productivity/mood
- Remote team challenges
- Plan for it

## Tips for Founders

### Do

- Apply for Business Finland grants early
- Network at Slush, events
- Use accelerators for structure
- Think international from day 1
- Leverage Nordic connections
- Build diverse team

### Don't

- Underestimate grants (free money!)
- Ignore the gaming network
- Expect US-style hustle culture
- Overlook work-life balance expectations

## Resources

### Online

- **Slush.org**: Conference, content
- **Maria01.com**: Campus
- **BusinessFinland.fi**: Grants
- **NewCoHelsinki.fi**: Free advice
- **FiBAN.fi**: Angels

### Books/Reading

- "The Finnish Line" (startup stories)
- Slush blog
- Nordic Business Report

### Communities

- Slush community
- Finland Founders (Facebook)
- Various Slack groups
- Aalto Entrepreneurship Society

## Startup Visa Path

### Process

1. **Develop business plan**
2. **Apply to Business Finland** for evaluation
3. **Receive eligibility statement** (positive/negative)
4. **Apply for residence permit** at Migri
5. **Start company** in Finland

### What Business Finland Evaluates

- Innovation level
- Scalability
- Team capability
- Execution plan
- Finland relevance

### Timeline

- Evaluation: 2-4 weeks
- Residence permit: 1-3 months
- Total: 2-4 months typically

### Success Tips

- Clear, scalable business model
- Team with relevant experience
- Why Finland specifically
- Realistic plan

See `visas.md` for permit details.
