# Helsinki Safety and Laws

## Overall Safety

**Finland consistently ranks among world's safest countries.**

| Metric | Rating |
|--------|--------|
| Overall safety | Excellent |
| Violent crime | Very rare |
| Petty crime | Low |
| Scams targeting tourists | Rare |
| Women traveling alone | Very safe |
| LGBTQ+ safety | Very safe (legally protected) |
| Night safety | Good |

## Crime Reality

### What Exists (Rare)
- Bicycle theft (lock your bike)
- Occasional pickpocketing (crowded events)
- Bar-related incidents (late night, alcohol-involved)
- Online scams (general, not Helsinki-specific)

### What's Essentially Non-Existent
- Violent street crime
- Mugging
- Kidnapping
- Organized crime affecting visitors
- Terrorism

### Safe Practices
- Normal precautions sufficient
- Lock bike properly
- Keep valuables secure in crowds
- Avoid very drunk people late night
- Trust your instincts (but they rarely trigger here)

## Legal Framework

### Drugs

**Zero tolerance policy.** Strictly enforced.

| Substance | Legal Status |
|-----------|--------------|
| Cannabis | Illegal (all forms) |
| Recreational drugs | Illegal |
| Prescription drugs | Legal with prescription |
| Drug paraphernalia | Illegal |

**Consequences:**
- Fines for small amounts
- Imprisonment for larger amounts
- Can affect residence permit (non-citizens)
- Employment consequences

**Note:** Despite some social acceptance debate, it is illegal and enforced.

### Alcohol

| Rule | Details |
|------|---------|
| Legal age (beer/wine) | 18 |
| Legal age (spirits) | 20 |
| Purchase hours | Supermarket until 21:00 |
| Alko hours | ~10:00-18:00/20:00 |
| Public drinking | Restricted (parks somewhat tolerated in summer) |
| Drink driving | 0.5 per mille limit, strictly enforced |

**Drink driving consequences:**
- Immediate license suspension
- Heavy fines
- Possible imprisonment
- Criminal record

### Traffic Laws

| Rule | Details |
|------|---------|
| Speed limits | 20-120 km/h depending on road |
| Seat belts | Required all passengers |
| Child seats | Required by height/weight |
| Phone while driving | Hands-free only |
| Winter tires | Required Dec 1 - Feb 28 |
| Headlights | Required always |
| Right of way | Trams always have priority |

**Fines are income-based.** High earners pay much more.

### Cycling Laws

| Rule | Details |
|------|---------|
| Lights | Required when dark |
| Helmet | Recommended, not required |
| Bike lanes | Use when available |
| Pedestrians | Yield on shared paths |
| Drunk cycling | Technically illegal |

### Public Behavior

| Behavior | Legal? |
|----------|--------|
| Public intoxication | Fine possible |
| Urinating in public | Fine |
| Littering | Fine |
| Noise after 22:00 | Complaints can lead to fines |
| Photography in public | Generally OK, respect privacy |
| Photography of military/government | Ask permission |

## Everyman's Right (Jokamiehen oikeus)

**Unique Nordic concept.** Anyone can:
- Walk, ski, cycle on any land (not yards/fields)
- Swim and boat in waters
- Pick wild berries and mushrooms
- Fish with simple rod and line
- Camp temporarily (away from homes)

**Cannot:**
- Damage nature
- Disturb wildlife
- Make fires without permission
- Drive motor vehicles off-road
- Hunt without license
- Cut down trees

## Emergency Services

### Emergency Number: 112

Works for:
- Police
- Fire
- Ambulance
- Rescue

**English-speaking operators available.**

### Non-Emergency Contacts

| Service | Number |
|---------|--------|
| Police non-emergency | 0295 419 800 |
| Health advice | 116 117 |
| Poison center | 0800 147 111 |
| Crisis line | 09 2525 0111 |

### Hospital Emergency

**Go directly to:**
- Haartman (Helsinki center)
- Jorvi (Espoo)
- Peijas (Vantaa)

For life-threatening: Call 112

## Legal System

### If Arrested/Questioned

Rights:
- Right to lawyer
- Right to interpreter
- Right to contact embassy (non-citizens)
- Right to remain silent

Process:
- Generally fair and transparent
- No plea bargaining system
- Fines often income-based
- Court proceedings in Finnish/Swedish (interpreter provided)

### Legal Aid

- Available for those who cannot afford lawyer
- EU citizens have some protections
- Embassy can provide lawyer lists

## Specific Situations

### Lost/Stolen Items

**Report to police:**
- Online (poliisi.fi) or in person
- Needed for insurance claims
- Lost property often returned (honest society)

**Lost cards:**
- Cancel immediately via bank app
- Finnish banks have 24h numbers

### Medical Emergency

1. Life-threatening: Call 112
2. Urgent but not emergency: Paeivystys (emergency room)
3. Non-urgent: Health center (terveysasema)
4. Advice: 116 117

### Traffic Accident

1. Ensure safety
2. Call 112 if injuries
3. Exchange information
4. Take photos
5. File insurance claim
6. Police report if significant

### Natural Hazards

| Hazard | Risk | When |
|--------|------|------|
| Slippery ice | Moderate | Nov-Mar |
| Extreme cold | Low-Moderate | Jan-Feb |
| Dark season | Mental health | Nov-Jan |
| Summer storms | Low | Jun-Aug |
| Forest fires | Very low | Dry summers |

**Winter safety:**
- Proper footwear essential
- Ice grips available
- Watch for falling ice from buildings
- Frostbite risk below -20C

## Women's Safety

**Excellent.** Finland among safest for women.

- Walk alone at night: Generally safe
- Public transport: Safe
- Bars/clubs: Normal precautions
- Harassment: Rare, taken seriously
- Support services: Available

## LGBTQ+ Safety

**Very safe.** Strong legal protections.

- Same-sex marriage: Legal since 2017
- Discrimination: Illegal
- Pride events: Well-attended, safe
- Social acceptance: High
- Trans rights: Legal gender recognition

## Scams to Know

Rare but exist:
- Online marketplace scams (Tori.fi)
- Rental scams (fake listings)
- Romance scams (online)
- Phone scams (fake calls)

**Prevention:**
- Verify before paying
- Meet in person for transactions
- Use secure payment methods
- If too good to be true, it is
