# Moving to Helsinki

## Pre-Move Checklist

### Before Arrival

| Task | Notes |
|------|-------|
| Secure residence permit (non-EU) | Process takes 1-4 months |
| Job offer or acceptance letter | Needed for work permit |
| Housing research | Competitive market |
| EU Health Insurance Card (EHIC) | If from EU |
| Savings | 3-6 months expenses recommended |
| Document apostilles | Birth certificate, degrees |

### First Week

| Task | Priority | Where |
|------|----------|-------|
| Register residence | High | DVV (Digital and Population Data Agency) |
| Open bank account | High | Any bank with appointment |
| Get Finnish ID (henkiloetunnus) | High | Via DVV registration |
| Register address | High | DVV or Posti |
| Get HSL travel card | Medium | R-kioski or HSL service point |
| SIM card | Medium | Any operator |

### First Month

| Task | Notes |
|------|-------|
| Apply for Kela (social insurance) | After registration |
| Register with health center | With Kela card |
| Set up MyKanta (health records) | After ID |
| Tax card (verokortti) | For salary |
| Explore neighborhood | Practical |

## Registration Process

### DVV Registration (Maistraatti)

**Required for stays over 1 year.** Gives you Finnish personal ID (henkiloetunnus).

**Required documents:**
- Valid passport
- Residence permit (non-EU) or EU passport
- Proof of address (rental contract)
- Employment contract or enrollment letter

**Process:**
1. Book appointment online (DVV.fi)
2. Bring all documents
3. Receive temporary ID
4. Permanent letter arrives in 1-2 weeks

**The henkiloetunnus is everything.** Without it:
- Cannot open bank account
- Cannot get phone contract
- Cannot access most services

### EU Citizens

Simpler process:
- Register right to reside after 3 months
- Same DVV appointment
- EU passport sufficient
- No permit needed for work

### Non-EU Citizens

Must have valid permit:
- Work permit (tied to employer usually)
- Startup permit
- Student permit
- Family permit

See `visas.md` for details.

## Housing

### The Market

**Competitive.** Helsinki has housing shortage.
- Expect to respond quickly to listings
- References help
- First/last month + deposit typical

### Rental Process

1. **Search**: Oikotie.fi, Vuokraovi.fi, Facebook groups
2. **Apply**: Often many applicants per unit
3. **Viewing**: Be prepared to decide fast
4. **Documents**: ID, proof of income, references
5. **Contract**: Typically 1 year minimum, check terms

### Typical Costs (Feb 2026)

| Type | Location | Monthly Rent |
|------|----------|--------------|
| Studio | Center | EUR 800-1,200 |
| 1BR | Center | EUR 1,200-1,800 |
| 1BR | Kallio | EUR 900-1,300 |
| 2BR | Suburbs | EUR 1,000-1,400 |
| 3BR | Family areas | EUR 1,400-2,000 |

### Utilities

Often NOT included in rent:
- **Electricity**: EUR 30-80/month
- **Water**: Sometimes included, otherwise EUR 20-40
- **Internet**: EUR 20-40/month
- **Heating**: Often included (district heating common)

### Tips

- **Furnished rare**: Most apartments unfurnished
- **Tori.fi**: Secondhand furniture
- **IKEA**: Standard for new arrivals
- **Moving help**: Rinki.fi, muutto services

## Banking

### Opening Account

**Requirements:**
- Passport
- Finnish ID number (or proof of registration in progress)
- Proof of address
- Reason for account (work, study)

**Process:**
1. Book appointment with bank
2. Bring documents
3. Usually same-day approval
4. Card arrives 1-2 weeks

### Major Banks
- **Nordea**: Largest, English service
- **OP**: Cooperative, good service
- **Danske Bank**: International
- **S-Pankki**: Connected to S-Group

### Digital Banks
- **N26**, **Revolut**: Work but may have limitations
- Good for interim use
- Some services need Finnish bank

### Mobile Payments
- **MobilePay**: Common in Nordics
- **Apple Pay/Google Pay**: Widely accepted
- Cards with contactless: Universal

## Phone and Internet

### Mobile Operators
- **Elisa**: Largest
- **DNA**: Good coverage
- **Telia**: Third major

**Prepaid SIM**: Available immediately at R-kioski
**Contract**: Requires Finnish ID, better deals

### Typical Costs
- **Prepaid**: EUR 10-20/month
- **Contract unlimited**: EUR 20-30/month
- **Home internet**: EUR 20-40/month

### Tips
- 4G/5G excellent coverage
- Unlimited data common and cheap
- Bundle home + mobile for savings

## Health Registration

### Kela (Social Insurance)

**Covers:**
- Healthcare subsidies
- Unemployment benefits
- Family benefits
- Student benefits

**To get Kela card:**
1. Register with DVV
2. Apply at Kela.fi (in English)
3. Card arrives by mail

### Health Center (Terveysasema)

**Register with local health center after Kela card.**

- Primary care, basic services
- Small fees (EUR 20-40/visit)
- Appointments via app or phone

### Private Healthcare

- Faster access
- More expensive
- Many use for convenience
- Work often includes private insurance

See `healthcare.md` for full details.

## Tax Registration

### Tax Card (Verokortti)

**Needed before first salary.**

**Process:**
1. Register at vero.fi
2. Apply for tax card online
3. Submit to employer

### Tax Levels

Progressive taxation:
- **Income under EUR 20,000**: ~15-20%
- **EUR 20,000-50,000**: ~25-35%
- **EUR 50,000-100,000**: ~40-45%
- **Over EUR 100,000**: ~50%

Includes municipal tax, church tax (optional), state tax.

### Filing

- Tax year: Calendar year
- Pre-filled return in spring
- Easy online process
- Most get refunds

## Settling In Tips

### First Grocery Shop
- S-Market or K-Market nearby
- Get loyalty card (S-Etukortti, K-Plussa)
- Download store app for offers

### Transportation Setup
- HSL app essential
- Get travel card for commute
- AB zone covers Helsinki proper

### Social Integration
- Expat groups on Facebook
- Meetup.com events
- Sports clubs
- Language exchange

### Winter Preparation
- Quality winter coat
- Waterproof boots with grip
- Vitamin D supplements
- Light therapy lamp (optional)

### Essential Apps
- **HSL**: Transport
- **MobilePay**: Payments
- **Wolt**: Food delivery
- **Oura/S-mobiili**: Shopping
- **Kanta**: Health records
- **OmaVero**: Taxes

## Timeline: First 3 Months

### Month 1
- Registration complete
- Bank account open
- Phone working
- Housing settled
- Basic routine established

### Month 2
- Kela card received
- Health center registered
- Tax card submitted
- Exploring city
- Finding routines

### Month 3
- Fully operational
- Social connections forming
- Understanding systems
- Planning long-term
