# Local Services in Helsinki

## Banking

### Major Banks

| Bank | Notes |
|------|-------|
| Nordea | Largest, good English service |
| OP (Osuuspankki) | Cooperative, popular |
| Danske Bank | International |
| S-Pankki | S-Group connected |
| Handelsbanken | Swedish, good service |

### Opening Account

**Requirements:**
- Finnish ID (henkiloetunnus) or proof of registration
- Passport
- Proof of address
- Reason for account (employment, study)

**Process:**
1. Book appointment online
2. Bring documents
3. Usually approved same day
4. Card arrives 1-2 weeks

**Tips:**
- Some banks harder for non-residents
- OP often recommended for new arrivals
- Digital banks (N26, Revolut) work as interim

### Services

**All major banks offer:**
- Mobile banking apps (English)
- Contactless payments
- Online bill pay (eLaskut)
- Mobile payments (MobilePay)

## Phone and Internet

### Mobile Operators

| Operator | Network | Notes |
|----------|---------|-------|
| Elisa | Own | Largest, good coverage |
| DNA | Own | Competitive prices |
| Telia | Own | International brand |
| Moi | Uses Telia | Budget option |

### Getting SIM Card

**Prepaid (immediate):**
- Buy at R-kioski, supermarket, airport
- No registration needed
- Data packages available
- Good for tourists, temporary use

**Contract (better value):**
- Requires Finnish ID
- Much better prices
- Unlimited data common
- Online ordering easy

### Typical Plans (Feb 2026)

| Type | Data | Price/Month |
|------|------|-------------|
| Prepaid | 5GB | EUR 15-20 |
| Contract basic | Unlimited | EUR 20-25 |
| Contract premium | Unlimited + extras | EUR 30-40 |

### Home Internet

| Provider | Type | Speed | Price |
|----------|------|-------|-------|
| DNA | Fiber | 100-1000 Mbps | EUR 25-50 |
| Elisa | Fiber | 100-1000 Mbps | EUR 25-50 |
| Telia | Fiber | 100-1000 Mbps | EUR 25-50 |

**Tips:**
- Check building connections first
- Fiber common in newer buildings
- Bundle with mobile for savings

## Post and Mail

### Posti (Finnish Post)

**Services:**
- Mail delivery
- Package pickup/delivery
- Parcel lockers (Posti automaatti)

**Pickup locations:**
- Posti offices (declining)
- R-kioski
- S-Market, K-Market
- Parcel lockers (24/7)

### Addresses

Finnish addresses format:
```
Name
Street Name Number
POSTAL CODE CITY
```

Example:
```
Matti Meikaelainen
Mannerheimintie 15 A 23
00100 HELSINKI
```

A 23 = Stairway A, Apartment 23

### International Shipping

**To Finland:**
- EU packages no customs under EUR 150
- Non-EU may have customs fees
- Track via carrier or 17track

**From Finland:**
- Posti for letters, small packages
- DHL, UPS, FedEx for commercial

## Shopping

### Supermarkets

| Chain | Type | Notes |
|-------|------|-------|
| S-Market | Mid-range | S-Group, S-Etukortti card |
| K-Market | Mid-range | K-Group, K-Plussa card |
| Prisma | Large | S-Group, best selection |
| K-Citymarket | Large | K-Group, wide range |
| Lidl | Budget | German, good value |
| Alepa | Convenience | S-Group, late hours |

### Loyalty Cards

**S-Etukortti (S-Group):**
- Bonus based on purchases
- Works at S-Markets, Prisma, ABC, etc.
- Free to get

**K-Plussa (K-Group):**
- Points for purchases
- Works at K-Markets, K-Citymarket
- Free to get

### Shopping Hours

| Day | Typical Hours |
|-----|---------------|
| Monday-Friday | 7:00/8:00 - 21:00/22:00 |
| Saturday | 8:00 - 21:00 |
| Sunday | 12:00 - 18:00 (limited) |

**Exceptions:**
- Alepa, some K-Markets open late
- Stockmann until 21:00
- Malls often 10:00-21:00

### Alcohol Purchases

**Supermarkets:**
- Beer, cider up to 5.5%
- Until 21:00

**Alko:**
- Wine, spirits, strong beer
- Mon-Fri ~10:00-18:00/20:00
- Sat ~10:00-16:00/18:00
- Closed Sunday

## Healthcare Access

See `healthcare.md` for full details.

### Quick Reference

| Need | Where |
|------|-------|
| Emergency | 112 |
| Urgent care | Paeivystys |
| Regular care | Terveysasema (health center) |
| Advice line | 116 117 |
| Pharmacy | Apteekki |

### Pharmacies (Apteekki)

**Types:**
- Regular: Normal hours
- Paeivystysapteekki: Extended hours, 24h

**24h Pharmacy:**
- Yliopiston Apteekki (Central Station area)
- Itaekeskus

**Prescription meds:**
- Need Finnish prescription
- Or EU prescription with some process
- Some medications OTC that are prescription elsewhere

## Essential Services

### Libraries (Kirjasto)

**Excellent public libraries. Free to use.**

**Oodi Central Library:**
- Stunning architecture
- 3D printers, music studios
- Gaming area
- Cafe, events
- Free WiFi, workspaces

**Local libraries:**
- Every neighborhood has one
- Books in many languages
- Free events, classes
- Computer access

### Swimming

**Public pools (uimahalli):**
- Multiple across city
- EUR 5-8 entry
- Includes sauna usually

**Popular pools:**
- Yrjoenkatu (central, historic)
- Maekelae (large, modern)
- Itaekeskus (eastern)

### Gyms

**Chains:**
- Elixia (upscale)
- SATS (mid-range)
- Fitness24Seven (budget, 24h)
- EasyFit (budget)

**Prices:**
- Budget: EUR 20-30/month
- Mid-range: EUR 40-60/month
- Premium: EUR 80-120/month

### Saunas

**Public saunas:**
- Loyly (modern, touristy)
- Allas Sea Pool (central, views)
- Kotiharjun Sauna (traditional, Kallio)
- Kulttuurisauna (design)

**Building saunas:**
- Most apartment buildings have one
- Bookable time slots
- Free or small fee

## Government Services

### Digital Services

**Suomi.fi:**
- Central portal for government services
- English available
- Bank ID login

**Key services:**
- DVV (population registration)
- Kela (social insurance)
- Vero (taxes)
- Migri (immigration)

### In-Person

Most services by appointment:
- Book online
- Bring required documents
- English often available

## Recycling

**Finland has excellent recycling.**

### At Home

| Waste Type | Bin Color | Notes |
|------------|-----------|-------|
| Bio/organic | Brown | Composted |
| Paper/cardboard | Blue | Recycled |
| Plastic | Yellow | Packaging |
| Metal | Grey | Cans, etc. |
| Glass | Green | Bottles, jars |
| Mixed waste | Black | Landfill |

### Bottle Return

**Pantti (deposit) system:**
- Plastic bottles: EUR 0.10-0.40
- Cans: EUR 0.15
- Return at any supermarket machine
- Keep receipts or donate

### Recycling Centers

**Sortti stations:**
- Electronics, furniture, hazardous
- Free for households
- Multiple locations
